/* 2014.09.09
*****************************************
**   Copyright  (C)  W.ch  1999-2019   **
**   Web:      http://wch.cn           **
*****************************************
**  USB-flash File Interface for CHRV3 **
**  KEIL423, gcc 8.20          **
*****************************************
*/
/* CHRV3 Uļϵͳӿ, ֧: FAT12/FAT16/FAT32 */

//#include "CHRV3BAS.H"

#ifndef __CHRV3UFI_H__
#define __CHRV3UFI_H__



#define CHRV3_LIB_VER		0x10

//#define DISK_BASE_BUF_LEN		512	/* ĬϵĴݻСΪ512ֽ(ѡΪ20484096֧ĳЩU),Ϊ0ֹڱļж建ӦópDISK_BASE_BUFָ */
/* ҪôݻԽԼRAM,ôɽDISK_BASE_BUF_LENΪ0Խֹڱļж建,ӦóڵCHRV3LibInit֮ǰõĻʼַpDISK_BASE_BUF */

//#define NO_DEFAULT_ACCESS_SECTOR	    1		/* ֹĬϵĴдӳ,бдĳ */
//#define NO_DEFAULT_DISK_CONNECT		1		/* ֹĬϵļӳ,бдĳ */
//#define NO_DEFAULT_FILE_ENUMER		1		/* ֹĬϵļöٻص,бдĳ */
#define FOR_ROOT_UDISK_ONLY           1
#ifdef __cplusplus
extern "C" {
#endif

/* ********************************************************************************************************************* */

/* FILE: CHRV3UF.H */

/*  */
#ifndef ERR_SUCCESS
#define ERR_SUCCESS				0x00	/* ɹ */
#endif
#ifndef ERR_DISK_DISCON
#define ERR_CHRV3_ERROR			0x81	/* CHRV3Ӳ,ҪλCHRV3 */
//#define ERR_DISK_DISCON			0x82	/* δ,ܴѾϿ */
#define ERR_STATUS_ERR			0x83	/* ״̬,ӻ߶Ͽ */
#define ERR_HUB_PORT_FREE		0x84	/* USB-HUBѾӵHUB˿δӴ,ܴѾϿ */
#define ERR_MBR_ERROR			0x91	/* ̵¼Ч,ܴδδʽ */
#define ERR_TYPE_ERROR			0x92	/* ̷Ͳ֧,ֻ֧FAT12/FAT16/BigDOS/FAT32,Ҫɴ̹· */
#define ERR_BPB_ERROR			0xA1	/* δʽ,߲,ҪWINDOWSĬϲ¸ʽ */
#define ERR_TOO_LARGE			0xA2	/* ̷ʽ4GB,250GB,ҪWINDOWSĬϲ¸ʽ */
#define ERR_FAT_ERROR			0xA3	/* ̵ļϵͳ֧,ֻ֧FAT12/FAT16/FAT32,ҪWINDOWSĬϲ¸ʽ */
#define ERR_DISK_FULL			0xB1	/* ļ̫,ʣռ̫ٻѾû,Ҫ */
#define ERR_FDT_OVER			0xB2	/* Ŀ¼ļ̫,ûпеĿ¼,FAT12/FAT16Ŀ¼µļӦ500,Ҫ */
#define ERR_MISS_DIR			0xB3	/* ָ·ĳĿ¼ûҵ,Ŀ¼ƴ */
#define ERR_FILE_CLOSE			0xB4	/* ļѾر,Ҫʹ,Ӧ´ļ */
#define ERR_OPEN_DIR			0x41	/* ָ·Ŀ¼ */
#define ERR_MISS_FILE			0x42	/* ָ·ļûҵ,ļƴ */
#define ERR_FOUND_NAME			0x43	/* ͨƥļ,ļ·,Ҫʹ,Ӧô򿪸ļ */
#endif
/* 2XH-3XHUSBʽͨѶʧܴ,CHRV3ӳģCH375ķ */
/* 1XHUSBʽĲ״̬,CHRV3ӳģCH375ķ */
#ifndef ERR_USB_CONNECT
#define	ERR_USB_CONNECT_LS		0x13	/* ⵽USB豸¼ */
#define	ERR_USB_CONNECT			0x15	/* ⵽USB豸¼,Ѿ */
#define	ERR_USB_DISCON			0x16	/* ⵽USB豸Ͽ¼,ѾϿ */
#define	ERR_USB_BUF_OVER		0x17	/* USB̫໺ */
#define	ERR_USB_DISK_ERR		0x1F	/* USB洢ʧ,ڳʼʱUSB洢֧,ڶдпǴ𻵻ѾϿ */
#define	ERR_USB_TRANSFER		0x20	/* NAK/STALLȸ0x20~0x2F */
#endif

/* ̼ļ״̬ */
#define DISK_UNKNOWN			0x00	/* δʼ,δ֪״̬ */
#define DISK_DISCONNECT			0x01	/* ûӻѾϿ */
#define DISK_CONNECT			0x02	/* Ѿ,δʼ޷ʶô */
#define DISK_USB_ADDR			0x04	/* ѾUSB豸ַ,δUSBͳʼ */
#define DISK_MOUNTED			0x05	/* Ѿʼɹ,δļϵͳļϵͳ֧ */
#define DISK_READY				0x10	/* Ѿ̵ļϵͳܹ֧ */
#define DISK_OPEN_ROOT			0x12	/* Ѿ򿪸Ŀ¼,ģʽ,ֻΪλдĿ¼,ʹúر,עFAT12/FAT16Ŀ¼ǹ̶ */
#define DISK_OPEN_DIR			0x13	/* ѾĿ¼,ģʽ,ֻΪλдĿ¼ */
#define DISK_OPEN_FILE			0x14	/* Ѿļ,ģʽ,Ϊλݶд */
#define DISK_OPEN_FILE_B		0x15	/* Ѿļ,ֽģʽ,ֽΪλݶд */

/* FATͱ־ */
#ifndef DISK_FAT16
#define DISK_FS_UNKNOWN			0		/* δ֪ļϵͳ */
#define DISK_FAT12				1		/* FAT12ļϵͳ */
#define DISK_FAT16				2		/* FAT16ļϵͳ */
#define DISK_FAT32				3		/* FAT32ļϵͳ */
#endif

/* FATļĿ¼Ϣ */
typedef struct _FAT_DIR_INFO {
	uint8_t	DIR_Name[11];				/* 00H,ļ,11ֽ,㴦ո */
	uint8_t	DIR_Attr;					/* 0BH,ļ,ο˵ */
	uint8_t	DIR_NTRes;					/* 0CH */
	uint8_t	DIR_CrtTimeTenth;			/* 0DH,ļʱ,0.1뵥λ */
	uint16_t	DIR_CrtTime;				/* 0EH,ļʱ */
	uint16_t	DIR_CrtDate;				/* 10H,ļ */
	uint16_t	DIR_LstAccDate;				/* 12H,һδȡ */
	uint16_t	DIR_FstClusHI;				/* 14H */
	uint16_t	DIR_WrtTime;				/* 16H,ļ޸ʱ,οMAKE_FILE_TIME */
	uint16_t	DIR_WrtDate;				/* 18H,ļ޸,οMAKE_FILE_DATA */
	uint16_t	DIR_FstClusLO;				/* 1AH */
	uint32_t	DIR_FileSize;				/* 1CH,ļ */
} FAT_DIR_INFO;							/* 20H */

typedef FAT_DIR_INFO *PX_FAT_DIR_INFO;

/* ļ */
#define ATTR_READ_ONLY			0x01	/* ļΪֻ */
#define ATTR_HIDDEN				0x02	/* ļΪ */
#define ATTR_SYSTEM				0x04	/* ļΪϵͳ */
#define ATTR_VOLUME_ID			0x08	/*  */
#define ATTR_DIRECTORY			0x10	/* Ŀ¼ */
#define ATTR_ARCHIVE			0x20	/* ļΪ浵 */
#define ATTR_LONG_NAME			( ATTR_READ_ONLY | ATTR_HIDDEN | ATTR_SYSTEM | ATTR_VOLUME_ID )
/* ļ uint8_t */
/* bit0 bit1 bit2 bit3 bit4 bit5 bit6 bit7 */
/*  ֻ      ϵ      Ŀ      δ   */
/*        ͳ      ¼               */
/* ļʱ uint16_t */
/* Time = (Hour<<11) + (Minute<<5) + (Second>>1) */
#define MAKE_FILE_TIME( h, m, s )	( (h<<11) + (m<<5) + (s>>1) )	/* ָʱļʱ */
/* ļ uint16_t */
/* Date = ((Year-1980)<<9) + (Month<<5) + Day */
#define MAKE_FILE_DATE( y, m, d )	( ((y-1980)<<9) + (m<<5) + d )	/* ָյļ */

/* ļ */
#define PATH_WILDCARD_CHAR		0x2A	/* ·ͨ '*' */
#define PATH_SEPAR_CHAR1		0x5C	/* ·ķָ '\' */
#define PATH_SEPAR_CHAR2		0x2F	/* ·ķָ '/' */
#ifndef MAX_PATH_LEN
#define MAX_PATH_LEN			64		/* ·,бָܷСԼ·00H */
#endif

/* ⲿ */
typedef union _CMD_PARAM
{
    struct
    {
        uint8_t mBuffer[ MAX_PATH_LEN ];
    } Other;
    struct
    {
        uint32_t mTotalSector;          /* : ǰ߼̵ */
        uint32_t mFreeSector;           /* : ǰ߼̵ʣ */
        uint32_t mSaveValue;
    } Query;                            /* CMD_DiskQuery, ѯϢ */
    struct
    {
        uint8_t mPathName[ MAX_PATH_LEN ];  /* : ·: [̷,ð,б,Ŀ¼ļչ...,00H], ̷ðſʡ, "C:\DIR1.EXT\DIR2\FILENAME.EXT",00H */
    } Open;                             /* CMD_FileOpen, ļ */
//  struct
//  {
//      uint8_t mPathName[ MAX_PATH_LEN ];  /* : ·: [̷,ð,б,Ŀ¼ļչ(ͨ*)...,00H], ̷ðſʡ, "C:\DIR1.EXT\DIR2\FILE*",00H */
//  } Open;                             /* CMD_FileOpen, öļ, CHRV3vFileSizeλΪ1xFileNameEnumer,Ϊ0򷵻ָŵļ */
    struct
    {
        uint8_t mUpdateLen;             /* : Ƿ³: 0ֹ,1 */
    } Close;                            /* CMD_FileClose, رյǰļ */
    struct
    {
        uint8_t mPathName[ MAX_PATH_LEN ];  /* : ·: [̷,ð,б,Ŀ¼ļչ...,00H], ̷ðſʡ, "C:\DIR1.EXT\DIR2\FILENAME.EXT",00H */
    } Create;                           /* CMD_FileCreate, ½ļ,ļѾɾ½ */
    struct
    {
        uint8_t mPathName[ MAX_PATH_LEN ];  /* : ·: [̷,ð,б,Ŀ¼ļչ...,00H], ̷ðſʡ, "C:\DIR1.EXT\DIR2\FILENAME.EXT",00H */
    } Erase;                            /* CMD_FileErase, ɾļر */
    struct
    {
        uint32_t mFileSize;             /* : µļ,Ϊ0FFFFFFFFH޸, : ԭ */
        uint16_t mFileDate;             /* : µļ,Ϊ0FFFFH޸, : ԭ */
        uint16_t mFileTime;             /* : µļʱ,Ϊ0FFFFH޸, : ԭʱ */
        uint8_t  mFileAttr;             /* : µļ,Ϊ0FFH޸, : ԭ */
    } Modify;                           /* CMD_FileQuery, ѯǰļϢ; CMD_FileModify, ѯ޸ĵǰļϢ */
    struct
    {
        uint32_t mSaveCurrClus;
        uint32_t mSaveLastClus;
    } Alloc;                            /* CMD_FileAlloc, ļȵΪļĴ̿ռ */
    struct
    {
        uint32_t mSectorOffset;      /* : ƫ,0ƶļͷ,0FFFFFFFFHƶļβ, : ǰļָӦľ, 0FFFFFFFFHѵļβ */
        uint32_t mLastOffset;
    } Locate;                           /* CMD_FileLocate, ƶǰļָ */
    struct
    {
        uint8_t mSectorCount;           /* : ȡ, : ʵʶȡ */
        uint8_t mActCnt;
        uint8_t mLbaCount;
        uint8_t mRemainCnt;
        uint8_t *mDataBuffer;           /* : ʼַ, : ǰַ */
        uint32_t mLbaStart;
    } Read;                             /* CMD_FileRead, ӵǰļȡ */
    struct
    {
        uint8_t mSectorCount;           /* : д, : ʵд */
        uint8_t mActCnt;
        uint8_t mLbaCount;
        uint8_t mAllocCnt;
        uint8_t *mDataBuffer;           /* : ʼַ, : ǰַ */
        uint32_t mLbaStart;
        uint32_t mSaveValue;
    } Write;                            /* CMD_FileWrite, ǰļд */
    struct
    {
        uint32_t mDiskSizeSec;          /* : ̵, ״εʱ */
    } DiskReady;                        /* CMD_DiskReady, ѯ̾ */
    struct
    {
        uint32_t mByteOffset;           /* : ֽΪλƫ, ֽΪλļָ, : ǰļָӦľ, 0FFFFFFFFHѵļβ */
        uint32_t mLastOffset;
    } ByteLocate;                       /* CMD_ByteLocate, ֽΪλƶǰļָ */
    struct
    {
        uint16_t mByteCount;            /* : ׼ȡֽ, : ʵʶֽ */
        uint8_t *mByteBuffer;           /* : ָŶݿĻ */
        uint16_t mActCnt;
    } ByteRead;                         /* CMD_ByteRead, ֽΪλӵǰļȡݿ */
    struct
    {
        uint16_t mByteCount;            /* : ׼дֽ, : ʵдֽ */
        uint8_t *mByteBuffer;           /* : ָŶݿĻ */
        uint16_t mActCnt;
    } ByteWrite;                        /* CMD_ByteWrite, ֽΪλǰļдݿ */
    struct
    {
        uint8_t mSaveVariable;          /* : Ϊ0ָU̵ı,Ϊ0x80ָU̵ı,ֵ򱸷/ */
        uint8_t mReserved[3];
        uint8_t *mBuffer;               /* : ָӳııݻ,ȲС80ֽ */
    } SaveVariable;                     /* CMD_SaveVariable, //ָӳı */
} CMD_PARAM;

typedef CMD_PARAM CMD_PARAM_I;
//typedef CMD_PARAM *P_CMD_PARAM;

/* SCSI */
#ifndef SPC_CMD_INQUIRY
#define SPC_CMD_INQUIRY			0x12
#define SPC_CMD_READ_CAPACITY	0x25
#define SPC_CMD_READ10			0x28
#define SPC_CMD_WRITE10			0x2A
#define SPC_CMD_TEST_READY		0x00
#define SPC_CMD_REQUEST_SENSE	0x03
#define SPC_CMD_MODESENSE6		0x1A
#define SPC_CMD_MODESENSE10		0x5A
#define SPC_CMD_START_STOP		0x1B
#endif

/* FILE: CHRV3UFI.C */
#define EN_DISK_WRITE			1

#ifndef DISK_BASE_BUF_LEN
#define DISK_BASE_BUF_LEN		512		/* ĬϵĴݻСΪ512ֽ,ѡΪ20484096֧ĳЩU,Ϊ0ֹ.Hļж建ӦópDISK_BASE_BUFָ */
#endif

/* ӳṩı */
extern  volatile uint8_t CHRV3IntStatus;  /* CHRV3ж״̬ */
extern  volatile uint8_t CHRV3DiskStatus; /* ̼ļ״̬ */
extern  uint8_t  CHRV3vDiskFat;         /* ߼̵FAT־:1=FAT12,2=FAT16,3=FAT32 */
extern  uint8_t  CHRV3vSecPerClus;      /* ߼̵ÿ */
extern  uint8_t  CHRV3vSectorSizeB;     /* log2(CHRV3vSectorSize) */
extern  uint32_t CHRV3vStartLba;        /* ߼̵ʼLBA */
extern  uint32_t CHRV3vDiskRoot;        /* FAT16ΪĿ¼ռ,FAT32ΪĿ¼ʼغ */
extern  uint32_t CHRV3vDataStart;       /* ߼̵ʼLBA */
extern  uint32_t CHRV3vStartCluster;    /* ǰļĿ¼ʼغ */
extern  uint32_t CHRV3vFileSize;        /* ǰļĳ */
extern  uint32_t CHRV3vCurrentOffset;   /* ǰļָ,ǰдλõֽƫ */
extern  uint32_t CHRV3vFdtLba;          /* ǰFDTڵLBAַ */
extern  uint32_t CHRV3vLbaCurrent;      /* ǰдĴʼLBAַ */
extern  uint16_t CHRV3vFdtOffset;       /* ǰFDTڵƫƵַ */
extern  uint16_t CHRV3vSectorSize;      /* ̵С */
extern  uint8_t  CHRV3vCurrentLun;      /* ̵ǰ߼Ԫ */
extern  uint8_t  CHRV3vSubClassIs6;     /* USB洢豸Ϊ6,06 */
extern  uint8_t  *pDISK_BASE_BUF;       /* ָⲿRAMĴݻ,ȲСCHRV3vSectorSize,Ӧóʼ */
extern  uint8_t  *pDISK_FAT_BUF;        /* ָⲿRAMĴFATݻ,ȲСCHRV3vSectorSize,Ӧóʼ */
extern  uint16_t CHRV3vPacketSize;     /* USB洢豸:64@FS,512@HS/SS,Ӧóʼ */
extern  uint32_t *pTX_DMA_A_REG;        /* ָDMAַĴ,Ӧóʼ */
extern  uint32_t *pRX_DMA_A_REG;        /* ָDMAַĴ,Ӧóʼ */
extern  uint16_t *pTX_LEN_REG;          /* ָͳȼĴ,Ӧóʼ */
extern  uint16_t *pRX_LEN_REG;          /* ָճȼĴ,Ӧóʼ */

extern	CMD_PARAM_I	mCmdParam;				/*  */

extern	__attribute__ ((aligned(4)))   uint8_t 	RxBuffer[ ];  // IN, must even address
extern	__attribute__ ((aligned(4)))   uint8_t	TxBuffer[ ];  // OUT, must even address

//#define		PXUDISK_BOC_CBW	PUDISK_BOC_CBW
//#define		PXUDISK_BOC_CSW	PUDISK_BOC_CSW

#ifndef	pSetupReq
#define	pSetupReq	((PUSB_SETUP_REQ)TxBuffer)
#endif

#ifndef	pCBW
#define	pCBW		((PXUDISK_BOC_CBW)TxBuffer)
#define	pCSW		((PXUDISK_BOC_CSW)RxBuffer)
#endif
#ifndef	pBOC_buf
#define	pBOC_buf	(TxBuffer+((USB_BO_CBW_SIZE+4)&0xFE))
#endif

#if		DISK_BASE_BUF_LEN > 0
extern	uint8_t	DISK_BASE_BUF[ DISK_BASE_BUF_LEN ];	/* ⲿRAMĴݻ,Ϊһĳ */
#endif
extern	uint8_t	CHRV3ReadSector( uint8_t SectCount, uint8_t * DataBuf );	/* Ӵ̶ȡݵ */
#ifdef	EN_DISK_WRITE
extern	uint8_t	CHRV3WriteSector( uint8_t SectCount, uint8_t * DataBuf );	/* еĶݿд */
#endif

extern	uint8_t	CHRV3DiskConnect( void );	/* ǷӲ´״̬ */
extern	void	xFileNameEnumer( void );	/* ⲿӳ,ļöٻصӳ */

extern	uint8_t	CHRV3LibInit( void );		/* ʼCHRV3,ɹ0 */

/* ӳṩӳ */
/* ӳ, ļӳCHRV3File*ʹ̲ѯӳCHRV3DiskQueryܻõݻpDISK_BASE_BUF,
   пpDISK_BASE_BUFб˴Ϣ, Ա뱣֤pDISK_BASE_BUF;,
   RAM, ҪpDISK_BASE_BUFʱ;, ôʱCHRV3DirtyBuffer̻ */
extern	uint8_t	CHRV3GetVer( void );		/* ȡǰӳİ汾 */
extern	void	CHRV3DirtyBuffer( void );	/* ̻ */
extern	uint8_t	CHRV3BulkOnlyCmd( uint8_t * DataBuf );	/* ִлBulkOnlyЭ */
extern	uint8_t	CHRV3DiskReady( void );		/* ѯǷ׼ */
extern	uint8_t	CHRV3AnalyzeError( uint8_t iMode );	/* USBʧܷCHRV3IntStatusش״̬ */
extern	uint8_t	CHRV3FileOpen( void );		/* ļöļ */
extern	uint8_t	CHRV3FileClose( void );		/* رյǰļ */
#ifdef	EN_DISK_WRITE
extern	uint8_t	CHRV3FileErase( void );		/* ɾļر */
extern	uint8_t	CHRV3FileCreate( void );	/* ½ļ,ļѾɾ½ */
extern	uint8_t	CHRV3FileAlloc( void );		/* ļȵΪļĴ̿ռ */
#endif
extern	uint8_t	CHRV3FileModify( void );	/* ѯ޸ĵǰļϢ */
extern	uint8_t	CHRV3FileQuery( void );		/* ѯǰļϢ */
extern	uint8_t	CHRV3FileLocate( void );	/* ƶǰļָ */
extern	uint8_t	CHRV3FileRead( void );		/* ӵǰļȡݵָ */
#ifdef	EN_DISK_WRITE
extern	uint8_t	CHRV3FileWrite( void );		/* ǰļдָ */
#endif
extern	uint8_t	CHRV3ByteLocate( void );	/* ֽΪλƶǰļָ */
extern	uint8_t	CHRV3ByteRead( void );		/* ֽΪλӵǰλöȡݿ */
#ifdef	EN_DISK_WRITE
extern	uint8_t	CHRV3ByteWrite( void );		/* ֽΪλǰλдݿ */
#endif
extern	uint8_t	CHRV3DiskQuery( void );		/* ѯϢ */
extern	void	CHRV3SaveVariable( void );	/* //ָӳı,ӳڶоƬU֮л */

extern	void	mDelayuS( uint16_t n );		// uSΪλʱ
extern	void	mDelaymS( uint16_t n );		// mSΪλʱ
extern	uint8_t	USBHostTransact( uint8_t endp_pid, uint8_t tog, uint32_t timeout );	// CHRV3,ĿĶ˵ַ/PID,ͬ־,NAKʱ,0ɹ,ʱ/
extern	uint8_t	HostCtrlTransfer( uint8_t * DataBuf, uint8_t * RetLen );	// ִпƴ,8ֽpSetupReq,DataBufΪѡշ,ʵշȷReqLenָı
extern	void	CopySetupReqPkg( const char * pReqPkt );  // ƿƴ
extern	uint8_t	CtrlGetDeviceDescrTB( void );       // ȡ豸,TxBuffer
extern	uint8_t	CtrlGetConfigDescrTB( void );       // ȡ,TxBuffer
extern	uint8_t	CtrlSetUsbAddress( uint8_t addr );  // USB豸ַ
extern	uint8_t	CtrlSetUsbConfig( uint8_t cfg );    // USB豸
extern	uint8_t	CtrlClearEndpStall( uint8_t endp ); // ˵STALL
#ifndef	FOR_ROOT_UDISK_ONLY
//extern	uint8_t	CtrlGetHubDescr( void );  // ȡHUB,TxBuffer
extern	uint8_t	HubGetPortStatus( uint8_t HubPortIndex );  // ѯHUB˿״̬,TxBuffer
//extern	uint8_t	HubSetPortFeature( uint8_t HubPortIndex, uint8_t FeatureSelt );  // HUB˿
extern	uint8_t	HubClearPortFeature( uint8_t HubPortIndex, uint8_t FeatureSelt );  // HUB˿
#endif

#ifdef __cplusplus
}
#endif

#endif
