module spi_model_2;

   integer i;

   reg rst_n;
   reg clk;


   wire sck,sdo,sdi,bsync,rdy;
   reg start;
   reg [7:0] din;
   wire [7:0] dout;
   reg [7:0] shin,shout;

   reg [1:0] speed;


initial begin
   din = 8'd0;
   shin = 8'd0;
   shout = 8'd0;
   start = 1'b0;

   clk = 1'b0;
   rst_n = 1'b0;

   #40 clk = ~clk;
   #40 clk = ~clk;
   #20;
   rst_n = 1'b1;
   #20;
   clk = ~clk;
   
   forever #40 clk = ~clk;

end




   spi my_spi( .clock(clk), .sck(sck), .sdi(sdi), .sdo(sdo),
               .bsync(bsync), .start(start), .speed(speed),
               .din(din), .dout(dout), .rdy(rdy) );



//register shiftout data
always @(posedge sck)
begin
    shin[7:0] <= {shin[6:0],sdo};
end

//supply shiftin data
assign sdi = shout[7];
always @(negedge sck)
begin
   shout[7:0] <= {shout[6:0],shout[7]};
end



initial
begin
   speed=2'b00;

   for(i=0;i<10;i=i+1) @(posedge clk);

   din <= 8'h55;
   shout <= 8'hAA;
   start <= 1'b1;
   @(posedge clk);
   start <= 1'b0;      

   @(posedge rdy);
   @(posedge clk);


   for(i=0;i<100;i=i+1)
   begin
      
      speed <= speed+2'd1;
      din <= $random;
      shout <= $random;
      start <= 1'b1;
      @(posedge clk);
      start <= 1'b0;

      @(posedge rdy);
      @(posedge clk);

      if( (shin!=din) || (shout!=dout) )
      begin
         $display("sent and received data do not match! \n shin=%h,din=%h; shout=%h,dout=%h\n",shin,din,shout,dout);
         $stop(1);
      end
   end

   $stop;

end




endmodule

