/********************************** (C) COPYRIGHT *******************************
 * File Name          : HTTPS.c
 * Author             : WCH
 * Version            : V1.0.0
 * Date               : 2022/05/31
 * Description        : HTTPS related functions.
*********************************************************************************
* Copyright (c) 2021 Nanjing Qinheng Microelectronics Co., Ltd.
* Attention: This software (modified or not) and binary are used for 
* microcontroller manufactured by Nanjing Qinheng Microelectronics.
*******************************************************************************/
#include <stdio.h>
#include <string.h>
#include <stdlib.h>    
#include "HTTPS.h"

#define HTML_LEN     1024*5                                 //Maximum size of a single web page

st_http_request http_request;

/*Define three structure arrays, which are used to save basic
 * settings, port settings, and password settings.*/
Parameter Para_Basic[4], Para_Port[4], Para_Login[2];

Basic_Cfg_t Basic_CfgBuf;
Port_Cfg_t  Port_CfgBuf;
Login_Cfg_t Login_CfgBuf;

/*Default configuration of WCHNET network parameters*/
u8 Basic_Default[BASIC_CFG_LEN] = {
0x57, 0xAB,
01, 02, 03, 04, 05, 06, 192, 168, 1, 10, 255, 255, 255, 0, 192, 168, 1, 1};

/*WCHNET login default parameters, user name and password*/
u8 Login_Default[LOGIN_CFG_LEN] = {
0x57, 0xAB,
'a', 'd', 'm', 'i', 'n', 0, 0, 0, 0, 0, 0, '1', '2', '3', 0, 0, 0, 0, 0, 0, 0, 0 };

/*WCHNET default port configuration*/
u8 Port_Default[PORT_CFG_LEN] = {
0x57, 0xAB,
MODE_TCPCLIENT, 1000 / 256, 1000 % 256, 192, 168, 1, 100, 1000 / 256, 1000 % 256 };

u8 *name;                                               //The name of the web page requested by HTTP
u8 socket;                                              //socket id
u8 httpweb[200];                                        //The array is used to store the HTTP response message
char HtmlBuffer[HTML_LEN];                              //Web page send buffer

extern u8 HTTPDataBuffer[RECE_BUF_LEN];//MAC address IP address Gateway IP address subnet mask

const char Html_login[] = {
    "<!DOCTYPE html>\r\n"
    "<html >\r\n"
    "<style type=\"text/css\">\r\n"
    "html{\r\n"
    "width: 100%;\r\n"
    "height: 100%;\r\n"
    "\r\n"
    "}\r\n"
    "body{\r\n"
    "width: 100%;\r\n"
    "height: 100%;\r\n"
    "margin: 0;\r\n"
    "background-color: #0080FF;\r\n"
    "}\r\n"
    "#login{\r\n"
    "width:480px;\r\n"
    "height:400px;\r\n"
    "margin:140px auto;\r\n"
    "border-radius: 0.5em;\r\n"
    "background-color: WHITE;\r\n"
    "}\r\n"
    "\r\n"
    "#login img{\r\n"
    "padding-top:20px;\r\n"
    "}\r\n"
    "#login h1{\r\n"
    "padding-top:20px;\r\n"
    "\r\n"
    "color: #888;\r\n"
    "text-align: center;\r\n"
    "}\r\n"
    "\r\n"
    "\r\n"
    "input{\r\n"
    "width: 280px;\r\n"
    "height: 25px;\r\n"
    "margin-bottom: 20px;\r\n"
    "padding: 6px;\r\n"
    "font-size: 20px;\r\n"
    "color: black;\r\n"
    "background-color: #D3D3D3;\r\n"
    "border:none;\r\n"
    "border-radius: 5px;\r\n"
    "}\r\n"
    "input:hover{\r\n"
    "border:1px solid #949494\r\n"
    "}\r\n"
    "\r\n"
    "\r\n"
    "#but{\r\n"
    "width: 290px;\r\n"
    "height: 40px;\r\n"
    "margin-bottom: 20px;\r\n"
    "padding: 6px;\r\n"
    "background-color: #21A957;\r\n"
    "color: white;\r\n"
    "font-size: 20px;\r\n"
    "border: none;\r\n"
    "border-radius: 5px;\r\n"
    "cursor:pointer;\r\n"
    "}\r\n"
    "#but:hover{\r\n"
    "background:#128A42;\r\n"
    "}\r\n"
    "</style>\r\n"
    "\r\n"
    "<head>\r\n"
    "\r\n"
    "<title>Login</title>\r\n"
    "<script type=\"text/javascript\">\r\n"
    "function check()\r\n"
    "{\r\n"
    "var f= document.log;\r\n"
    "\r\n"
    "if((f.__PUSE.value==\"__AUSE\")&&(f.__PPAS.value==\"__APAS\"))\r\n"
    "return true;\r\n"
    "else\r\n"
    "{\r\n"
    "alert(\"Wrong user name or password\");\r\n"
    "return false;\r\n"
    "}\r\n"
    "\r\n"
    "}\r\n"
    "\r\n"
    "</script>\r\n"
    "\r\n"
    "</head>\r\n"
    "\r\n"
    "\r\n"
    "<body>\r\n"
    "<div id=\"login\">\r\n"
    "\r\n"
    "<form method=\"post\" name=\"log\" action=\"main.html\" onsubmit=\"return check();\" >\r\n"
    "<div align=\"center\" >\r\n"
    "<br>\r\n"
    "<img src=\"logo.png\" />\r\n"
    "</div>\r\n"
    "<h1>User Login</h1>\r\n"
    "<div align=\"center\" >\r\n"
    "<input   type=\"text\" name=\"__PUSE\" placeholder=\"Please enter user name\" ><br>\r\n"
    "<input   type=\"password\" name=\"__PPAS\" placeholder=\"Please enter password\"><br>\r\n"
    "<button  id=\"but\" type=\"submit\"  ><b>Log in</b></button>\r\n"
    "</div>\r\n"
    "</form>\r\n"
    "</div>\r\n"
    "</body>\r\n"
    "</html>\r\n"
};

const char Html_main[] = {
    "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" >\r\n"
    "<html>\r\n"
    "<style type=\"text/css\">\r\n"
    "body{\r\n"
    "margin: 0;\r\n"
    "background-color: #0080FF;\r\n"
    "}\r\n"
    "\r\n"
    "#head{\r\n"
    "height:120px;\r\n"
    "margin:0 auto;\r\n"
    "width:900px;\r\n"
    "}\r\n"
    ".product{\r\n"
    "display:inline-block;\r\n"
    "font-size:30px;\r\n"
    "margin-left:100px;\r\n"
    "padding-bottom:10px;\r\n"
    "color:#ffffff;\r\n"
    "\r\n"
    "}\r\n"
    "#head img{\r\n"
    "margin-left:0px;\r\n"  //15
    "margin-top:60px\r\n"
    "\r\n"
    "}\r\n"
    "\r\n"
    "#basicContent{\r\n"
    "height:700px;\r\n"
    "margin:0 auto;\r\n"
    "width:930px;\r\n"
    "\r\n"
    "}\r\n"
    "#bConFun{\r\n"
    "float:left;\r\n"
    "height:660px;\r\n"
    "list-style-type:none;\r\n"
    "margin-top:45px;\r\n"
    "padding:0px;\r\n"
    "position:relative;\r\n"
    "width:150px;\r\n"
    "font-size:0px;\r\n"
    "}\r\n"
    "#bConFun li{\r\n"
    "height:150px;\r\n"
    "margin-bottom:20px;\r\n"
    "background-color:white;\r\n"
    "border-radius:12px;\r\n"
    "cursor:pointer;\r\n"
    "text-align:center;\r\n"
    "width:150px;\r\n"
    "}\r\n"
    "#bConFun li:hover{\r\n"
    "background-color: #FF9;\r\n"
    "}\r\n"
    "\r\n"
    "#bConFun li a{\r\n"
    "\r\n"
    "text-decoration: none;\r\n"
    "\r\n"
    "}\r\n"
    "\r\n"
    "h2{\r\n"
    "text-align:center;\r\n"
    "color: #0080FF;\r\n"
    "font-size:20px;\r\n"
    "padding-top:0px;\r\n"
    "text-decoration: none;\r\n"
    "}\r\n"
    "#ifrPage {\r\n"
    "margin-top:30px;\r\n"
    "float:right;\r\n"
    "width:750px;\r\n"
    "height:660px;\r\n"
    "background-color:white;\r\n"
    "border-radius:12px;\r\n"
    "}\r\n"
    "#foot{\r\n"
    "margin-top:10px;\r\n"
    "width:930px;\r\n"
    "margin:0 auto;\r\n"
    "color: white;\r\n"
    "font-size: 15px;\r\n"
    "border-top: 1px;\r\n"
    "height: 50px;\r\n"
    "}\r\n"
    "#foot p {\r\n"
    "float:left;\r\n"
    "font-size: 15px;\r\n"
    "margin:20px auto;\r\n"
    "height: 40px;\r\n"
    "}\r\n"
    "\r\n"
    "#left{\r\n"
    "float:right;\r\n"
    "margin:14px 15px 0 0;\r\n"
    "}\r\n"
    "#left a{\r\n"
    "color:white;\r\n"
    "}\r\n"
    "\r\n"
    "#erweima{\r\n"
    "\r\n"
    "margin-left:600px;\r\n"
    "float:right;\r\n"
    "}\r\n"
    ".guanzhu{\r\n"
    "margin-left:650px;\r\n"
    "font-size:10px;\r\n"
    "color:white;\r\n"
    "float:right;\r\n"
    "}\r\n"
    "\r\n"
    ".tubiao{\r\n"
    "margin-top:5px;\r\n"
    "}\r\n"
    "\r\n"
    "ul li h2{ margin-top: 5px; }"
    "\r\n"
    "</style>\r\n"
    "<head>\r\n"
    "<title> basic</title>\r\n"
    "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=gb2312\" />\r\n"
    "<meta name=\"renderer\" content=\"webkit\">\r\n"
    "<script>\r\n"
    "function changeCss(id){\r\n"
    "var li=document.getElementsByTagName(\"li\");\r\n"
    "for(var i =0;i < li.length;i++){\r\n"
    "li[i].style.background=\"\";\r\n"
    "}\r\n"
    "document.getElementById(id).style.background= \"#FFFF66\";\r\n"
    "}\r\n"
    "\r\n"
    "</script>\r\n"
    "\r\n"
    "</head>\r\n"
    "\r\n"
    "<body >\r\n"
    "<div id=\"head\">\r\n"
    "<img src=\"logo.png\"/>\r\n"
    "<img id=\"erweima\" src=\"weixin.gif\"/>\r\n"
    "\r\n"
    "</div>\r\n"
    "\r\n"
    "<!--这是左侧目录栏 -->\r\n"
    "<div id=\"basicContent\">\r\n"
    "<ul id=\"bConFun\" >\r\n"
    "<!--目录第一行 -->\r\n"
    "<li  id=\"1\">\r\n"
    "<a href=\"basic.html\" target=\"ifrPage\" onclick=\"changeCss('1')\">\r\n"
    "<img  class=\"tubiao\" src=\"png1.png\"/><h2 >Basic Settings</h2>\r\n"
    "</a>\r\n"
    "</li>\r\n"
    "<!--目录第二行 -->\r\n"
    "<li   id=\"2\">\r\n"
    "<a href=\"port.html\" target=\"ifrPage\"onclick=\"changeCss('2')\" >\r\n"
    "<img class=\"tubiao\" src=\"png2.png\"/> <h2>Port Settings</h2>\r\n"
    "</a>\r\n"
    "</li>\r\n"
    "<!--目录第三行 -->\r\n"
    "\r\n"
    "<li id=\"3\">\r\n"
    "<a href=\"user.html\" target=\"ifrPage\"onclick=\"changeCss('3')\" >\r\n"
    "<img class=\"tubiao\" src=\"png3.png\"/><h2 style=\"line-height: 15px;font-size: 18px;margin-top: 2px\">Password<br/> Settings</h2>\r\n"
    "</a>\r\n"
    "</li>\r\n"
    "<!--目录第四行 -->\r\n"
    "<li id=\"4\" >\r\n"
    "<a href=\"about.html\" target=\"ifrPage\" onclick=\"changeCss('4')\" >\r\n"
    "<img class=\"tubiao\" src=\"png4.png\"/><h2>About us</h2>\r\n"
    "</a>\r\n"
    "</li>\r\n"
    "</ul>\r\n"
    "<iframe id=\"ifrPage\" name=\"ifrPage\" src=\"basic.html\" frameborder=\"no\"></iframe>\r\n"
    "\r\n"
    "<div id=\"foot\">\r\n"
    "<p>Copyright:@2002-2023 Nanjing Qinheng Microelectronics Co., Ltd.All Rights Reserved</p>\r\n"
    "<div id=\"left\">Official website:<a href=\"http://www.wch.cn\">www.wch.cn</a></div>\r\n"
    "</div>\r\n"
    "</body>\r\n"
    "</html>\r\n"
    "</body>\r\n"
    "</html>\r\n"
    "\r\n"
};

const char Html_basic[] = {
    "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" >\r\n"
    "<head>\r\n"
    "<title>Basic Settings</title>\r\n"
    "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=gb2312\" />\r\n"
    "<link rel=\"stylesheet\" type=\"text/css\" href=\"style.css\" />\r\n"
    "</head>\r\n"
    "<script type=\"text/javascript\" language=\"JavaScript\">\r\n"
    "function init_main()\r\n"
    "{\r\n"
    "f=document.basic;\r\n"
    "f.__PMAC.value=\"__AMAC\";\r\n"
    "f.__PSIP.value=\"__ASIP\";\r\n"
    "f.__PMSK.value=\"__AMSK\";\r\n"
    "f.__PGAT.value=\"__AGAT\";\r\n"
    "}\r\n"
    "\r\n"
    "</script>\r\n"
    "<body onLoad=\"init_main()\">\r\n"
    "<form name= \"basic\" method=\"post\" action=\"success.html\">\r\n"
    "<div>\r\n"
    "<h2>Basic Settings</h2>\r\n"
    "<ul >\r\n"
    "<li class=\"config\">\r\n"
    "<label >Device MAC</label><input name=\"__PMAC\" class=\"shuru\" maxlength=\"32\"/>\r\n"
    "</li>\r\n"
    "<li class=\"config\">\r\n"
    "<label >Device IP</label><input name=\"__PSIP\" class=\"shuru\" maxlength=\"32\"/>\r\n"
    "</li>\r\n"
    "<li class=\"config\">\r\n"
    "<label >Subnet mask</label><input name=\"__PMSK\"class=\"shuru\" maxlength=\"32\"/>\r\n"
    "</li>\r\n"
    "<li class=\"config\">\r\n"
    "<label >Gateway</label><input name=\"__PGAT\"class=\"shuru\" maxlength=\"32\"/>\r\n"
    "</li>\r\n"
    "</ul>\r\n"
    "<button  class=\"but\" type=\"submit\"  ><b>Save configuration</b></button>\r\n"
    "</div>\r\n"
    "</form>\r\n"
    "</body>\r\n"
    "</html>\r\n"
};
const char Html_port[] ={
    "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" >\r\n"
    "<head>\r\n"
    "<title>Port Settings</title>\r\n"
    "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=gb2312\" />\r\n"
    "<link rel=\"stylesheet\" type=\"text/css\" href=\"style.css\" />\r\n"
    "</head>\r\n"
    "<script type=\"text/javascript\" language=\"JavaScript\">\r\n"
    "function init_main()\r\n"
    "{\r\n"
    "f=document.port;\r\n"
    "\r\n"
    "if(\"__AMOD\"==\"0\")\r\n"
    "f.__PMOD.options.selectedIndex= 0;\r\n"
    "else if(\"__AMOD\"==\"1\")\r\n"
    "f.__PMOD.options.selectedIndex= 1;\r\n"
    "f.__PSPT.value=\"__ASPT\";\r\n"
    "f.__PDIP.value=\"__ADIP\";\r\n"
    "f.__PDPT.value=\"__ADPT\";\r\n"
    "\r\n"
    "}\r\n"
    "\r\n"
    "</script>\r\n"
    "<body onLoad=\"init_main()\">\r\n"
    "<form name= \"port\" method=\"post\" action=\"success.html\">\r\n"
    "<div>\r\n"
    "<h2 >Port Settings</h2>\r\n"
    "<ul  >\r\n"
    "<li class=\"config\">\r\n"
    "<label >Network mode</label><select class=\"fuxuan\" name=\"__PMOD\">\r\n"
    "<option  value=\"0\">TCP-Server</option>\r\n"
    "<option value=\"1\">TCP-Client</option>\r\n"
    "</select>\r\n"
    "</li>\r\n"
    "<li class=\"config\">\r\n"
    "<label >Local port</label><input name=\"__PSPT\" class=\"shuru\" maxlength=\"32\"/>\r\n"
    "</li>\r\n"
    "<li class=\"config\">\r\n"
    "<label >Destination IP</label><input name=\"__PDIP\" class=\"shuru\" maxlength=\"32\"/>\r\n"
    "</li>\r\n"
    "<li class=\"config\">\r\n"
    "<label >Destination port</label><input name=\"__PDPT\" class=\"shuru\" maxlength=\"32\"/>\r\n"
    "</li>\r\n"
    "</ul>\r\n"
    "<button  class=\"but\" type=\"submit\"  ><b>Save configuration</b></button>\r\n"
    "</div>\r\n"
    "</form>\r\n"
    "</body>\r\n"
    "</html>\r\n"
};

const char Html_user[] = {
    "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\">\r\n"
    "<head>\r\n"
    "<title>user</title>\r\n"
    "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=gb2312\" />\r\n"
    "<link rel=\"stylesheet\" type=\"text/css\" href=\"style.css\" />\r\n"
    "\r\n"
    "</head>\r\n"
    "<script type=\"text/javascript\" language=\"JavaScript\">\r\n"
    "function init_main()\r\n"
    "{\r\n"
    "f=document.user;\r\n"
    "f.__PUSE.value=\"__AUSE\";\r\n"
    "f.__PPAS.value=\"__APAS\";\r\n"
    "}\r\n"
    "\r\n"
    "</script>\r\n"
    "<body onLoad=\"init_main()\">\r\n"
    "<form name= \"user\" method=\"post\" action=\"success.html\">\r\n"
    "<div>\r\n"
    "<h2>Password settings</h2>\r\n"
    "<ul >\r\n"
    "<li class=\"config\">\r\n"
    "<label >Username</label><input name=\"__PUSE\" class=\"shuru\" maxlength=\"10\"/>\r\n"
    "</li>\r\n"
    "<li class=\"config\">\r\n"
    "<label >Password</label><input name=\"__PPAS\" class=\"shuru\" maxlength=\"10\"/>\r\n"
    "</li>\r\n"
    "</ul>\r\n"
    "<button  class=\"but\" type=\"submit\"  ><b>Save configuration</b></button>\r\n"
    "\r\n"
    "</div>\r\n"
    "</form>\r\n"
    "\r\n"
    "</body>\r\n"
    "</html>\r\n"
};

const char Html_about[] = {
    "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\"><head>\r\n"
    "<title></title>\r\n"
    "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=gb2312\" />\r\n"
    "<link rel=\"stylesheet\" type=\"text/css\" href=\"style.css\" />\r\n"
    "</head>\r\n"
    "\r\n"
    "<style>\r\n"
    ".div_c\r\n"
    "{\r\n"
    "margin-left:10%;\r\n"
    "margin-right:10%;\r\n"
    "margin-top:20%;\r\n"
    "}\r\n"
    "\r\n"
    ".STYLE2 {\r\n"
    "font-size: 16px;\r\n"
    "font-weight: bold;\r\n"
    "}\r\n"
    ".STYLE4 {color: #000000}\r\n"
    "</style>\r\n"
    "<body>\r\n"
    "\r\n"
    "<form action=\"misc.cgi\" method=\"get\">\r\n"
    "\r\n"
    "<div class=\"top_content\" style=\"height:600px\">\r\n"
    "<div class=\"top\">\r\n"
    "<h2 >About us</h2>\r\n"
    "</div>\r\n"
    "<div class=\"div_c\"  style=\"font-family:微软雅黑;margin-top:30px;\">\r\n"
    "\r\n"
    "<div class=\"lab_4 STYLE4\"><span class=\"STYLE2\">Company Profile</span><br />\r\n"
    "<p style=\"text-indent: 2em\" align=\"left\">Nanjing Qinheng Microelectronics Co., Ltd. founded in 2004, is an IC communication interface and full-stack MCU Design Company.</p>\r\n"
    "<p style=\"text-indent: 2em\" align=\"left\">Qinheng specializes in connectivity technology and MCU core development. The company operates a full-stack development model based on self-developed transceiver PHY and processor IP instead of traditionally outsourcing IP integration models. Qinheng provides Ethernet, Bluetooth, USB and PCI interface chips, alongside connectivity/interconnectivity/wireless full-stack MCU+ microcontrollers integrated with these interfaces.</p>\r\n"
    "<p style=\"text-indent: 2em\" align=\"left\">Technically involves \"perception + control + connection + cloud gathering\":</p>\r\n"
    "<p style=\"text-indent: 2em\" align=\"left\">- ADC/PGA and other analog detection modules</p>\r\n"
    "<p style=\"text-indent: 2em\" align=\"left\">- MCU smart control and driving algorithms</p>\r\n"
    "<p style=\"text-indent: 2em\" align=\"left\">- HID human-computer interactionHID human-computer interaction</p>\r\n"
    "<p style=\"text-indent: 2em\" align=\"left\">- Ethernet/Bluetooth-LE and other network communication protocols</p>\r\n"
    "<p style=\"text-indent: 2em\" align=\"left\">- UART/USB/USB PD/PCIE/CAN/SerDes and other communication interfaces</p>\r\n"
    "<p style=\"text-indent: 2em\" align=\"left\">- Data security</p>\r\n"
    "<p style=\"text-indent: 2em\" align=\"left\">- IoT protocol and cloud services</p>\r\n"
    "</div>\r\n"
    "<br>\r\n"
    "<div class=\"lab_4 STYLE4\"><span class=\"STYLE2\">Download</span><br />\r\n"
    "<p class=\"STYLE4\">Chip data:<a href=\"http://www.wch.cn/search?q=%E4%BB%A5%E5%A4%AA%E7%BD%91&t=all\" target=\"_blank\">Chip Profile with Ethernet</a></p>\r\n"
    "</div>\r\n"
    "<br>\r\n"
    "<div class=\"lab_4 STYLE4\"><span class=\"STYLE2\">Contact us</span><br />\r\n"
    "<p class=\"STYLE4\"><a>Technician Email:tech@wch.cn</a></p>\r\n"
    "<p class=\"STYLE4\">Technician Phone:025-52638370</p>\r\n"
    "<p class=\"STYLE4\">sales phone:025-52638389</p>\r\n"
    "</div>\r\n"
    "<br>\r\n"
    "</div>\r\n"
    "</div>\r\n"
    "</form>\r\n"
    "\r\n"
    "</body>\r\n"
    "</html>\r\n"
};

const char Html_success[] = {
    "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" >\r\n"
    "<html >\r\n"
    "<head>\r\n"
    "<title></title>\r\n"
    "<meta http-equiv=\"Content-Type\" content=\"text/html\" />\r\n"
    "<link rel=\"stylesheet\" type=\"text/css\" href=\"style.css\" />\r\n"
    "</head>\r\n"
    "<body >\r\n"
    "<form name= \"success\" method=\"post\" action=\"success.html\">\r\n"
    "<h2>Set successfully</h2>\r\n"
    "<br />\r\n"
    "<br />\r\n"
    "Set successfully<br />\r\n"
    "<br />\r\n"
    "Please restart the microcontroller or continue to set\r\n"
    "</div>\r\n"
    "</form>\r\n"
    "</body>\r\n"
    "</html>\r\n"
};
const char Html_style[] = {
    "body {\r\n"
    "text-align: center;\r\n"
    "color: black;\r\n"
    "padding:0px;\r\n"
    "margin:0 auto;\r\n"
    "}\r\n"
    "form{\r\n"
    "width: 750px;\r\n"
    "height: 100%;\r\n"
    "}\r\n"
    "form h2{\r\n"
    "font-size:20px;\r\n"
    "text-align:center;\r\n"
    "}\r\n"
    "form ul{\r\n"
    "margin-left:160px;\r\n"
    "text-align: center;\r\n"
    "list-style-type:none;\r\n"
    "width: 360px;\r\n"
    "postion:relative;\r\n"
    "}\r\n"
    "\r\n"
    "form ul li{\r\n"
    "text-align: left;\r\n"
    "margin:0 auto;\r\n"
    "margin-top:10px;\r\n"
    "\r\n"
    "}\r\n"
    "\r\n"
    ".config{\r\n"
    "border:1px solid #0080FF;\r\n"
    "border-radius:5px;\r\n"
    "width:360px;\r\n"
    "\r\n"
    "}\r\n"
    "\r\n"
    "label{\r\n"
    "background-color:#0080FF;\r\n"
    "color:white;\r\n"
    "display:inline-block;\r\n"
    "font-size:18px;\r\n"
    "font-weight:bold;\r\n"
    "height:30px;\r\n"
    "line-height:30px;\r\n"
    "text-align:center;\r\n"
    "vertical-align:center;\r\n"
    "width:150px;\r\n"
    "}\r\n"
    "\r\n"
    ".shuru\r\n"
    "{\r\n"
    "margin-left:40px;\r\n"
    "border:0px;\r\n"
    "height:18px;\r\n"
    "vertical-align:middle;\r\n"
    "width:160px;\r\n"
    "margin-top:0px;\r\n"
    "font-size:16px;\r\n"
    "outline:none;\r\n"
    "padding-bottom:4px;\r\n"
    "}\r\n"
    "\r\n"
    ".gouxuan\r\n"
    "{\r\n"
    "margin-left:40px;\r\n"
    "font-size:18px;\r\n"
    "font-weight:\r\n"
    "\r\n"
    "}\r\n"
    "\r\n"
    ".fuxuan{\r\n"
    "border:0;\r\n"
    "background-color:white;\r\n"
    "margin-left:40px;\r\n"
    "width:120px;\r\n"
    "height:20px;\r\n"
    "font-size:15px;\r\n"
    "outline:none;\r\n"
    "}\r\n"
    ".but{\r\n"
    "width: 200px;\r\n"
    "height: 35px;\r\n"
    "margin-bottom: 20px;\r\n"
    "padding: 6px;\r\n"
    "background-color: #21A957;\r\n"
    "color: white;\r\n"
    "font-size: 20px;\r\n"
    "border: none;\r\n"
    "border-radius: 5px;\r\n"
    "cursor:pointer;\r\n"
    "}\r\n"
    "\r\n"
    ".but:hover{\r\n"
    "background:#128A42;\r\n"
    "}\r\n"
    "\r\n"
    ".but1{\r\n"
    "width: 200px;\r\n"
    "height: 35px;\r\n"
    "margin-top: 30px;\r\n"
    "padding: 6px;\r\n"
    "background-color: #0080FF;\r\n"
    "color: white;\r\n"
    "font-size: 20px;\r\n"
    "border: none;\r\n"
    "border-radius: 5px;\r\n"
    "cursor:pointer;\r\n"
    "}\r\n"
    "\r\n"
    ".but1:hover{\r\n"
    "background:#008080;\r\n"
    "}\r\n"
    "\r\n"
    "input[type=checkbox] {\r\n"
    "-ms-transform: scale(1.5); /* IE */\r\n"
    "-moz-transform: scale(1.5); /* FireFox */\r\n"
    "-webkit-transform: scale(1.5); /* Safari and Chrome */\r\n"
    "-o-transform: scale(1.5); /* Opera */\r\n"
    "}\r\n"
    "\r\n"
    "select{\r\n"
    "background: transparent;\r\n"
    "border: none;\r\n"
    "}\r\n"
};

const char Html_logo[] = { 0x89, 0x50, 0x4E, 0x47, 0x0D, 0x0A, 0x1A, 0x0A, 0x00,
        0x00, 0x00, 0x0D, 0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x7A, 0x00,
        0x00, 0x00, 0x1E, 0x08, 0x06, 0x00, 0x00, 0x00, 0xE3, 0x3C, 0x0A, 0xA8,
        0x00, 0x00, 0x00, 0x09, 0x70, 0x48, 0x59, 0x73, 0x00, 0x00, 0x0B, 0x13,
        0x00, 0x00, 0x0B, 0x13, 0x01, 0x00, 0x9A, 0x9C, 0x18, 0x00, 0x00, 0x00,
        0x19, 0x74, 0x45, 0x58, 0x74, 0x53, 0x6F, 0x66, 0x74, 0x77, 0x61, 0x72,
        0x65, 0x00, 0x41, 0x64, 0x6F, 0x62, 0x65, 0x20, 0x49, 0x6D, 0x61, 0x67,
        0x65, 0x52, 0x65, 0x61, 0x64, 0x79, 0x71, 0xC9, 0x65, 0x3C, 0x00, 0x00,
        0x05, 0x6E, 0x49, 0x44, 0x41, 0x54, 0x78, 0xDA, 0xDC, 0x5A, 0x3B, 0x92,
        0xE3, 0x36, 0x10, 0x85, 0x54, 0xCA, 0xA5, 0x1B, 0x2C, 0x37, 0xB1, 0x43,
        0xE9, 0x06, 0xE2, 0x56, 0x79, 0xE3, 0x95, 0x4F, 0x30, 0x9A, 0x13, 0xAC,
        0x1C, 0x38, 0x16, 0x37, 0xB5, 0x03, 0xEB, 0x06, 0xA2, 0x4E, 0x30, 0x9A,
        0xD8, 0xC1, 0x50, 0x37, 0xA0, 0x42, 0x47, 0xE6, 0xDE, 0x40, 0x73, 0x82,
        0x71, 0xF7, 0xD4, 0xA3, 0xDD, 0xC2, 0x80, 0x20, 0x00, 0x7E, 0xC4, 0x71,
        0x57, 0xB1, 0x28, 0x92, 0x20, 0x04, 0xE2, 0xF5, 0xE7, 0x75, 0x03, 0xA3,
        0x1F, 0x7E, 0xFA, 0xED, 0x45, 0x5D, 0xCB, 0xB7, 0xBF, 0xFE, 0xFC, 0x35,
        0x51, 0x1E, 0xF2, 0xE3, 0xE7, 0xDF, 0x9D, 0xFB, 0xA0, 0xB6, 0x33, 0x3A,
        0xC5, 0x38, 0x16, 0x38, 0xA6, 0x86, 0xA6, 0x6D, 0x8C, 0xE3, 0x44, 0x7D,
        0xC4, 0x2E, 0xEF, 0x8E, 0x46, 0xA3, 0x0D, 0x9F, 0x5F, 0x5E, 0x5E, 0x76,
        0x35, 0xED, 0x78, 0xFC, 0x05, 0x1D, 0x3B, 0x6A, 0xEB, 0x35, 0x3E, 0x4B,
        0x9F, 0x72, 0xDC, 0x27, 0xEA, 0x37, 0x56, 0x2D, 0xCB, 0x44, 0xF5, 0x24,
        0x04, 0x02, 0x0F, 0x9E, 0x27, 0xF3, 0x8B, 0x1A, 0x98, 0xD0, 0x44, 0xF3,
        0xD8, 0xFE, 0x10, 0xBF, 0xD7, 0x34, 0xD9, 0x97, 0x0A, 0x90, 0x33, 0x28,
        0xE6, 0x96, 0xAE, 0x23, 0x6A, 0xB7, 0xEE, 0x70, 0x4C, 0xFC, 0x7F, 0x97,
        0x86, 0x5D, 0xBD, 0xF6, 0x31, 0xE9, 0x01, 0xE0, 0x88, 0x4E, 0x29, 0x1D,
        0x4B, 0x35, 0x40, 0xA1, 0x09, 0x65, 0x8F, 0x72, 0x14, 0xB7, 0x58, 0x11,
        0x33, 0xBA, 0xCF, 0x60, 0xE7, 0x5A, 0x73, 0x06, 0x79, 0x2E, 0xAE, 0xEF,
        0xF0, 0x7E, 0x6C, 0x52, 0x8C, 0x86, 0xC2, 0x40, 0x6F, 0x5B, 0xEA, 0xEB,
        0xDB, 0xB8, 0x63, 0x90, 0x57, 0x74, 0xCA, 0x87, 0x0A, 0x32, 0x24, 0x32,
        0xDC, 0x9B, 0x03, 0x6C, 0xDD, 0x85, 0xB2, 0x47, 0x7A, 0xAE, 0x68, 0x1B,
        0x0D, 0xF8, 0x1B, 0xD5, 0xB8, 0x43, 0x90, 0xD9, 0xA5, 0x3D, 0x54, 0xC4,
        0xDF, 0xAB, 0x38, 0xCA, 0x1A, 0x77, 0xAB, 0x09, 0x20, 0x4B, 0x3C, 0xC2,
        0x7A, 0xCE, 0xDA, 0xA3, 0x29, 0xEE, 0xCB, 0xB6, 0x19, 0x38, 0xC5, 0xD9,
        0x00, 0x76, 0x0E, 0xEB, 0x1E, 0xA4, 0x74, 0xE5, 0xBA, 0xE3, 0x1A, 0x2B,
        0x7E, 0x64, 0x77, 0x4E, 0x44, 0xE9, 0x28, 0x14, 0x63, 0x7B, 0x43, 0xB0,
        0x73, 0x58, 0x2F, 0x13, 0xB1, 0xBB, 0x72, 0x8C, 0x26, 0xB2, 0x45, 0xF7,
        0x0A, 0xB4, 0xD5, 0xDD, 0xF8, 0xB4, 0xB4, 0xEC, 0x96, 0xDC, 0x78, 0x26,
        0x7E, 0x17, 0x38, 0x42, 0x70, 0x78, 0xED, 0xAB, 0x2B, 0xA0, 0x97, 0x16,
        0xEB, 0x5D, 0x13, 0xC0, 0xC5, 0xD0, 0x34, 0x1E, 0xE0, 0xAC, 0x09, 0x28,
        0xBE, 0xE4, 0x90, 0xB3, 0xB6, 0xB5, 0x05, 0xD8, 0xA9, 0x46, 0x2E, 0x8F,
        0x2E, 0x20, 0xD3, 0xBB, 0x99, 0x00, 0x30, 0xAB, 0x68, 0x96, 0xC3, 0x83,
        0xB4, 0xA2, 0x2C, 0x93, 0x1E, 0xE7, 0xF2, 0x17, 0x02, 0x78, 0xA7, 0x06,
        0x2E, 0xCC, 0xA2, 0x5D, 0xAC, 0x12, 0xCF, 0x57, 0xD4, 0x36, 0x85, 0x17,
        0x38, 0x23, 0x86, 0xFB, 0x18, 0xC3, 0xD2, 0xC0, 0x11, 0xA2, 0xB2, 0x4F,
        0x3A, 0xDF, 0xD3, 0x79, 0x0F, 0x03, 0xF1, 0x95, 0x85, 0x4C, 0x01, 0xFB,
        0x02, 0xFA, 0x9E, 0x40, 0x4E, 0x07, 0xC8, 0xB8, 0x13, 0x4C, 0xC8, 0x55,
        0x3A, 0xC5, 0xEE, 0xD9, 0xC2, 0xD0, 0x67, 0x9A, 0xD5, 0xB1, 0x62, 0xF0,
        0xBB, 0x69, 0x4B, 0x2E, 0xFB, 0x83, 0x08, 0x1F, 0xEB, 0x1A, 0x0F, 0x79,
        0x7B, 0x32, 0xA6, 0x15, 0x3E, 0x86, 0x08, 0x72, 0x24, 0xF2, 0xFA, 0xCC,
        0x91, 0x48, 0xB1, 0x4B, 0x7F, 0x12, 0xC7, 0x02, 0x8A, 0xB1, 0x91, 0xA9,
        0x18, 0xE7, 0xDB, 0x74, 0xAC, 0x1C, 0x99, 0xFE, 0x25, 0x20, 0x04, 0xBA,
        0xCA, 0xA5, 0x2F, 0xD7, 0xFD, 0x0C, 0x82, 0x33, 0x34, 0x90, 0x67, 0xC8,
        0x9D, 0xA7, 0x5A, 0x8A, 0xB4, 0x06, 0x0B, 0xFF, 0xB7, 0x60, 0x51, 0x5E,
        0x7B, 0xF4, 0xBD, 0xC6, 0x37, 0x4F, 0xE9, 0xF7, 0xC7, 0x0A, 0xEF, 0xF0,
        0x41, 0x7A, 0x05, 0x2D, 0xCE, 0x9F, 0x35, 0x92, 0x67, 0xE2, 0x39, 0xB6,
        0xE2, 0xC8, 0x5C, 0xEB, 0xBB, 0x17, 0xA0, 0x99, 0x59, 0x5F, 0xD4, 0x30,
        0xE5, 0x62, 0x48, 0xA7, 0x1E, 0x08, 0x9C, 0x9F, 0x45, 0xCA, 0xB5, 0x05,
        0x39, 0x3B, 0x81, 0x78, 0xD5, 0x81, 0x9C, 0x6B, 0x13, 0x9D, 0xD8, 0x48,
        0x9D, 0x65, 0x5C, 0xA7, 0x2A, 0x6B, 0xB6, 0x95, 0x47, 0xA1, 0x9C, 0x4F,
        0x41, 0xE9, 0x15, 0xA5, 0x3D, 0x7A, 0x5C, 0x52, 0x04, 0x9E, 0x2B, 0x1B,
        0x6C, 0xC2, 0x1A, 0x23, 0x94, 0x4D, 0xBB, 0x62, 0xD8, 0x31, 0x62, 0xF4,
        0x56, 0xF3, 0x40, 0xB9, 0x18, 0xFB, 0x56, 0xB8, 0x50, 0x97, 0x6F, 0xD9,
        0x81, 0x3C, 0x95, 0xC2, 0x84, 0x2A, 0x95, 0xEC, 0x19, 0xDE, 0xC4, 0x65,
        0xDE, 0x22, 0x28, 0xCA, 0xBE, 0xF3, 0x3C, 0x1A, 0x0B, 0x10, 0x99, 0x5E,
        0xF4, 0xA0, 0xFB, 0xAE, 0xE4, 0xAA, 0x89, 0x35, 0xDF, 0x09, 0x52, 0xD2,
        0x15, 0xC3, 0x4E, 0x68, 0xE2, 0x0B, 0x31, 0x99, 0x89, 0x70, 0xB5, 0x3A,
        0x20, 0x79, 0x19, 0x93, 0x2D, 0xFD, 0xA5, 0x70, 0xDD, 0x4B, 0xCD, 0xAA,
        0x63, 0x8D, 0x0D, 0xD7, 0xCD, 0x51, 0x5A, 0xB2, 0x65, 0xEA, 0x6F, 0x6F,
        0x20, 0x90, 0x2E, 0xB1, 0xDF, 0xCB, 0xA2, 0x93, 0x8A, 0xCA, 0x56, 0xE2,
        0xE2, 0xCA, 0xDE, 0x83, 0x00, 0x1C, 0x05, 0xE6, 0xBD, 0xF3, 0x04, 0xA4,
        0x6A, 0xCE, 0xA4, 0xFB, 0x5C, 0xB2, 0x4B, 0x15, 0x56, 0x1D, 0x19, 0x14,
        0xE8, 0x4D, 0x51, 0xC6, 0xD2, 0x7F, 0x50, 0x61, 0x69, 0x6C, 0xB1, 0x66,
        0x1E, 0xD0, 0xD7, 0xAA, 0x14, 0x80, 0x9E, 0x27, 0xEA, 0x7F, 0x22, 0x0C,
        0x76, 0x5B, 0xA4, 0x11, 0x80, 0x9E, 0x0C, 0xE0, 0xCB, 0x2A, 0x17, 0x97,
        0x7C, 0x0F, 0x68, 0xD7, 0x0B, 0x87, 0x19, 0xD7, 0xC4, 0x1B, 0x9B, 0x6C,
        0xE0, 0xDA, 0x6D, 0x12, 0xBF, 0x23, 0xBC, 0x99, 0x88, 0xD9, 0x16, 0x27,
        0x7C, 0x00, 0xD1, 0x8D, 0x60, 0x59, 0x2E, 0x90, 0xB0, 0x22, 0xB0, 0x5B,
        0xE6, 0xFC, 0x9B, 0x89, 0x95, 0x61, 0x85, 0xAC, 0x13, 0x99, 0x54, 0x58,
        0x73, 0xAC, 0xDE, 0xAE, 0x1B, 0xEB, 0xB4, 0x7F, 0x8A, 0x0F, 0xDA, 0xD4,
        0xE4, 0x9D, 0xA1, 0x96, 0x7F, 0x08, 0x08, 0x0F, 0x4F, 0x81, 0xE9, 0xD6,
        0x4A, 0x90, 0xAE, 0xBF, 0x51, 0x91, 0x5A, 0x68, 0x96, 0x9A, 0xD7, 0xE4,
        0xC6, 0x57, 0x56, 0x4D, 0x6D, 0xF5, 0xF9, 0xDA, 0x34, 0x24, 0xA7, 0x65,
        0xDF, 0xA3, 0x36, 0x59, 0x77, 0x62, 0xC8, 0x87, 0x63, 0x75, 0x5D, 0xF4,
        0x67, 0xF9, 0x4A, 0x4A, 0x61, 0xB3, 0xFC, 0x39, 0x2B, 0x8D, 0x07, 0x4B,
        0x97, 0x52, 0xF8, 0xBE, 0x47, 0xFF, 0x15, 0x3A, 0x7F, 0x71, 0x45, 0x4E,
        0xDA, 0x44, 0x24, 0x03, 0xF7, 0x2D, 0x8F, 0xF6, 0x62, 0xD1, 0x2B, 0x43,
        0xC2, 0xBE, 0xE3, 0x7C, 0x18, 0x71, 0xF9, 0xCE, 0xD3, 0xC5, 0x27, 0xEF,
        0xC0, 0x85, 0xEB, 0x96, 0x7A, 0xD4, 0xBE, 0xEB, 0x7B, 0x20, 0xC9, 0xE3,
        0x3E, 0x8E, 0x6D, 0xEE, 0x42, 0x69, 0x93, 0x75, 0xCF, 0xAB, 0xAA, 0x5B,
        0xBC, 0xEA, 0x44, 0x60, 0x1F, 0x34, 0xB0, 0xEB, 0xB6, 0x06, 0x2D, 0x59,
        0x41, 0x7C, 0xF7, 0x7F, 0xF5, 0x25, 0x70, 0x77, 0xB2, 0x52, 0xF5, 0x28,
        0x42, 0x93, 0x24, 0x50, 0x21, 0xB2, 0xA8, 0x61, 0xD0, 0x21, 0xE2, 0xC3,
        0xBA, 0x67, 0x2E, 0x64, 0xEC, 0xCA, 0x9A, 0x3D, 0x2C, 0xD8, 0x38, 0x38,
        0x6C, 0x44, 0x18, 0xA2, 0xAC, 0x0D, 0xD6, 0x1C, 0x37, 0xB1, 0xB8, 0x92,
        0xD0, 0x75, 0x00, 0xB2, 0xB7, 0xA2, 0x79, 0x01, 0x2D, 0x2F, 0x08, 0xF4,
        0x5C, 0x85, 0x2D, 0x9B, 0xED, 0x09, 0xEC, 0xD4, 0x81, 0xA9, 0xF7, 0x69,
        0xCD, 0xB3, 0x0A, 0xB7, 0xAD, 0xE7, 0xD0, 0x99, 0xA7, 0xC5, 0x31, 0xA1,
        0x4B, 0x0D, 0x5B, 0x91, 0x06, 0x15, 0xA3, 0xAF, 0x98, 0x6F, 0x45, 0xAD,
        0x3A, 0x09, 0x64, 0xB8, 0xEC, 0xF2, 0x63, 0xB6, 0xEE, 0x40, 0x82, 0xD6,
        0xB6, 0x6C, 0x34, 0x17, 0xFD, 0x88, 0x4D, 0x05, 0x05, 0x5C, 0xF8, 0x17,
        0x1F, 0xD7, 0xAD, 0x95, 0x37, 0xCB, 0xCA, 0xDE, 0xA8, 0xE1, 0x18, 0x3F,
        0x35, 0x78, 0xB7, 0x70, 0x05, 0xDA, 0x18, 0x57, 0x19, 0x24, 0x02, 0xAB,
        0xB2, 0xF0, 0xAE, 0x4D, 0xD2, 0x9B, 0x62, 0x0B, 0x2B, 0x09, 0xBD, 0x7F,
        0x86, 0xB7, 0x38, 0xDE, 0x62, 0xE1, 0x03, 0xA0, 0x6C, 0x0C, 0xD6, 0x5C,
        0x16, 0x50, 0x52, 0x61, 0xF1, 0xAE, 0x4A, 0x19, 0x1B, 0x52, 0xD2, 0x90,
        0xB1, 0x45, 0x20, 0x56, 0x8D, 0x76, 0x99, 0x60, 0xB9, 0x94, 0xC7, 0x64,
        0xDD, 0xEE, 0x7B, 0xA8, 0xD9, 0xF2, 0x63, 0xB3, 0xEA, 0x1C, 0x93, 0x66,
        0x2B, 0xC8, 0xCF, 0xF1, 0x7C, 0x0F, 0xA5, 0xE9, 0x5B, 0x12, 0xCD, 0x9A,
        0x9F, 0x01, 0xB0, 0x64, 0xCE, 0x97, 0x9A, 0x5C, 0x3E, 0x01, 0xB3, 0xBE,
        0xA8, 0xFF, 0x16, 0x21, 0xF4, 0x79, 0x08, 0xE5, 0x0D, 0x5B, 0x80, 0xD5,
        0xC6, 0xB7, 0x9E, 0xC6, 0xBE, 0xD6, 0x2C, 0xAD, 0xDA, 0x16, 0xAB, 0xB1,
        0xE8, 0xF1, 0x49, 0xBD, 0xDD, 0x1E, 0x6B, 0x64, 0xE6, 0x37, 0xB0, 0x66,
        0xBD, 0xBC, 0x9B, 0x06, 0x74, 0xC5, 0xE3, 0x7E, 0x80, 0xC2, 0xEF, 0x35,
        0xF6, 0xEE, 0x1B, 0xDB, 0x3B, 0x95, 0x71, 0xA0, 0x35, 0xFB, 0x28, 0x03,
        0x6B, 0xFA, 0x61, 0x48, 0x34, 0x1B, 0x96, 0x7A, 0xAF, 0x29, 0xA1, 0x4B,
        0x36, 0xE1, 0x1B, 0x62, 0x8E, 0x43, 0xF9, 0xE6, 0x49, 0x08, 0x80, 0x5A,
        0xAC, 0xFE, 0x6E, 0xD0, 0x64, 0xD9, 0xE6, 0x75, 0x77, 0x25, 0x8A, 0x2D,
        0x09, 0x62, 0xDE, 0x74, 0x00, 0x60, 0xA7, 0xD8, 0x28, 0x90, 0x21, 0x16,
        0x16, 0x0E, 0xEF, 0xEC, 0xB0, 0x0C, 0x39, 0x77, 0xF8, 0x8B, 0xFB, 0x06,
        0x7B, 0xC8, 0x0A, 0xE1, 0x2D, 0x9B, 0x78, 0x85, 0x72, 0x2F, 0x41, 0x6E,
        0x02, 0xFA, 0xE4, 0xB9, 0x1D, 0x37, 0x51, 0x0E, 0x8B, 0xE3, 0xE8, 0xF3,
        0x35, 0x67, 0x45, 0x2D, 0x3D, 0x16, 0x03, 0x59, 0xDE, 0x08, 0xEC, 0x1C,
        0xC0, 0xF9, 0x00, 0x12, 0xE3, 0x3B, 0x16, 0x15, 0x95, 0xA8, 0x72, 0xA3,
        0xE0, 0xB1, 0x89, 0x12, 0xAA, 0x96, 0x97, 0x81, 0xFF, 0x11, 0x60, 0x00,
        0x8C, 0xC2, 0x65, 0x56, 0xD4, 0xAE, 0x5E, 0xCF, 0x00, 0x00, 0x00, 0x00,
        0x49, 0x45, 0x4E, 0x44, 0xAE, 0x42, 0x60, 0x82
};

const char Html_weixin[] = { 0x47, 0x49, 0x46, 0x38, 0x39, 0x61, 0x78, 0x00,
        0x78, 0x00, 0xF7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x00,
        0x00, 0x66, 0x00, 0x00, 0x99, 0x00, 0x00, 0xCC, 0x00, 0x00, 0xFF, 0x00,
        0x2B, 0x00, 0x00, 0x2B, 0x33, 0x00, 0x2B, 0x66, 0x00, 0x2B, 0x99, 0x00,
        0x2B, 0xCC, 0x00, 0x2B, 0xFF, 0x00, 0x55, 0x00, 0x00, 0x55, 0x33, 0x00,
        0x55, 0x66, 0x00, 0x55, 0x99, 0x00, 0x55, 0xCC, 0x00, 0x55, 0xFF, 0x00,
        0x80, 0x00, 0x00, 0x80, 0x33, 0x00, 0x80, 0x66, 0x00, 0x80, 0x99, 0x00,
        0x80, 0xCC, 0x00, 0x80, 0xFF, 0x00, 0xAA, 0x00, 0x00, 0xAA, 0x33, 0x00,
        0xAA, 0x66, 0x00, 0xAA, 0x99, 0x00, 0xAA, 0xCC, 0x00, 0xAA, 0xFF, 0x00,
        0xD5, 0x00, 0x00, 0xD5, 0x33, 0x00, 0xD5, 0x66, 0x00, 0xD5, 0x99, 0x00,
        0xD5, 0xCC, 0x00, 0xD5, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x33, 0x00,
        0xFF, 0x66, 0x00, 0xFF, 0x99, 0x00, 0xFF, 0xCC, 0x00, 0xFF, 0xFF, 0x33,
        0x00, 0x00, 0x33, 0x00, 0x33, 0x33, 0x00, 0x66, 0x33, 0x00, 0x99, 0x33,
        0x00, 0xCC, 0x33, 0x00, 0xFF, 0x33, 0x2B, 0x00, 0x33, 0x2B, 0x33, 0x33,
        0x2B, 0x66, 0x33, 0x2B, 0x99, 0x33, 0x2B, 0xCC, 0x33, 0x2B, 0xFF, 0x33,
        0x55, 0x00, 0x33, 0x55, 0x33, 0x33, 0x55, 0x66, 0x33, 0x55, 0x99, 0x33,
        0x55, 0xCC, 0x33, 0x55, 0xFF, 0x33, 0x80, 0x00, 0x33, 0x80, 0x33, 0x33,
        0x80, 0x66, 0x33, 0x80, 0x99, 0x33, 0x80, 0xCC, 0x33, 0x80, 0xFF, 0x33,
        0xAA, 0x00, 0x33, 0xAA, 0x33, 0x33, 0xAA, 0x66, 0x33, 0xAA, 0x99, 0x33,
        0xAA, 0xCC, 0x33, 0xAA, 0xFF, 0x33, 0xD5, 0x00, 0x33, 0xD5, 0x33, 0x33,
        0xD5, 0x66, 0x33, 0xD5, 0x99, 0x33, 0xD5, 0xCC, 0x33, 0xD5, 0xFF, 0x33,
        0xFF, 0x00, 0x33, 0xFF, 0x33, 0x33, 0xFF, 0x66, 0x33, 0xFF, 0x99, 0x33,
        0xFF, 0xCC, 0x33, 0xFF, 0xFF, 0x66, 0x00, 0x00, 0x66, 0x00, 0x33, 0x66,
        0x00, 0x66, 0x66, 0x00, 0x99, 0x66, 0x00, 0xCC, 0x66, 0x00, 0xFF, 0x66,
        0x2B, 0x00, 0x66, 0x2B, 0x33, 0x66, 0x2B, 0x66, 0x66, 0x2B, 0x99, 0x66,
        0x2B, 0xCC, 0x66, 0x2B, 0xFF, 0x66, 0x55, 0x00, 0x66, 0x55, 0x33, 0x66,
        0x55, 0x66, 0x66, 0x55, 0x99, 0x66, 0x55, 0xCC, 0x66, 0x55, 0xFF, 0x66,
        0x80, 0x00, 0x66, 0x80, 0x33, 0x66, 0x80, 0x66, 0x66, 0x80, 0x99, 0x66,
        0x80, 0xCC, 0x66, 0x80, 0xFF, 0x66, 0xAA, 0x00, 0x66, 0xAA, 0x33, 0x66,
        0xAA, 0x66, 0x66, 0xAA, 0x99, 0x66, 0xAA, 0xCC, 0x66, 0xAA, 0xFF, 0x66,
        0xD5, 0x00, 0x66, 0xD5, 0x33, 0x66, 0xD5, 0x66, 0x66, 0xD5, 0x99, 0x66,
        0xD5, 0xCC, 0x66, 0xD5, 0xFF, 0x66, 0xFF, 0x00, 0x66, 0xFF, 0x33, 0x66,
        0xFF, 0x66, 0x66, 0xFF, 0x99, 0x66, 0xFF, 0xCC, 0x66, 0xFF, 0xFF, 0x99,
        0x00, 0x00, 0x99, 0x00, 0x33, 0x99, 0x00, 0x66, 0x99, 0x00, 0x99, 0x99,
        0x00, 0xCC, 0x99, 0x00, 0xFF, 0x99, 0x2B, 0x00, 0x99, 0x2B, 0x33, 0x99,
        0x2B, 0x66, 0x99, 0x2B, 0x99, 0x99, 0x2B, 0xCC, 0x99, 0x2B, 0xFF, 0x99,
        0x55, 0x00, 0x99, 0x55, 0x33, 0x99, 0x55, 0x66, 0x99, 0x55, 0x99, 0x99,
        0x55, 0xCC, 0x99, 0x55, 0xFF, 0x99, 0x80, 0x00, 0x99, 0x80, 0x33, 0x99,
        0x80, 0x66, 0x99, 0x80, 0x99, 0x99, 0x80, 0xCC, 0x99, 0x80, 0xFF, 0x99,
        0xAA, 0x00, 0x99, 0xAA, 0x33, 0x99, 0xAA, 0x66, 0x99, 0xAA, 0x99, 0x99,
        0xAA, 0xCC, 0x99, 0xAA, 0xFF, 0x99, 0xD5, 0x00, 0x99, 0xD5, 0x33, 0x99,
        0xD5, 0x66, 0x99, 0xD5, 0x99, 0x99, 0xD5, 0xCC, 0x99, 0xD5, 0xFF, 0x99,
        0xFF, 0x00, 0x99, 0xFF, 0x33, 0x99, 0xFF, 0x66, 0x99, 0xFF, 0x99, 0x99,
        0xFF, 0xCC, 0x99, 0xFF, 0xFF, 0xCC, 0x00, 0x00, 0xCC, 0x00, 0x33, 0xCC,
        0x00, 0x66, 0xCC, 0x00, 0x99, 0xCC, 0x00, 0xCC, 0xCC, 0x00, 0xFF, 0xCC,
        0x2B, 0x00, 0xCC, 0x2B, 0x33, 0xCC, 0x2B, 0x66, 0xCC, 0x2B, 0x99, 0xCC,
        0x2B, 0xCC, 0xCC, 0x2B, 0xFF, 0xCC, 0x55, 0x00, 0xCC, 0x55, 0x33, 0xCC,
        0x55, 0x66, 0xCC, 0x55, 0x99, 0xCC, 0x55, 0xCC, 0xCC, 0x55, 0xFF, 0xCC,
        0x80, 0x00, 0xCC, 0x80, 0x33, 0xCC, 0x80, 0x66, 0xCC, 0x80, 0x99, 0xCC,
        0x80, 0xCC, 0xCC, 0x80, 0xFF, 0xCC, 0xAA, 0x00, 0xCC, 0xAA, 0x33, 0xCC,
        0xAA, 0x66, 0xCC, 0xAA, 0x99, 0xCC, 0xAA, 0xCC, 0xCC, 0xAA, 0xFF, 0xCC,
        0xD5, 0x00, 0xCC, 0xD5, 0x33, 0xCC, 0xD5, 0x66, 0xCC, 0xD5, 0x99, 0xCC,
        0xD5, 0xCC, 0xCC, 0xD5, 0xFF, 0xCC, 0xFF, 0x00, 0xCC, 0xFF, 0x33, 0xCC,
        0xFF, 0x66, 0xCC, 0xFF, 0x99, 0xCC, 0xFF, 0xCC, 0xCC, 0xFF, 0xFF, 0xFF,
        0x00, 0x00, 0xFF, 0x00, 0x33, 0xFF, 0x00, 0x66, 0xFF, 0x00, 0x99, 0xFF,
        0x00, 0xCC, 0xFF, 0x00, 0xFF, 0xFF, 0x2B, 0x00, 0xFF, 0x2B, 0x33, 0xFF,
        0x2B, 0x66, 0xFF, 0x2B, 0x99, 0xFF, 0x2B, 0xCC, 0xFF, 0x2B, 0xFF, 0xFF,
        0x55, 0x00, 0xFF, 0x55, 0x33, 0xFF, 0x55, 0x66, 0xFF, 0x55, 0x99, 0xFF,
        0x55, 0xCC, 0xFF, 0x55, 0xFF, 0xFF, 0x80, 0x00, 0xFF, 0x80, 0x33, 0xFF,
        0x80, 0x66, 0xFF, 0x80, 0x99, 0xFF, 0x80, 0xCC, 0xFF, 0x80, 0xFF, 0xFF,
        0xAA, 0x00, 0xFF, 0xAA, 0x33, 0xFF, 0xAA, 0x66, 0xFF, 0xAA, 0x99, 0xFF,
        0xAA, 0xCC, 0xFF, 0xAA, 0xFF, 0xFF, 0xD5, 0x00, 0xFF, 0xD5, 0x33, 0xFF,
        0xD5, 0x66, 0xFF, 0xD5, 0x99, 0xFF, 0xD5, 0xCC, 0xFF, 0xD5, 0xFF, 0xFF,
        0xFF, 0x00, 0xFF, 0xFF, 0x33, 0xFF, 0xFF, 0x66, 0xFF, 0xFF, 0x99, 0xFF,
        0xFF, 0xCC, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0xF9, 0x04, 0x01, 0x00, 0x00, 0xFC,
        0x00, 0x2C, 0x00, 0x00, 0x00, 0x00, 0x78, 0x00, 0x78, 0x00, 0x00, 0x08,
        0xFF, 0x00, 0xF7, 0x09, 0x1C, 0x48, 0xB0, 0xA0, 0xC1, 0x83, 0x08, 0x13,
        0x2A, 0x5C, 0xC8, 0xB0, 0xA1, 0xC3, 0x87, 0x10, 0x23, 0x4A, 0x9C, 0x48,
        0xB1, 0xA2, 0xC5, 0x8B, 0x18, 0x33, 0x6A, 0xDC, 0xC8, 0xB1, 0xA3, 0xC7,
        0x8F, 0x20, 0x43, 0x8A, 0x1C, 0x49, 0xB2, 0xA4, 0xC9, 0x93, 0x28, 0x53,
        0xAA, 0x5C, 0x69, 0x31, 0x93, 0x98, 0x97, 0x30, 0x63, 0xCA, 0x8C, 0x59,
        0xD0, 0xA5, 0x18, 0x65, 0x04, 0xA1, 0xBD, 0xCC, 0xD4, 0x50, 0xD9, 0xCC,
        0x9F, 0x3C, 0x09, 0xA2, 0xF9, 0x09, 0x13, 0xE7, 0xBE, 0xA1, 0x44, 0x93,
        0x06, 0x75, 0x78, 0x03, 0x80, 0xD3, 0xA7, 0x50, 0xA3, 0x3E, 0x35, 0x50,
        0x10, 0x8D, 0xD3, 0xA5, 0xFB, 0x88, 0x39, 0xBD, 0xD1, 0x70, 0x92, 0xD4,
        0xAF, 0x62, 0x0A, 0x7E, 0x85, 0x1A, 0x74, 0xAC, 0x59, 0xA7, 0x61, 0x1F,
        0x8A, 0x39, 0x3B, 0x76, 0x45, 0x41, 0xAF, 0x00, 0x88, 0x11, 0x54, 0x86,
        0xB6, 0x61, 0x26, 0xB6, 0x4E, 0xD1, 0x14, 0x8C, 0x71, 0x56, 0xEE, 0x3E,
        0xBE, 0x78, 0xA3, 0xA6, 0x75, 0xB8, 0x16, 0x40, 0x26, 0x65, 0x88, 0x13,
        0x2B, 0x4E, 0xCC, 0x97, 0x6A, 0xD6, 0x18, 0x31, 0xD0, 0x20, 0x16, 0x03,
        0x79, 0x20, 0xE2, 0x4C, 0x2B, 0x20, 0x6B, 0xDE, 0xCC, 0x75, 0xDF, 0x5D,
        0xBC, 0x83, 0x05, 0x02, 0xDE, 0x3A, 0xF9, 0xAA, 0x40, 0xA7, 0x31, 0x16,
        0xAB, 0x46, 0xAC, 0x15, 0x40, 0x68, 0x86, 0x85, 0xEB, 0x35, 0xE4, 0xEB,
        0xD6, 0xB3, 0xD3, 0x49, 0x02, 0x9B, 0x02, 0x30, 0x2A, 0xF0, 0xF3, 0xD8,
        0x18, 0xBD, 0x03, 0xEB, 0x25, 0x38, 0x1A, 0x40, 0xE7, 0xCF, 0x7E, 0x1B,
        0xF7, 0xAC, 0xAB, 0xD6, 0x29, 0x6F, 0x9C, 0xD0, 0xF7, 0xC9, 0x16, 0x68,
        0x00, 0x80, 0x63, 0xAD, 0x06, 0x26, 0x41, 0xAB, 0x77, 0x63, 0x85, 0xE3,
        0x81, 0xBE, 0x8B, 0xA3, 0xFF, 0x0E, 0xBE, 0x42, 0xAA, 0x01, 0xEF, 0xDE,
        0x71, 0x0B, 0xC4, 0xD9, 0x98, 0xB9, 0x55, 0xC3, 0xA7, 0x01, 0x00, 0x17,
        0x58, 0x6F, 0xBB, 0xFD, 0xE9, 0xFB, 0xE8, 0xBA, 0x86, 0x58, 0xD8, 0xE8,
        0xD8, 0xA0, 0xB4, 0xBD, 0x65, 0x9A, 0x41, 0xAD, 0xA9, 0xA7, 0xDB, 0x78,
        0x42, 0x45, 0x85, 0x50, 0x7F, 0xF1, 0xCD, 0x07, 0x57, 0x72, 0xF2, 0x05,
        0xF7, 0x15, 0x74, 0xCC, 0x11, 0xE6, 0x5C, 0x7E, 0xFF, 0x89, 0x66, 0x5D,
        0x41, 0x85, 0xF9, 0x55, 0xD3, 0x6D, 0x1A, 0x3E, 0x35, 0xDF, 0x40, 0x85,
        0x3D, 0x85, 0x90, 0x6E, 0xFE, 0xED, 0x77, 0xD4, 0x80, 0x08, 0xFA, 0xA6,
        0x20, 0x86, 0x2A, 0x5A, 0xB8, 0x5B, 0x7C, 0x52, 0xF9, 0x55, 0x5D, 0x6D,
        0xE0, 0xDD, 0x70, 0x43, 0x26, 0xC4, 0x60, 0xF5, 0xD8, 0x8E, 0x02, 0xA1,
        0x11, 0x83, 0x6E, 0x23, 0x0A, 0x54, 0xD8, 0x90, 0x37, 0xF4, 0xE8, 0x61,
        0x90, 0x5C, 0xEC, 0xD8, 0x23, 0x6A, 0xCA, 0x10, 0x33, 0xC9, 0x0D, 0xA9,
        0x69, 0x78, 0xDD, 0x58, 0xB2, 0xE9, 0xF7, 0xDA, 0x42, 0x0C, 0xD6, 0x93,
        0xE1, 0x3E, 0xE5, 0x7D, 0xB7, 0xD7, 0x85, 0x0C, 0x21, 0x48, 0x22, 0x99,
        0x5B, 0x21, 0x54, 0x9E, 0x54, 0xC3, 0x0D, 0xD4, 0xE2, 0x58, 0xEB, 0x55,
        0xD8, 0x10, 0x83, 0xFB, 0x7C, 0x19, 0xE0, 0x41, 0x85, 0x39, 0xC4, 0x57,
        0x91, 0x2B, 0xCE, 0x58, 0x67, 0x84, 0x07, 0x55, 0x27, 0x95, 0x7A, 0x03,
        0xDD, 0xD9, 0x9A, 0x54, 0xD0, 0xC0, 0xD8, 0x19, 0x53, 0x17, 0x42, 0x33,
        0x96, 0x8D, 0x1B, 0x12, 0x24, 0xA5, 0x90, 0x79, 0x4D, 0x82, 0x86, 0xA5,
        0x93, 0x58, 0xCA, 0x5B, 0x7C, 0xD9, 0x4D, 0x12, 0x54, 0x97, 0x69, 0x66,
        0x75, 0x29, 0xA6, 0x96, 0x96, 0xB8, 0x55, 0xA6, 0x46, 0x55, 0x37, 0x9F,
        0x8B, 0x50, 0xC5, 0x19, 0xE3, 0x9C, 0x68, 0x7E, 0xFF, 0x05, 0x20, 0x00,
        0x38, 0x06, 0x19, 0x18, 0xA1, 0x34, 0x32, 0x47, 0x27, 0x82, 0x70, 0x3D,
        0x95, 0xA2, 0x54, 0x41, 0x85, 0x29, 0xA1, 0x54, 0x59, 0xCA, 0x09, 0xDB,
        0x85, 0x5E, 0xCA, 0x4A, 0x1D, 0xA0, 0x03, 0xBD, 0xC7, 0x16, 0xAE, 0x7F,
        0x3E, 0x95, 0x16, 0x83, 0x8E, 0x1A, 0x37, 0xAC, 0x53, 0x6E, 0x7E, 0x05,
        0xE9, 0xAA, 0x70, 0xC2, 0xB8, 0xA5, 0x42, 0x74, 0x2A, 0xC9, 0xE3, 0xB8,
        0x85, 0x62, 0x9B, 0xDF, 0x0D, 0x62, 0xA0, 0x21, 0x6E, 0x6B, 0x31, 0x8C,
        0xDB, 0xE3, 0xA6, 0x59, 0x65, 0xF2, 0x59, 0x5A, 0xCA, 0xC8, 0x3B, 0x9D,
        0x53, 0x2B, 0xA0, 0x8B, 0x06, 0x8F, 0x44, 0x8A, 0x41, 0x64, 0x8F, 0x85,
        0xCD, 0x8A, 0xE3, 0xBA, 0xE4, 0x7A, 0xCB, 0x1F, 0x99, 0x0B, 0xED, 0x29,
        0x21, 0xB4, 0xAA, 0x2E, 0x07, 0x40, 0x9B, 0x04, 0x25, 0x2B, 0xAD, 0x91,
        0x5F, 0x75, 0xF6, 0x60, 0x83, 0x0E, 0x7F, 0x9B, 0x10, 0x9D, 0x09, 0x9B,
        0xDB, 0x1A, 0xC4, 0x60, 0x32, 0xAB, 0x90, 0x96, 0x08, 0x45, 0x35, 0x9C,
        0xA9, 0x4F, 0x75, 0xF6, 0xDE, 0xAC, 0x62, 0x26, 0x44, 0x72, 0x73, 0xA8,
        0xC9, 0x77, 0x9E, 0x01, 0x7B, 0xCA, 0x67, 0x33, 0xA0, 0x9F, 0xA9, 0x27,
        0x06, 0xCD, 0xAC, 0x9D, 0x37, 0x1C, 0x1A, 0xDE, 0x41, 0x78, 0x53, 0xBD,
        0xF2, 0x05, 0xD5, 0x5D, 0x0C, 0xDB, 0xCD, 0x9B, 0x9B, 0x53, 0xC4, 0x40,
        0xD3, 0x5A, 0x5A, 0x17, 0x47, 0x5B, 0x73, 0x0C, 0x33, 0x4F, 0x3D, 0x31,
        0xCC, 0x81, 0xB5, 0x9A, 0x55, 0x5E, 0x4B, 0x03, 0x20, 0x50, 0xB5, 0x9D,
        0xED, 0x8A, 0xF3, 0x80, 0x80, 0xB9, 0x7A, 0x72, 0xAC, 0xF3, 0xAD, 0x1C,
        0x62, 0xD6, 0xA1, 0x3A, 0x84, 0x06, 0xCD, 0x54, 0xEF, 0x19, 0xF7, 0xDC,
        0x34, 0xD3, 0x7C, 0x1C, 0x88, 0x7F, 0x39, 0x55, 0xAC, 0x8A, 0x93, 0x9C,
        0xFF, 0x77, 0x98, 0x7E, 0x48, 0xD7, 0x03, 0x97, 0xD1, 0x99, 0x09, 0x44,
        0x8C, 0xCF, 0xF5, 0x31, 0xF8, 0x32, 0x66, 0x06, 0x18, 0x05, 0x59, 0xDD,
        0x71, 0x7B, 0xF7, 0xB8, 0x66, 0x70, 0x83, 0x1C, 0xD2, 0xC7, 0x14, 0x03,
        0x90, 0xE8, 0xCB, 0x03, 0x1D, 0xF8, 0x15, 0xB4, 0x02, 0x42, 0x95, 0xE2,
        0xA2, 0x2C, 0x4D, 0x94, 0x73, 0xD7, 0xF4, 0x19, 0x2B, 0x5E, 0x54, 0x3E,
        0x7E, 0x08, 0xD5, 0xBD, 0x22, 0x97, 0x6E, 0x50, 0xBD, 0x04, 0x8B, 0x8B,
        0xEE, 0xA7, 0xB7, 0xC9, 0xBB, 0xD5, 0xBB, 0x02, 0x4D, 0x59, 0xA2, 0xBF,
        0x80, 0x05, 0x35, 0xAE, 0xBC, 0x46, 0xC1, 0x15, 0x83, 0xBF, 0xF2, 0x66,
        0xA2, 0xEF, 0xF0, 0xC4, 0x18, 0xE5, 0x2E, 0x8F, 0x08, 0x29, 0xE9, 0x51,
        0xAF, 0x15, 0x8F, 0x69, 0x16, 0xB4, 0xA1, 0x7E, 0x36, 0xAB, 0x88, 0xBD,
        0x0F, 0xB8, 0xA6, 0xE1, 0xAC, 0xE7, 0x6A, 0xED, 0x41, 0x4E, 0xB5, 0x9C,
        0x91, 0xB3, 0x5F, 0xF1, 0xE9, 0x39, 0xB0, 0x62, 0xD1, 0x2A, 0xE1, 0xF6,
        0x6F, 0xC6, 0xA5, 0xE1, 0x7C, 0xFA, 0x3D, 0xE5, 0x97, 0x60, 0x25, 0xBB,
        0x2F, 0x91, 0x4B, 0x68, 0xE0, 0x27, 0xA9, 0xA5, 0x80, 0x11, 0x03, 0xA9,
        0x30, 0xE5, 0x97, 0xF5, 0xA1, 0xC6, 0x52, 0x97, 0x42, 0x43, 0x02, 0x3D,
        0x15, 0x14, 0xB8, 0xBC, 0x04, 0x53, 0x0B, 0x54, 0x60, 0x02, 0x13, 0xF8,
        0x94, 0x4B, 0xAD, 0x2F, 0x5D, 0x10, 0x44, 0x8D, 0x02, 0x97, 0xB4, 0x0F,
        0x4B, 0xB5, 0x0E, 0x56, 0x7E, 0x5A, 0x90, 0xB9, 0x06, 0x82, 0xB9, 0x7D,
        0x70, 0x01, 0x2C, 0x99, 0x33, 0x11, 0x41, 0x58, 0xB5, 0xA9, 0x97, 0xA1,
        0x8C, 0x2D, 0xD9, 0xAA, 0xE0, 0x46, 0x50, 0x04, 0x2E, 0xA7, 0x24, 0x0A,
        0x3C, 0x5C, 0xDB, 0x87, 0x01, 0xC7, 0x87, 0x3E, 0xAF, 0x11, 0x84, 0x7A,
        0x21, 0x84, 0xD1, 0x70, 0xFF, 0x76, 0x68, 0x16, 0x0A, 0x41, 0x05, 0x74,
        0x15, 0x89, 0x12, 0x07, 0x95, 0x31, 0x24, 0x24, 0x89, 0x88, 0x32, 0x3A,
        0xBA, 0x49, 0x26, 0xA6, 0xE3, 0x39, 0x03, 0x10, 0xA3, 0x47, 0x4D, 0x12,
        0xCF, 0xA6, 0x9C, 0x46, 0x0C, 0x1A, 0xEE, 0x03, 0x78, 0xF8, 0xA2, 0x0C,
        0x8F, 0x88, 0xB1, 0x3A, 0xD7, 0x34, 0x0F, 0x30, 0x46, 0xE9, 0x91, 0xF1,
        0x74, 0xE4, 0x17, 0x7F, 0x69, 0x6C, 0x22, 0x87, 0x3A, 0xCB, 0x6B, 0x4E,
        0xC8, 0x3D, 0xDB, 0x7C, 0x45, 0x84, 0x33, 0x92, 0x58, 0xF8, 0xF6, 0x21,
        0x28, 0x93, 0xA1, 0x6E, 0x85, 0x51, 0x91, 0x4B, 0xB5, 0xF8, 0x64, 0x91,
        0x38, 0x9A, 0x85, 0x74, 0x3A, 0x84, 0x0A, 0xB7, 0xBE, 0xE2, 0xBF, 0x33,
        0xC9, 0x2F, 0x5A, 0x7B, 0x2C, 0xE3, 0xD9, 0x82, 0x68, 0xC8, 0x60, 0x8D,
        0xF0, 0x60, 0x33, 0xA2, 0x4B, 0x1F, 0x9F, 0x12, 0x94, 0xFA, 0xC8, 0x06,
        0x3F, 0x56, 0x11, 0xCF, 0x22, 0x71, 0x03, 0x8D, 0xB2, 0xC1, 0x28, 0x66,
        0xE5, 0x93, 0xCF, 0x73, 0xD6, 0xB3, 0x96, 0xD4, 0xD4, 0xA3, 0x7E, 0x4F,
        0xF1, 0xCE, 0x53, 0x1A, 0xB9, 0x9D, 0x7D, 0x6C, 0xA7, 0x3B, 0x7D, 0xE4,
        0xCB, 0x1B, 0xF1, 0x14, 0xAB, 0x1A, 0x29, 0x04, 0x88, 0xE5, 0x03, 0x1F,
        0x00, 0x0C, 0x64, 0x2E, 0x58, 0xDE, 0x91, 0x97, 0x7E, 0x62, 0xCB, 0x0D,
        0x4F, 0x84, 0x42, 0x98, 0x39, 0x6E, 0x33, 0x6B, 0x0A, 0x4A, 0x62, 0xBE,
        0x56, 0x1A, 0x45, 0x0E, 0xE9, 0x95, 0x8C, 0xDB, 0xDE, 0x65, 0x60, 0x48,
        0x90, 0x65, 0x4C, 0x06, 0x32, 0xD0, 0xD1, 0x4C, 0x54, 0x32, 0x13, 0x83,
        0xE6, 0x3D, 0x47, 0x19, 0xD3, 0xA1, 0xCC, 0x66, 0x8C, 0xC5, 0x25, 0x84,
        0x01, 0x12, 0x3E, 0x79, 0xF3, 0xA1, 0x21, 0x7D, 0xA5, 0xA8, 0x82, 0x10,
        0xB1, 0x5B, 0x03, 0x19, 0xDC, 0x41, 0x2A, 0xB9, 0xFF, 0xAC, 0xDA, 0x7C,
        0xC6, 0x72, 0x06, 0x7B, 0x88, 0x17, 0xAB, 0xC2, 0xB4, 0xF8, 0xF8, 0xB3,
        0x5B, 0x9C, 0x5B, 0x1B, 0x5E, 0x6A, 0x65, 0x47, 0x0E, 0xBA, 0x8A, 0x9E,
        0x7F, 0x72, 0xCC, 0xE9, 0x66, 0xD7, 0x36, 0xBB, 0xEC, 0x44, 0x5E, 0x05,
        0x21, 0x86, 0xBF, 0x18, 0x88, 0x14, 0x79, 0xF5, 0x10, 0x5D, 0x62, 0xD8,
        0xDB, 0x6B, 0x24, 0xF1, 0x12, 0x69, 0x51, 0x66, 0x2B, 0x25, 0xBD, 0x4A,
        0xF2, 0x5C, 0x82, 0x16, 0x8C, 0xF6, 0x26, 0x13, 0xEF, 0x39, 0x9E, 0x00,
        0x3D, 0xFA, 0x12, 0x61, 0xAA, 0xA7, 0x47, 0xD2, 0xDC, 0xC9, 0x44, 0xBE,
        0x87, 0x4C, 0xD9, 0x54, 0xCB, 0x97, 0x96, 0x61, 0x67, 0x7C, 0xEE, 0x06,
        0xCF, 0x7B, 0x8A, 0xEE, 0x94, 0x39, 0xD4, 0x8D, 0xEB, 0xD4, 0x63, 0xCA,
        0x8B, 0x08, 0x0A, 0x8F, 0x37, 0x1C, 0x4B, 0x0B, 0x2B, 0x3A, 0x97, 0x2B,
        0x92, 0x70, 0x8A, 0xEB, 0x21, 0xC6, 0x30, 0x34, 0x31, 0x8C, 0x1E, 0x19,
        0xF0, 0x57, 0x78, 0xE3, 0x98, 0x1D, 0x8D, 0xE6, 0x4E, 0x8A, 0x64, 0xC2,
        0x53, 0x18, 0xEC, 0xCD, 0x50, 0x04, 0x05, 0x93, 0xB1, 0xE8, 0x2B, 0x9F,
        0x93, 0x58, 0x92, 0x32, 0x42, 0x41, 0x0C, 0x50, 0x28, 0x63, 0x19, 0x76,
        0xD5, 0x84, 0x32, 0x40, 0xE1, 0x4D, 0x50, 0x10, 0x23, 0x14, 0x77, 0x85,
        0x06, 0x5E, 0x33, 0x27, 0x86, 0xB3, 0x22, 0x25, 0x2A, 0x91, 0x39, 0x29,
        0x00, 0xFC, 0xC7, 0xAE, 0xA1, 0x34, 0x35, 0x23, 0xBC, 0x62, 0xDB, 0x51,
        0x0F, 0xA2, 0x09, 0x1C, 0x20, 0xC0, 0x01, 0x08, 0x78, 0xC0, 0x65, 0x13,
        0xE0, 0x00, 0xCE, 0x7A, 0xB6, 0xB3, 0x98, 0xE5, 0x2C, 0x02, 0x10, 0xA0,
        0x89, 0x7D, 0x84, 0x01, 0x9E, 0x65, 0x94, 0xCA, 0xA6, 0x58, 0x05, 0x51,
        0xC8, 0x8E, 0x0F, 0x98, 0x81, 0x69, 0xE4, 0x7A, 0x3A, 0xFB, 0x80, 0x04,
        0xFF, 0xD4, 0xF6, 0xB6, 0xB6, 0x4D, 0x00, 0x0E, 0x72, 0x7B, 0xDB, 0xDE,
        0xCA, 0x20, 0x1A, 0x77, 0x29, 0x4B, 0x60, 0x96, 0xB9, 0xB5, 0x63, 0x52,
        0x64, 0x12, 0x9C, 0x69, 0xDE, 0x94, 0xA8, 0x76, 0x9B, 0x28, 0xB1, 0x66,
        0x77, 0x3E, 0xB9, 0x4A, 0xF3, 0xD6, 0xD3, 0x44, 0x18, 0xDC, 0x75, 0xB7,
        0x0F, 0xB8, 0x2D, 0x68, 0x73, 0x90, 0xD9, 0xDA, 0x3A, 0x80, 0xBB, 0x0F,
        0x00, 0xAD, 0x6D, 0x11, 0x00, 0x8A, 0xAC, 0x58, 0x26, 0x4A, 0x50, 0x72,
        0xAE, 0x73, 0xFD, 0xC2, 0x1D, 0xC8, 0xE4, 0xE5, 0x8C, 0xA8, 0x39, 0xDE,
        0x44, 0xD6, 0xF7, 0xD0, 0x01, 0x7D, 0x8D, 0x39, 0x51, 0xAB, 0x6F, 0x26,
        0x96, 0x91, 0x59, 0x04, 0xEC, 0x16, 0xBB, 0xB6, 0xD5, 0x2C, 0x6E, 0x1F,
        0x30, 0x83, 0xDA, 0xE2, 0xC0, 0xC0, 0x0E, 0x1D, 0xEA, 0xC8, 0xA2, 0x42,
        0xCC, 0xA9, 0x4C, 0xA4, 0x87, 0xC2, 0xB4, 0xDF, 0x5C, 0xCA, 0xA3, 0x32,
        0xFB, 0x22, 0xB5, 0x79, 0xDD, 0x0D, 0x30, 0x6D, 0x3B, 0xCB, 0x5D, 0xF0,
        0x3A, 0x40, 0xC0, 0xB8, 0x2D, 0x6F, 0x7E, 0xDA, 0xF7, 0xAD, 0x1B, 0x1A,
        0x73, 0x88, 0x8A, 0xB4, 0x88, 0xC2, 0x8A, 0x0B, 0xAD, 0x15, 0x37, 0xCB,
        0x9D, 0x2F, 0x03, 0x45, 0x6E, 0x3B, 0x9B, 0x00, 0xF0, 0x66, 0x36, 0xC0,
        0x37, 0x2E, 0x70, 0x02, 0x36, 0xEB, 0x80, 0x65, 0x0C, 0x63, 0xB2, 0xCC,
        0xAC, 0xE3, 0x8B, 0x63, 0x49, 0x5C, 0x8A, 0x98, 0x52, 0x3F, 0x20, 0x53,
        0x61, 0x3E, 0x2D, 0xAC, 0x9F, 0xCE, 0x28, 0x43, 0xB3, 0x39, 0xC8, 0xC1,
        0x81, 0x39, 0x9C, 0x83, 0xDA, 0x66, 0x36, 0x07, 0x05, 0xFE, 0xF0, 0x77,
        0x73, 0x60, 0x5B, 0x65, 0x68, 0x02, 0xC8, 0xC8, 0x54, 0x72, 0xF7, 0x5E,
        0x87, 0x11, 0x53, 0xCE, 0x4B, 0xBD, 0xCA, 0xA0, 0x12, 0xBD, 0xAA, 0x29,
        0x57, 0xE6, 0x68, 0xA2, 0xFF, 0xB3, 0x3F, 0xD8, 0x47, 0x6D, 0x67, 0xE0,
        0x00, 0x4D, 0xF0, 0x37, 0x0D, 0x88, 0xD9, 0x07, 0x1C, 0x10, 0x90, 0x80,
        0x1A, 0xEF, 0xE3, 0x07, 0x97, 0xF5, 0x26, 0x64, 0xA8, 0x34, 0x9D, 0xE6,
        0x19, 0x9A, 0x35, 0x44, 0x42, 0x17, 0x09, 0x7D, 0x32, 0x24, 0x9E, 0x5E,
        0xE4, 0xC8, 0x58, 0x92, 0x54, 0x54, 0x86, 0xD1, 0x4D, 0xA7, 0x84, 0x41,
        0x20, 0xFC, 0x7D, 0xC0, 0x18, 0xF6, 0x01, 0xDE, 0x04, 0x94, 0x96, 0x27,
        0xD1, 0x28, 0xAD, 0x26, 0x32, 0xFB, 0xDD, 0x7D, 0xA4, 0xA1, 0xB6, 0x09,
        0x36, 0x26, 0xB1, 0xDE, 0x49, 0xD6, 0x20, 0x52, 0xE4, 0xA9, 0xC5, 0x45,
        0xD4, 0x3B, 0x5B, 0xBB, 0x0F, 0x7A, 0x38, 0x05, 0x07, 0xEB, 0xC9, 0xEC,
        0xA6, 0x73, 0x00, 0xDA, 0xD2, 0xEE, 0x63, 0xD4, 0x3D, 0xD6, 0x84, 0x95,
        0x73, 0xF0, 0x67, 0xCE, 0xC2, 0x2B, 0x86, 0x63, 0x21, 0xEE, 0x44, 0x1F,
        0x2B, 0x11, 0x29, 0xC1, 0x34, 0x5D, 0x11, 0x66, 0xB0, 0xA7, 0x3C, 0x15,
        0xD3, 0x97, 0xA4, 0x41, 0x5E, 0x0C, 0x4C, 0x57, 0x61, 0xEF, 0x0A, 0x67,
        0x4E, 0xF7, 0xB7, 0xB4, 0xA0, 0xE0, 0x73, 0x02, 0x7E, 0x7D, 0xD9, 0x07,
        0x10, 0x3B, 0x0D, 0x3B, 0x2E, 0x06, 0x34, 0xA6, 0x9D, 0x3C, 0xD8, 0x1A,
        0xE7, 0x25, 0x8C, 0xCD, 0xA1, 0x58, 0x23, 0xA2, 0x1B, 0xFF, 0x7D, 0x42,
        0xB2, 0xF0, 0x33, 0xD7, 0x8F, 0xF5, 0xBA, 0x63, 0x35, 0x70, 0x1A, 0x0E,
        0xC5, 0xC0, 0x41, 0x69, 0xD5, 0xF0, 0x61, 0x1C, 0xE0, 0xC4, 0x9B, 0xDE,
        0x2C, 0x76, 0x8F, 0x7F, 0x9C, 0xB5, 0x04, 0x4F, 0x54, 0xA9, 0x15, 0x11,
        0xAB, 0xAA, 0xCF, 0xD2, 0x60, 0x04, 0x7D, 0xB9, 0x79, 0x9C, 0x8D, 0x73,
        0x1A, 0xA2, 0xB1, 0x0F, 0x50, 0x88, 0xFA, 0xC6, 0xCB, 0xF8, 0x35, 0x60,
        0x43, 0x8E, 0xEE, 0x1E, 0xB3, 0xD6, 0x2C, 0x1F, 0xFF, 0x2C, 0x50, 0x88,
        0x8E, 0xFD, 0x10, 0x9C, 0xCA, 0x44, 0x37, 0x3B, 0x5A, 0x69, 0xBB, 0x59,
        0x2A, 0x9F, 0x9D, 0x78, 0xAA, 0x82, 0xE9, 0xCA, 0x04, 0x3D, 0x42, 0xA1,
        0xEB, 0xFC, 0x28, 0x23, 0x0D, 0xFB, 0x08, 0x79, 0x34, 0x64, 0xD0, 0xE5,
        0x51, 0x43, 0x59, 0xE1, 0x3E, 0x86, 0x8A, 0x24, 0x56, 0xCA, 0xC0, 0xE4,
        0x4D, 0x07, 0x29, 0x2F, 0xD1, 0x4D, 0x83, 0x59, 0x59, 0xD8, 0x89, 0x94,
        0xB1, 0x11, 0x0B, 0x86, 0x0A, 0x84, 0xAE, 0xF6, 0xE4, 0x04, 0xC4, 0x79,
        0x1F, 0x6A, 0x20, 0xED, 0x40, 0xA0, 0x91, 0x83, 0xDF, 0x1A, 0x1D, 0x01,
        0xE7, 0xEE, 0xB3, 0x97, 0xA1, 0x12, 0xF2, 0x32, 0x7D, 0x65, 0x92, 0x7B,
        0x43, 0xA4, 0x9E, 0xDE, 0xAE, 0x10, 0x16, 0x8A, 0x2F, 0x2D, 0xC4, 0xE8,
        0x2C, 0xD0, 0x97, 0xA1, 0xF7, 0xFC, 0xF8, 0x1A, 0x27, 0x9A, 0xC8, 0x6D,
        0x9C, 0x7F, 0xA0, 0xDB, 0xA4, 0xD3, 0x3A, 0x21, 0x65, 0x64, 0x6A, 0x31,
        0x85, 0x9A, 0x10, 0x21, 0xA5, 0xF6, 0x64, 0x9A, 0xC9, 0x97, 0x30, 0x87,
        0xA6, 0x4E, 0xA9, 0xC4, 0x20, 0x19, 0x99, 0xCE, 0x41, 0xA8, 0xFB, 0xCB,
        0xD7, 0xEF, 0xEA, 0x35, 0x1A, 0x7B, 0xE6, 0xB0, 0xA9, 0x33, 0xBB, 0xF6,
        0x49, 0x20, 0x26, 0x0C, 0x95, 0x79, 0x4C, 0x0C, 0xD4, 0xE3, 0x78, 0x5F,
        0x29, 0xE6, 0x86, 0x5E, 0x9C, 0x26, 0xD6, 0x3E, 0xD7, 0x35, 0x15, 0x6A,
        0x4F, 0xA1, 0x51, 0xD1, 0x6B, 0x77, 0x2D, 0x9B, 0x5D, 0x02, 0x7B, 0x97,
        0xB3, 0x05, 0xF6, 0xFD, 0x77, 0xC7, 0x9B, 0xF4, 0xA0, 0x04, 0x20, 0x52,
        0x25, 0x2C, 0x0E, 0x21, 0x43, 0x64, 0x91, 0x12, 0x6D, 0x52, 0x57, 0xE5,
        0x91, 0x9C, 0xE1, 0xF8, 0x32, 0x9C, 0x30, 0x04, 0xA0, 0x8F, 0x33, 0x8B,
        0x4B, 0xA6, 0x73, 0x8B, 0xDD, 0xFE, 0x66, 0x77, 0xBC, 0xBF, 0xE7, 0x6C,
        0xFF, 0x6D, 0x9D, 0x86, 0x5A, 0x5A, 0xE1, 0x64, 0xA2, 0x3B, 0x93, 0x65,
        0x91, 0x70, 0x22, 0x1B, 0x14, 0xDD, 0x27, 0x22, 0xA0, 0x82, 0x0A, 0x40,
        0x19, 0xA2, 0x82, 0xD8, 0x81, 0x42, 0xC7, 0xB7, 0xED, 0x2E, 0x9D, 0x3F,
        0xCB, 0xE5, 0x0F, 0xF3, 0x16, 0x01, 0xCB, 0x10, 0x5C, 0xB8, 0x97, 0x43,
        0x08, 0x71, 0x72, 0xF8, 0x72, 0x35, 0x32, 0x02, 0x56, 0x0F, 0x33, 0x11,
        0x07, 0x70, 0x49, 0xF9, 0x41, 0x6A, 0xBA, 0x85, 0x63, 0xBD, 0x85, 0x7F,
        0xBE, 0x17, 0x81, 0x0E, 0x80, 0x5E, 0x41, 0x01, 0x03, 0xB4, 0x97, 0x10,
        0xF3, 0x54, 0x3D, 0x0F, 0x81, 0x06, 0x54, 0xD2, 0x3C, 0xBE, 0x41, 0x25,
        0x71, 0xA5, 0x0C, 0x37, 0x44, 0x0C, 0x9F, 0x20, 0x82, 0x46, 0xB1, 0x5E,
        0xCA, 0x30, 0x0C, 0x38, 0x80, 0x2E, 0xCE, 0x25, 0x10, 0xE1, 0xE6, 0x5D,
        0x06, 0x66, 0x5B, 0xBB, 0x25, 0x5E, 0x38, 0x98, 0x7F, 0x01, 0xF8, 0x48,
        0x60, 0x24, 0x7F, 0x59, 0xC5, 0x41, 0xCA, 0x73, 0x3C, 0x4D, 0x04, 0x45,
        0x4D, 0x74, 0x03, 0x48, 0xC4, 0x10, 0x9B, 0x04, 0x35, 0x03, 0xB2, 0x49,
        0x15, 0xA6, 0x35, 0x4D, 0x86, 0x69, 0xBC, 0xC7, 0x5B, 0x52, 0xD8, 0x5B,
        0x52, 0x08, 0x5A, 0xB6, 0xE1, 0x23, 0x0C, 0xD6, 0x35, 0x2C, 0xF7, 0x11,
        0xC5, 0x61, 0x31, 0x2C, 0x02, 0x15, 0xD3, 0x12, 0x15, 0xF4, 0x10, 0x50,
        0xBF, 0xF6, 0x5F, 0x97, 0x75, 0x86, 0x0E, 0x20, 0x03, 0x69, 0xB8, 0x86,
        0x6A, 0x28, 0x03, 0x0F, 0xA0, 0x86, 0x33, 0x50, 0x5A, 0x4D, 0x81, 0x15,
        0x27, 0xC6, 0x7C, 0x23, 0x71, 0x56, 0xAC, 0xB2, 0x7A, 0x30, 0x35, 0x14,
        0xC5, 0x33, 0x14, 0xA1, 0x42, 0x0C, 0x8E, 0xE5, 0x14, 0x1C, 0x07, 0x38,
        0x92, 0xE0, 0x29, 0xFB, 0x10, 0x0D, 0x88, 0x81, 0x70, 0x77, 0xB5, 0x0C,
        0x8C, 0xD8, 0x88, 0x8D, 0xFF, 0xB8, 0x57, 0xDE, 0xC4, 0x71, 0x92, 0x60,
        0x61, 0x1D, 0x24, 0x41, 0x62, 0xE0, 0x17, 0xFC, 0xB3, 0x40, 0x86, 0x98,
        0x1F, 0x99, 0x72, 0x56, 0xEA, 0x51, 0x2F, 0x71, 0x85, 0x49, 0x63, 0x31,
        0x7F, 0xC6, 0xA2, 0x1B, 0x63, 0xA8, 0x6A, 0xED, 0xA2, 0x24, 0xFA, 0x50,
        0x1F, 0xC3, 0x90, 0x09, 0xAD, 0xF8, 0x8A, 0x87, 0x21, 0x1D, 0xB5, 0x16,
        0x80, 0xA3, 0x91, 0x60, 0x09, 0x11, 0x15, 0x61, 0x13, 0x15, 0x9B, 0x43,
        0x55, 0xED, 0x74, 0x3D, 0xF9, 0xC3, 0x27, 0x85, 0x31, 0x88, 0x6C, 0xA1,
        0x0C, 0xD1, 0xD0, 0x81, 0x86, 0x31, 0x4D, 0xAC, 0xF2, 0x41, 0x88, 0x07,
        0x86, 0xB6, 0xE2, 0x84, 0x8C, 0x87, 0x10, 0xF5, 0xC2, 0x3C, 0x30, 0x85,
        0x1A, 0xFE, 0x62, 0x14, 0x51, 0x37, 0x2E, 0xFE, 0xB2, 0x75, 0xD3, 0x21,
        0x2F, 0x85, 0x51, 0x58, 0x87, 0x83, 0x16, 0x54, 0x72, 0x6B, 0x99, 0xA0,
        0x09, 0x34, 0xC4, 0x1D, 0x3B, 0x31, 0x0C, 0x47, 0xE2, 0x2F, 0xFE, 0xE3,
        0x13, 0x20, 0x05, 0x52, 0x85, 0x61, 0x45, 0x67, 0x85, 0x2E, 0x0C, 0x14,
        0x40, 0xFE, 0xF2, 0x8C, 0x0F, 0x61, 0x4C, 0xC2, 0xE5, 0x43, 0xFF, 0x24,
        0x10, 0xA7, 0x45, 0x49, 0x64, 0xD3, 0x4C, 0x1D, 0x82, 0x31, 0x76, 0x44,
        0x6B, 0x5F, 0x66, 0x16, 0xF3, 0xA1, 0x72, 0x89, 0x24, 0x15, 0xBB, 0xE4,
        0x10, 0x86, 0x04, 0x21, 0x07, 0x89, 0x37, 0x10, 0x87, 0x43, 0xC3, 0x54,
        0x7B, 0xCC, 0xF8, 0x45, 0x17, 0xA2, 0x0F, 0xA1, 0x02, 0x44, 0x9B, 0xC2,
        0x70, 0x63, 0x21, 0x51, 0x78, 0x53, 0x46, 0x0B, 0x59, 0x15, 0x31, 0x20,
        0x39, 0x8F, 0x33, 0x34, 0xEF, 0x21, 0x39, 0xE6, 0x34, 0x2C, 0x07, 0x30,
        0x1A, 0xF0, 0x92, 0x67, 0xEB, 0xF1, 0x4A, 0x88, 0x01, 0x93, 0x43, 0xA6,
        0x02, 0x2B, 0x79, 0x57, 0x99, 0x00, 0x19, 0x92, 0xFF, 0x91, 0x88, 0x69,
        0x96, 0x7A, 0x4F, 0xB3, 0x1A, 0xDB, 0x28, 0x22, 0xA2, 0x84, 0x18, 0x45,
        0xB6, 0x10, 0x3B, 0xE4, 0x20, 0x2F, 0x42, 0x42, 0xF8, 0x34, 0x11, 0x28,
        0xE3, 0x2A, 0xAF, 0xC1, 0x53, 0xA0, 0x80, 0x37, 0xD1, 0x73, 0x16, 0xCB,
        0xC7, 0x10, 0x40, 0x33, 0x33, 0x6B, 0x72, 0x1C, 0x55, 0xB3, 0x1B, 0xBC,
        0x61, 0x80, 0xC7, 0x86, 0x4E, 0xDB, 0x11, 0x1D, 0x60, 0x99, 0x38, 0x51,
        0x71, 0x57, 0x0C, 0x07, 0x32, 0x37, 0x40, 0x33, 0xCB, 0x40, 0x0F, 0xFB,
        0x28, 0x1D, 0xF7, 0x71, 0x43, 0xAC, 0x82, 0x1E, 0xE7, 0x21, 0x77, 0x12,
        0x51, 0x2D, 0x5C, 0x80, 0x10, 0xA6, 0x64, 0x8C, 0xAE, 0x23, 0x59, 0x66,
        0xF1, 0x2D, 0xB6, 0x76, 0x44, 0x14, 0xB9, 0x48, 0x87, 0xE7, 0x5A, 0x72,
        0x19, 0x2D, 0xD7, 0x02, 0x66, 0x06, 0xA8, 0x97, 0x04, 0xD8, 0x3E, 0x32,
        0x64, 0x91, 0x5A, 0xD3, 0x90, 0x1D, 0x91, 0x2C, 0xE5, 0xE4, 0x2E, 0x37,
        0x04, 0x13, 0xD1, 0x26, 0x1F, 0x61, 0x80, 0x03, 0xDB, 0x08, 0x88, 0x88,
        0x85, 0x2E, 0x54, 0xB2, 0x3E, 0x43, 0xE2, 0x46, 0x9C, 0x19, 0x40, 0x59,
        0x25, 0x4D, 0xD2, 0x62, 0x84, 0x5B, 0xA5, 0x7C, 0xEB, 0x11, 0x45, 0x3A,
        0x52, 0x30, 0x9E, 0x31, 0x5D, 0x15, 0xF1, 0x25, 0x79, 0x59, 0x50, 0x41,
        0x35, 0x21, 0x11, 0xB3, 0x47, 0x05, 0x81, 0x64, 0x5A, 0xA8, 0x60, 0xA6,
        0x96, 0x3E, 0x76, 0x79, 0x21, 0x4F, 0xF8, 0x9A, 0xCA, 0x62, 0x10, 0x76,
        0x37, 0x10, 0x7D, 0x09, 0x54, 0xF5, 0x05, 0x4F, 0x19, 0x15, 0x56, 0xBE,
        0xE9, 0x14, 0x32, 0x20, 0x10, 0x93, 0x68, 0x79, 0x41, 0xC6, 0x94, 0x10,
        0x61, 0x58, 0x08, 0x84, 0x58, 0x97, 0xE2, 0x3C, 0x97, 0x42, 0x1F, 0x16,
        0x84, 0x16, 0x92, 0x90, 0x06, 0xDD, 0x79, 0x24, 0x11, 0x44, 0x5C, 0xF5,
        0xFF, 0x10, 0x41, 0x98, 0x98, 0x9D, 0x30, 0x12, 0x03, 0xDD, 0x89, 0x46,
        0xBD, 0xB3, 0x74, 0x02, 0x91, 0x06, 0xA3, 0x08, 0x41, 0x98, 0x02, 0x18,
        0xF0, 0xA9, 0x8C, 0x41, 0x36, 0x16, 0xD8, 0xE3, 0x80, 0xEE, 0x66, 0x8F,
        0x09, 0xC1, 0x53, 0xC6, 0xC8, 0x72, 0xCF, 0x89, 0x98, 0xFA, 0x03, 0x7F,
        0x67, 0x01, 0x32, 0xCC, 0xD6, 0x43, 0xF8, 0x23, 0x11, 0x90, 0x46, 0x9B,
        0x06, 0x91, 0x9F, 0x78, 0x31, 0x95, 0x0B, 0x41, 0x3B, 0xCF, 0xA3, 0x24,
        0xF0, 0xC2, 0x3B, 0xE7, 0xA2, 0x58, 0x9C, 0x24, 0x2E, 0xCA, 0x53, 0x75,
        0x5F, 0xA4, 0x68, 0x15, 0x0A, 0x2D, 0xB4, 0x53, 0x98, 0xEA, 0xB2, 0x14,
        0x37, 0x80, 0x03, 0x97, 0x19, 0x8E, 0x0F, 0x53, 0x3B, 0x3D, 0xE4, 0x29,
        0xEC, 0x92, 0x12, 0x06, 0xB8, 0x54, 0x2B, 0x57, 0x4F, 0x2E, 0x13, 0x48,
        0x73, 0xF1, 0x28, 0xFB, 0x34, 0x96, 0xCB, 0xE2, 0xA0, 0x20, 0x61, 0x8C,
        0xCA, 0xF6, 0x91, 0x1E, 0x63, 0x8F, 0xFC, 0x34, 0x10, 0x7A, 0x44, 0x16,
        0x07, 0xC1, 0x2A, 0xF7, 0x13, 0x3B, 0x84, 0x61, 0x95, 0x48, 0x0A, 0x97,
        0xEA, 0x37, 0x36, 0x64, 0xB1, 0x1D, 0x56, 0x93, 0x4A, 0xCA, 0x37, 0x15,
        0x36, 0x73, 0x1E, 0xD6, 0x21, 0x4B, 0x37, 0x50, 0x1F, 0x70, 0x81, 0x1E,
        0x38, 0x31, 0x48, 0xDB, 0xF1, 0x1E, 0xC9, 0x41, 0x33, 0x85, 0xA9, 0x2A,
        0x5E, 0xA9, 0x94, 0x88, 0x79, 0x25, 0x5A, 0x27, 0x3E, 0x00, 0x2A, 0x15,
        0x44, 0x45, 0x4F, 0xC9, 0xA2, 0x84, 0xF0, 0x84, 0x2F, 0x85, 0x29, 0x66,
        0x12, 0x51, 0x18, 0x24, 0x09, 0x37, 0x76, 0x2A, 0x4E, 0xFA, 0x13, 0x1E,
        0x56, 0x84, 0x7B, 0x9B, 0xD1, 0xA7, 0xEE, 0x15, 0x5F, 0x93, 0xF3, 0xA7,
        0x31, 0x40, 0x0F, 0xCB, 0xD0, 0x43, 0x38, 0x81, 0x91, 0x3C, 0x24, 0x9B,
        0x9D, 0x19, 0x61, 0x7F, 0x8C, 0xEA, 0x6A, 0x98, 0x34, 0x94, 0x07, 0xA1,
        0x1C, 0x2C, 0xA6, 0x98, 0xF6, 0x98, 0x50, 0x03, 0x11, 0x0D, 0xC3, 0x18,
        0x74, 0x96, 0x36, 0x66, 0x1F, 0x74, 0x7B, 0x09, 0xD9, 0x7C, 0x65, 0x85,
        0x10, 0x37, 0xB2, 0x30, 0x94, 0x3A, 0x3E, 0xD0, 0xC8, 0x78, 0x99, 0x8A,
        0xA8, 0xCD, 0xD9, 0x27, 0x09, 0x86, 0x90, 0xB1, 0x11, 0x71, 0x64, 0x22,
        0x8D, 0x3C, 0xE2, 0x38, 0xC8, 0xD7, 0x52, 0xC3, 0x23, 0x13, 0x9F, 0xE8,
        0x52, 0x96, 0xE1, 0x2F, 0x21, 0x9A, 0x46, 0xDC, 0x18, 0x06, 0x32, 0x20,
        0x55, 0x9A, 0xFA, 0x5A, 0x79, 0xF1, 0x3C, 0x1E, 0x65, 0xAB, 0xCC, 0x26,
        0xA0, 0x79, 0x64, 0x27, 0x79, 0x9A, 0x94, 0x04, 0x11, 0x30, 0x43, 0x3A,
        0x20, 0x1A, 0xE8, 0x43, 0x13, 0x97, 0x4C, 0x89, 0x8A, 0x98, 0x90, 0xCA,
        0x28, 0x33, 0xF2, 0x53, 0x32, 0x1A, 0x51, 0x95, 0x19, 0x98, 0x7D, 0xC2,
        0x72, 0x70, 0xA1, 0x1E, 0x0D, 0x28, 0x4F, 0xDD, 0x82, 0xA8, 0x6E, 0xAA,
        0x97, 0xFF, 0xA0, 0x6A, 0xAD, 0xEC, 0x93, 0x37, 0xF4, 0x13, 0x8F, 0x68,
        0x91, 0x29, 0x78, 0xF4, 0x12, 0x20, 0xF3, 0x73, 0xA6, 0xD7, 0x1B, 0xF2,
        0x5A, 0x6B, 0x6F, 0x50, 0x88, 0x67, 0x45, 0x8F, 0x47, 0xD2, 0x8C, 0x85,
        0x05, 0x44, 0xAB, 0x37, 0x25, 0x36, 0x4A, 0x11, 0xF1, 0xD7, 0xAE, 0xA3,
        0xFA, 0x43, 0xA1, 0x9A, 0x20, 0x5A, 0x63, 0xB0, 0xCD, 0x14, 0x35, 0xC5,
        0x91, 0x16, 0x10, 0x06, 0xAB, 0xEC, 0xDA, 0xAD, 0x92, 0x3A, 0x64, 0xF4,
        0xC9, 0x98, 0xE0, 0x2A, 0x23, 0xB8, 0xD8, 0x8C, 0x41, 0xC1, 0x84, 0x63,
        0x36, 0x4B, 0x14, 0x6B, 0x44, 0xED, 0x5A, 0x1E, 0x7C, 0xE2, 0xA5, 0x73,
        0x31, 0x24, 0x3F, 0xF3, 0x22, 0x4C, 0xD4, 0x99, 0x45, 0xF8, 0x99, 0xD4,
        0xE5, 0xB2, 0x82, 0x72, 0x18, 0x9F, 0x81, 0x6B, 0xB5, 0xD6, 0x3C, 0x3D,
        0x78, 0x35, 0x01, 0x73, 0x45, 0x6A, 0x46, 0xA6, 0x15, 0x2B, 0xA4, 0xF1,
        0x14, 0x3A, 0x74, 0xA8, 0x2B, 0x51, 0xB1, 0x37, 0x66, 0x91, 0x28, 0xFD,
        0x29, 0x90, 0x03, 0x81, 0x03, 0x1E, 0xF8, 0x1E, 0x29, 0x62, 0x3E, 0x20,
        0xC4, 0x7E, 0x34, 0xCA, 0x47, 0xB1, 0xE3, 0xB4, 0x33, 0xAA, 0x22, 0xE8,
        0x83, 0x34, 0x48, 0xE5, 0x14, 0xF5, 0x87, 0x20, 0xD5, 0x2A, 0x1B, 0xCB,
        0xB0, 0xA9, 0x04, 0xD1, 0x8F, 0x07, 0x8A, 0xB2, 0x7F, 0x82, 0xA3, 0x1B,
        0xB3, 0xB0, 0x06, 0xC1, 0x6C, 0xFA, 0x14, 0x4F, 0x59, 0x08, 0xA4, 0x70,
        0x9B, 0x33, 0x1C, 0xB7, 0x1E, 0x96, 0x91, 0x10, 0x88, 0x0A, 0x00, 0xC7,
        0x37, 0x1C, 0x4C, 0x9B, 0x49, 0xF8, 0xC5, 0x9B, 0x73, 0xAA, 0xB6, 0x05,
        0xD1, 0x30, 0x0C, 0x5B, 0xA4, 0xED, 0x8A, 0x10, 0x6D, 0x0B, 0x11, 0x41,
        0xAA, 0x1E, 0xFD, 0x98, 0x3A, 0xE3, 0xF3, 0x42, 0x46, 0x0A, 0x42, 0x7F,
        0x93, 0x18, 0x87, 0x66, 0x4E, 0x90, 0x4C, 0x84, 0x9F, 0xFF, 0x68, 0x4D,
        0x9F, 0xB8, 0x1A, 0x37, 0x19, 0x03, 0x94, 0xE6, 0x73, 0xAC, 0xA1, 0x18,
        0xEB, 0x81, 0x66, 0x7D, 0xAA, 0x1E, 0x7B, 0xFB, 0x37, 0x90, 0x91, 0x16,
        0x9B, 0xBB, 0x49, 0xA9, 0xE1, 0x92, 0xDA, 0x2A, 0x59, 0x27, 0x2B, 0x9B,
        0x07, 0x5A, 0x2E, 0x0A, 0x59, 0x10, 0x6B, 0x72, 0xA0, 0x7B, 0x2B, 0xA7,
        0x03, 0x41, 0xB6, 0x0E, 0xD8, 0x39, 0xCD, 0xC4, 0xB1, 0x92, 0x45, 0x50,
        0x6F, 0x0A, 0x15, 0x88, 0x04, 0x92, 0xD6, 0x73, 0xA0, 0xBA, 0xEB, 0x43,
        0x06, 0x11, 0xAC, 0x0D, 0x5B, 0xBC, 0xC2, 0x3B, 0x9D, 0x49, 0x91, 0x14,
        0x20, 0x63, 0x13, 0x46, 0x01, 0x75, 0x1A, 0xDA, 0x2C, 0x40, 0x51, 0x15,
        0xD7, 0xDB, 0x41, 0x31, 0x31, 0x7F, 0x98, 0x10, 0x13, 0x47, 0x38, 0x09,
        0xD9, 0x2B, 0x3B, 0xE2, 0x3B, 0xBE, 0xE4, 0x5B, 0xBE, 0xE6, 0x7B, 0xBE,
        0xE8, 0x9B, 0xBE, 0xEA, 0xBB, 0xBE, 0xEC, 0xDB, 0xBE, 0xEE, 0xFB, 0xBE,
        0xF0, 0x1B, 0xBF, 0xE3, 0x1B, 0x10, 0x00, 0x3B
};

const char Html_png1[] = { 0x89, 0x50, 0x4E, 0x47, 0x0D, 0x0A, 0x1A, 0x0A, 0x00,
        0x00, 0x00, 0x0D, 0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x64, 0x00,
        0x00, 0x00, 0x64, 0x08, 0x06, 0x00, 0x00, 0x00, 0x70, 0xE2, 0x95, 0x54,
        0x00, 0x00, 0x00, 0x01, 0x73, 0x52, 0x47, 0x42, 0x00, 0xAE, 0xCE, 0x1C,
        0xE9, 0x00, 0x00, 0x00, 0x04, 0x67, 0x41, 0x4D, 0x41, 0x00, 0x00, 0xB1,
        0x8F, 0x0B, 0xFC, 0x61, 0x05, 0x00, 0x00, 0x00, 0x09, 0x70, 0x48, 0x59,
        0x73, 0x00, 0x00, 0x0E, 0xC3, 0x00, 0x00, 0x0E, 0xC3, 0x01, 0xC7, 0x6F,
        0xA8, 0x64, 0x00, 0x00, 0x0C, 0x38, 0x49, 0x44, 0x41, 0x54, 0x78, 0x5E,
        0xED, 0x5D, 0x6B, 0xAC, 0x1D, 0x55, 0x15, 0xBE, 0xAD, 0x28, 0xD1, 0xA2,
        0x02, 0x8A, 0xA5, 0x5A, 0xB9, 0xF4, 0x9E, 0xFD, 0x9A, 0x69, 0x7B, 0xA1,
        0x3D, 0x33, 0x7B, 0xE6, 0x96, 0xE2, 0x05, 0x6A, 0x55, 0x7C, 0x44, 0x51,
        0x40, 0x05, 0x7C, 0xFD, 0x10, 0x01, 0xA3, 0x01, 0x05, 0x23, 0x41, 0x82,
        0x60, 0x40, 0xA2, 0xA2, 0x60, 0x13, 0x7C, 0xC4, 0x07, 0x89, 0x12, 0x11,
        0x11, 0x90, 0x6A, 0x34, 0x36, 0x90, 0xB6, 0x28, 0x81, 0x60, 0x34, 0x1A,
        0x8C, 0x02, 0xA9, 0x80, 0x28, 0x89, 0xB5, 0x58, 0xB0, 0xC5, 0x1A, 0xA1,
        0xAD, 0xEB, 0x9B, 0xBD, 0xA6, 0xF7, 0x72, 0x98, 0xFB, 0x38, 0xE7, 0xEC,
        0x99, 0x39, 0xE5, 0xCE, 0x97, 0x7C, 0x39, 0xF7, 0x9E, 0x33, 0x7B, 0xAD,
        0xB5, 0xD7, 0xDA, 0x6B, 0xBF, 0xE6, 0x35, 0xB4, 0x3F, 0xC2, 0x98, 0xE4,
        0x72, 0xAD, 0xD3, 0x3F, 0x2A, 0x19, 0x3D, 0x20, 0x85, 0xBD, 0xBF, 0x93,
        0x4A, 0xC5, 0x0F, 0x6A, 0x95, 0xDE, 0x17, 0xE8, 0xF4, 0x32, 0x2E, 0xD2,
        0xA0, 0x0C, 0x08, 0x61, 0x17, 0x1B, 0x6D, 0xEF, 0x31, 0x3A, 0xDD, 0xAB,
        0x55, 0x42, 0xB4, 0xD3, 0x30, 0xD9, 0x4B, 0x01, 0xD9, 0x6B, 0xA4, 0xFD,
        0x75, 0x18, 0xC6, 0x87, 0xB3, 0x88, 0x06, 0x1E, 0x31, 0x4F, 0xC9, 0xF8,
        0x97, 0x4B, 0xC3, 0xD5, 0x05, 0xCE, 0x9F, 0x9A, 0x38, 0x5E, 0x29, 0xBB,
        0x9E, 0x65, 0x34, 0xF0, 0x05, 0xA5, 0xDA, 0xC6, 0x68, 0x64, 0xC5, 0x4C,
        0x99, 0xF1, 0x6C, 0x9A, 0xEC, 0xF8, 0x64, 0xAF, 0x10, 0xAB, 0x5A, 0x2C,
        0xAA, 0x81, 0x0F, 0xE8, 0xD6, 0xCA, 0xE3, 0x03, 0x83, 0xAE, 0xAA, 0xD8,
        0xF1, 0xD3, 0x11, 0x81, 0x6C, 0xB5, 0xE2, 0x31, 0x16, 0xD5, 0xC0, 0x07,
        0x74, 0xAB, 0x7D, 0x5C, 0x3F, 0x01, 0x91, 0x32, 0x49, 0x58, 0x54, 0x03,
        0x1F, 0x68, 0x02, 0x32, 0x60, 0x68, 0x02, 0x32, 0x60, 0x08, 0x64, 0xFC,
        0xBA, 0x7E, 0x02, 0xA2, 0xD4, 0x58, 0xCC, 0xA2, 0x1A, 0xF8, 0x80, 0x6E,
        0xC5, 0x6F, 0x0C, 0xCC, 0x58, 0xA1, 0xC3, 0x67, 0x22, 0x02, 0x49, 0x53,
        0xDF, 0x13, 0x58, 0x54, 0x03, 0x1F, 0xA0, 0xD5, 0xF7, 0xE5, 0x61, 0xB0,
        0xAA, 0xD0, 0xE1, 0x33, 0x11, 0xE5, 0x28, 0x20, 0x97, 0xB0, 0xA8, 0xB9,
        0x01, 0x5A, 0x45, 0x87, 0x5A, 0xA7, 0x57, 0x29, 0x95, 0xAC, 0x37, 0x2A,
        0xBD, 0x46, 0x88, 0x68, 0x05, 0xFF, 0xD4, 0x37, 0xC2, 0x30, 0x3D, 0x54,
        0xAB, 0xF8, 0x1F, 0x6E, 0x85, 0x5E, 0xEC, 0xF4, 0xE9, 0x88, 0x72, 0x4A,
        0x26, 0x8F, 0x0D, 0x0F, 0x1F, 0x75, 0x30, 0x8B, 0xEC, 0x1B, 0x4A, 0x45,
        0x31, 0xD5, 0x75, 0x1D, 0xD7, 0xF7, 0x4B, 0x58, 0x27, 0xF1, 0x4F, 0xF5,
        0x43, 0xCA, 0xE8, 0x9D, 0x46, 0xDB, 0xFF, 0x2C, 0x0D, 0x8F, 0xC9, 0x5A,
        0xE3, 0xD2, 0xE0, 0x18, 0x38, 0xE2, 0x69, 0x29, 0xED, 0xFB, 0xF9, 0x90,
        0x9E, 0xD1, 0x6E, 0xB7, 0x5F, 0x48, 0xB2, 0x7F, 0xDE, 0x6B, 0x76, 0xE4,
        0x74, 0xE5, 0x93, 0x9F, 0x0E, 0x0D, 0x8D, 0x1F, 0xC0, 0xA2, 0x7B, 0x86,
        0x91, 0xD1, 0x99, 0x14, 0xE4, 0xDD, 0xFB, 0xEA, 0x4B, 0x9F, 0x5A, 0xA5,
        0x3B, 0xA5, 0x8C, 0x4F, 0xE2, 0x43, 0xEA, 0x83, 0x16, 0xD1, 0xBB, 0x60,
        0x5C, 0xE7, 0x80, 0x8B, 0x56, 0x99, 0xF5, 0xF9, 0x32, 0xFE, 0x20, 0x1F,
        0xDA, 0x35, 0x02, 0x35, 0xB6, 0x86, 0x5A, 0xE0, 0x5D, 0xFD, 0x06, 0x23,
        0x27, 0xE4, 0x50, 0x70, 0x7F, 0xA5, 0xB5, 0x3D, 0x9E, 0x55, 0x74, 0x0D,
        0xEA, 0x3A, 0xCF, 0x0E, 0x82, 0xB1, 0x6C, 0xA2, 0x30, 0x59, 0x36, 0xEA,
        0x0F, 0x3F, 0xC0, 0x1F, 0x7C, 0x68, 0xF5, 0xD0, 0xC2, 0x9E, 0x0C, 0x23,
        0xE0, 0xFC, 0xC9, 0xC6, 0xE5, 0xCC, 0x83, 0x42, 0x19, 0x74, 0x26, 0x17,
        0x99, 0x11, 0x23, 0x23, 0x63, 0xAF, 0x32, 0xCA, 0x7E, 0xD4, 0xC8, 0xE4,
        0x5E, 0x94, 0xED, 0x75, 0x20, 0x9F, 0x8A, 0xFB, 0x64, 0x6A, 0x7B, 0x0F,
        0x75, 0xB1, 0x67, 0x51, 0x57, 0xF3, 0x4A, 0x56, 0x3D, 0x23, 0xA8, 0x9B,
        0x3A, 0x27, 0x2C, 0x08, 0x46, 0x4E, 0xD4, 0xD7, 0x05, 0xC5, 0x9E, 0xCC,
        0x45, 0xAA, 0x03, 0x29, 0x3D, 0x85, 0x94, 0xEF, 0x99, 0x2A, 0x18, 0x39,
        0x61, 0x7C, 0x08, 0x07, 0xC8, 0xF8, 0x63, 0x5C, 0xB4, 0x10, 0x41, 0x90,
        0x24, 0xE4, 0xA0, 0x6B, 0xA9, 0xAF, 0xDF, 0x86, 0x96, 0xEC, 0x3B, 0x10,
        0x9D, 0x84, 0xFC, 0x2C, 0xF3, 0xB4, 0xDD, 0x8A, 0xB1, 0x40, 0xEB, 0x38,
        0x62, 0x53, 0x0A, 0x41, 0xBF, 0x7F, 0x1C, 0xF5, 0x98, 0x2A, 0x18, 0x39,
        0x39, 0x28, 0x7B, 0xE0, 0x1F, 0x2E, 0x5A, 0x3E, 0xA0, 0x2C, 0x98, 0x45,
        0x30, 0x72, 0xA2, 0x12, 0x70, 0x00, 0x55, 0xFC, 0x3A, 0x0C, 0x86, 0xA3,
        0xA3, 0xA3, 0x0B, 0x86, 0x86, 0x2E, 0x99, 0xBF, 0x64, 0x49, 0xB2, 0xD0,
        0xC8, 0xF8, 0x03, 0x34, 0x03, 0xDA, 0x08, 0x59, 0xAE, 0x4B, 0xE9, 0x6E,
        0xF3, 0xB0, 0x5F, 0x4E, 0xD6, 0x4B, 0xBC, 0x9D, 0xEC, 0x3B, 0x03, 0x59,
        0x4A, 0xD5, 0x9C, 0x0F, 0x3B, 0x8D, 0xB0, 0x29, 0x05, 0xED, 0x7B, 0xB0,
        0x7F, 0xB6, 0xB6, 0x41, 0x26, 0xFC, 0x53, 0x49, 0x50, 0xBA, 0x0D, 0xC6,
        0x64, 0x4E, 0x38, 0x3C, 0xFA, 0x1B, 0x75, 0x63, 0x0F, 0xD0, 0x77, 0x4F,
        0x84, 0xA6, 0xFC, 0x6C, 0x98, 0x1D, 0x5D, 0xA3, 0x61, 0x5B, 0xB6, 0xC3,
        0x3E, 0x29, 0xE2, 0xBF, 0xC3, 0xDE, 0x2C, 0x93, 0x0A, 0xCB, 0x4C, 0xCD,
        0x89, 0xA0, 0x94, 0x38, 0xA6, 0xD0, 0xAC, 0xE9, 0x28, 0x52, 0xF6, 0x74,
        0x2F, 0xC1, 0x98, 0x20, 0x5A, 0x22, 0xC6, 0x16, 0xA4, 0x76, 0xB5, 0xD9,
        0x30, 0x5B, 0xC2, 0x2E, 0x1E, 0xA4, 0x0B, 0x7F, 0x9F, 0x2D, 0x51, 0x9E,
        0xBA, 0xE0, 0xFF, 0x99, 0x91, 0x68, 0x19, 0xBB, 0xD0, 0x2F, 0xB4, 0x8C,
        0xBE, 0xE5, 0xA6, 0x78, 0xC5, 0x06, 0x34, 0x7C, 0x2E, 0xE1, 0x2F, 0x9A,
        0x99, 0x7D, 0x83, 0x5D, 0xE8, 0x17, 0x5A, 0xC4, 0x77, 0x0E, 0x46, 0xF7,
        0xB2, 0xFF, 0x10, 0xFE, 0xA2, 0x31, 0x72, 0x13, 0xBB, 0xD0, 0x2F, 0x28,
        0xD2, 0x3F, 0x08, 0xDD, 0xA2, 0xAF, 0xE1, 0x2C, 0x89, 0x0C, 0xA1, 0xAE,
        0xFE, 0xFB, 0xEC, 0x42, 0xBF, 0x70, 0x3B, 0xAE, 0xB3, 0x9F, 0x6D, 0xCC,
        0x75, 0xBA, 0xB1, 0x28, 0x9B, 0x5D, 0xAE, 0x66, 0x17, 0xFA, 0x07, 0xA5,
        0xDF, 0x79, 0x75, 0x4C, 0x4F, 0xF7, 0x37, 0xC2, 0x3F, 0xF0, 0x93, 0x12,
        0xD1, 0xB9, 0xEC, 0xBA, 0xF2, 0x40, 0x5D, 0xD7, 0x27, 0x9A, 0xA0, 0x4C,
        0xCD, 0x7D, 0xC1, 0x20, 0x3F, 0xB1, 0xCB, 0xCA, 0x47, 0x93, 0x29, 0xC5,
        0x9C, 0x08, 0x86, 0x3D, 0x8F, 0x5D, 0x55, 0x1D, 0x68, 0xF1, 0x74, 0x61,
        0xB6, 0x2D, 0x52, 0x60, 0xD8, 0x5C, 0x65, 0x36, 0x0B, 0x95, 0xF1, 0x27,
        0xD9, 0x45, 0xD5, 0x83, 0x94, 0xDF, 0x8A, 0x16, 0x51, 0x64, 0xDC, 0x5C,
        0x23, 0x77, 0x53, 0x37, 0xB1, 0x6B, 0xEA, 0x81, 0x52, 0xED, 0x63, 0x3A,
        0xB7, 0xDE, 0xE7, 0x2A, 0xB1, 0x32, 0xAF, 0xFD, 0x62, 0x0A, 0xAD, 0x57,
        0xBD, 0x54, 0x0A, 0xBB, 0xAD, 0xDF, 0x6D, 0x86, 0xFD, 0x9D, 0xAE, 0xFE,
        0xF1, 0xD6, 0xD1, 0xD1, 0xB5, 0x0B, 0xD8, 0x35, 0xF5, 0x00, 0x67, 0xF4,
        0xA4, 0x8C, 0x1F, 0xAE, 0x32, 0x20, 0xD0, 0x85, 0xEE, 0x21, 0x27, 0xFA,
        0xED, 0x9C, 0x93, 0xBF, 0xAF, 0xDA, 0x26, 0x21, 0xA2, 0xBF, 0x8C, 0x8F,
        0xF7, 0x7F, 0x46, 0xB2, 0x2F, 0x84, 0xC3, 0xF1, 0xE1, 0x34, 0xA3, 0x78,
        0xAA, 0xEC, 0xD9, 0x56, 0x1E, 0x04, 0x76, 0xF2, 0x16, 0xAD, 0xED, 0x8D,
        0x46, 0xD9, 0x4B, 0xDC, 0xF6, 0x7D, 0x74, 0xA2, 0x11, 0xC9, 0xDA, 0xEC,
        0x93, 0xFE, 0xC7, 0xF7, 0xD4, 0x48, 0x7E, 0x84, 0xE3, 0x3A, 0xCA, 0x95,
        0x46, 0xD4, 0x5F, 0x8A, 0x78, 0x07, 0x6F, 0xDD, 0xD7, 0x07, 0xAA, 0xF8,
        0x87, 0x51, 0xE1, 0x22, 0x23, 0x7D, 0x30, 0x9F, 0x46, 0x66, 0x17, 0x39,
        0x28, 0xFB, 0x55, 0xAC, 0x7A, 0x85, 0x78, 0xD3, 0x81, 0xAC, 0x7E, 0x5A,
        0xE0, 0xB8, 0x40, 0xDA, 0x63, 0x51, 0x0E, 0xE5, 0x5D, 0x60, 0xCA, 0x6B,
        0x38, 0x99, 0x9D, 0x22, 0xF9, 0x10, 0xAB, 0xAF, 0x07, 0x94, 0x1D, 0xBF,
        0xCB, 0xA6, 0x7A, 0x05, 0x06, 0xF6, 0xCB, 0xAC, 0x82, 0x3A, 0xD9, 0x6E,
        0x54, 0x72, 0x71, 0x37, 0xA7, 0x5A, 0x8B, 0x20, 0xC4, 0xD1, 0x87, 0x41,
        0x0E, 0x05, 0xE4, 0x89, 0xB2, 0x1A, 0x10, 0xFC, 0x40, 0xE3, 0xE9, 0xBD,
        0xAC, 0xB2, 0x7A, 0x28, 0x95, 0x96, 0x32, 0xC3, 0xCA, 0xB3, 0x82, 0x3E,
        0x6F, 0xA5, 0x80, 0x2F, 0x61, 0x75, 0x5E, 0x40, 0x6B, 0xA7, 0x11, 0xC8,
        0x2D, 0x2B, 0x5B, 0xE0, 0x8F, 0xA0, 0xAE, 0x99, 0x96, 0x92, 0xF6, 0x7A,
        0xDF, 0xAD, 0x0D, 0x7D, 0x7D, 0x16, 0x64, 0x6D, 0x2F, 0x60, 0x35, 0xA5,
        0x80, 0x02, 0xFD, 0x29, 0xB4, 0x68, 0xDF, 0x63, 0x0B, 0xFC, 0x41, 0xB2,
        0xAF, 0x63, 0x35, 0xD5, 0xC1, 0x98, 0x95, 0x8B, 0x7C, 0x0F, 0xE6, 0x70,
        0x0E, 0xC9, 0xDB, 0x4D, 0x83, 0xF3, 0xBB, 0x59, 0x4D, 0xA9, 0x80, 0x1E,
        0xE8, 0xF3, 0x19, 0x14, 0xF8, 0x43, 0xC9, 0x1A, 0x06, 0x77, 0xB4, 0x30,
        0x9F, 0xE7, 0x46, 0x50, 0x11, 0xB4, 0x58, 0x5A, 0xE9, 0x9E, 0xCA, 0x2A,
        0x2A, 0x01, 0xF4, 0xB9, 0x4C, 0xF1, 0xD7, 0xB0, 0xE0, 0x97, 0x4A, 0x37,
        0x16, 0x87, 0x86, 0x4E, 0x79, 0x01, 0xB5, 0x82, 0x07, 0x7D, 0x8E, 0x1F,
        0x59, 0xD7, 0x27, 0xA3, 0xF3, 0x59, 0x41, 0xA5, 0x20, 0xBD, 0x17, 0xF8,
        0xEC, 0x7A, 0xB3, 0x49, 0x8E, 0x88, 0xFF, 0x44, 0xA2, 0xE7, 0x3B, 0x0D,
        0x25, 0xC3, 0x48, 0xFB, 0x16, 0x9F, 0x15, 0xC8, 0xFA, 0x5D, 0x69, 0x6F,
        0x63, 0xF1, 0xB5, 0x80, 0xF4, 0xAF, 0xF7, 0x1D, 0x14, 0x23, 0xEC, 0x1B,
        0x58, 0x7C, 0x79, 0x58, 0xB8, 0x70, 0x74, 0x01, 0xAD, 0x05, 0xEE, 0xCB,
        0x5A, 0x41, 0x81, 0x21, 0xDD, 0x12, 0x5D, 0x05, 0xF1, 0x49, 0xAD, 0x57,
        0xBD, 0x9A, 0x55, 0xD4, 0x02, 0xE8, 0xA7, 0x45, 0xE5, 0xBF, 0x7D, 0x75,
        0x5D, 0x59, 0x40, 0x64, 0xFC, 0x87, 0xC5, 0x8B, 0xD3, 0x17, 0xB3, 0x0A,
        0xFF, 0x08, 0x82, 0xB1, 0x61, 0xAD, 0x92, 0x4D, 0x81, 0xF1, 0x99, 0x1D,
        0x38, 0xE7, 0x1C, 0x5F, 0xC4, 0x2A, 0x6A, 0x85, 0x26, 0x3B, 0x7C, 0x8E,
        0x8B, 0xC8, 0x38, 0x23, 0x93, 0x3B, 0xC2, 0xB0, 0x7D, 0x04, 0xAB, 0xE8,
        0x0E, 0xC6, 0x8C, 0x2D, 0xA3, 0xC1, 0xFA, 0x04, 0x9A, 0xAB, 0xBF, 0x3E,
        0x27, 0x0D, 0x4E, 0x6B, 0xE8, 0xBB, 0xB7, 0x93, 0xB1, 0x5F, 0xA6, 0x71,
        0xE3, 0x71, 0x9F, 0x69, 0x9D, 0xCD, 0x6E, 0x84, 0xFD, 0xA7, 0x10, 0xF6,
        0x65, 0x6C, 0x42, 0xAD, 0x18, 0x19, 0x69, 0xBF, 0x1C, 0xF6, 0xF8, 0x9C,
        0x75, 0xB9, 0xEE, 0x38, 0x7E, 0x9C, 0xE4, 0x5E, 0x05, 0x3F, 0xC2, 0x9F,
        0xB9, 0x6F, 0x85, 0x68, 0xAF, 0x85, 0xBF, 0x83, 0x20, 0x5E, 0xCA, 0x26,
        0x38, 0x18, 0x13, 0x2B, 0xFA, 0x61, 0x63, 0x3E, 0xD3, 0x71, 0x74, 0xEB,
        0x01, 0x47, 0xB7, 0x69, 0xE7, 0x73, 0x26, 0x02, 0x42, 0x26, 0x65, 0xC7,
        0xD5, 0x6C, 0xC6, 0x40, 0x40, 0xB5, 0xA2, 0x6B, 0x7C, 0x36, 0x3A, 0x10,
        0x7E, 0x83, 0xCC, 0x22, 0xBF, 0x82, 0xF8, 0xDD, 0xC8, 0xF4, 0x8E, 0xB0,
        0xB5, 0x42, 0x0C, 0x1D, 0xB1, 0x7C, 0xF5, 0x21, 0x54, 0x68, 0x8B, 0xBB,
        0x00, 0xCE, 0xFF, 0xCA, 0x75, 0x3A, 0xA2, 0x25, 0x4A, 0xD9, 0xB6, 0xEC,
        0x8B, 0x81, 0x80, 0x94, 0xA9, 0xF5, 0x99, 0x21, 0xB3, 0x63, 0xE2, 0xEE,
        0x31, 0x11, 0xD1, 0xEF, 0xA9, 0xDF, 0xB4, 0x37, 0x22, 0x5A, 0xC5, 0x07,
        0x96, 0xC7, 0x2C, 0x18, 0x22, 0x7A, 0xA8, 0xF6, 0xED, 0xEA, 0x0E, 0xC0,
        0x1E, 0xD8, 0x55, 0x7D, 0x50, 0x5C, 0x26, 0x0D, 0x55, 0x9D, 0x15, 0x39,
        0xB3, 0x6E, 0x41, 0xDA, 0x1F, 0xB2, 0x1F, 0x06, 0x0A, 0x68, 0xA4, 0xBE,
        0xBB, 0xAD, 0xD9, 0x92, 0x02, 0x52, 0xFC, 0x43, 0xD9, 0x74, 0x01, 0x19,
        0x8C, 0xD9, 0x55, 0x27, 0xC8, 0xAE, 0xCF, 0xCC, 0xCD, 0x80, 0x88, 0xF8,
        0x34, 0xF6, 0xC1, 0x40, 0x81, 0xEC, 0x3A, 0x7D, 0xCE, 0x05, 0x24, 0x9B,
        0x61, 0xC8, 0xE4, 0xCD, 0xEC, 0x83, 0x81, 0x02, 0xEC, 0x82, 0x7D, 0x45,
        0x76, 0x97, 0xCD, 0x1A, 0x03, 0x82, 0x9B, 0xF9, 0xE3, 0x35, 0xEC, 0x83,
        0x81, 0x02, 0x4E, 0x07, 0xD7, 0x31, 0xD1, 0x01, 0x6B, 0xCD, 0x10, 0xEC,
        0x89, 0xB1, 0x0F, 0x06, 0x0A, 0x46, 0xC4, 0x6F, 0x9D, 0x73, 0x19, 0x82,
        0x3E, 0x9A, 0x16, 0xA3, 0xEF, 0x63, 0x1F, 0x0C, 0x14, 0x60, 0xD7, 0x9C,
        0x1C, 0xD4, 0xA9, 0xE2, 0x03, 0xF9, 0xB8, 0x0B, 0xD8, 0x35, 0x27, 0x03,
        0x42, 0x9F, 0x37, 0xB3, 0x0F, 0x06, 0x0A, 0xB4, 0x62, 0xBE, 0xA5, 0xB6,
        0x80, 0x48, 0x19, 0x7F, 0xBB, 0xAE, 0x95, 0xBA, 0x56, 0xD1, 0xA3, 0x61,
        0x18, 0xBE, 0x88, 0xFD, 0x30, 0x10, 0x10, 0x42, 0x1C, 0x88, 0xBB, 0x84,
        0x6B, 0x5B, 0xA9, 0x2F, 0x1C, 0x1D, 0x5D, 0x80, 0x3D, 0x14, 0x3C, 0xBD,
        0x73, 0x62, 0xF3, 0x10, 0x9F, 0x93, 0xF9, 0xDC, 0xC2, 0x3E, 0x88, 0x86,
        0x20, 0xA5, 0x3D, 0x96, 0x7D, 0x31, 0x10, 0x80, 0x3D, 0xE5, 0x36, 0xD0,
        0xE7, 0xFA, 0x16, 0x7E, 0xE7, 0xA7, 0xA7, 0xDE, 0xC5, 0x46, 0xA4, 0xAF,
        0xD1, 0x3A, 0xB9, 0x99, 0x0E, 0xC8, 0x2E, 0x5A, 0xE8, 0x24, 0x9E, 0x7F,
        0x8B, 0x14, 0xF6, 0xDD, 0x6A, 0xDC, 0x38, 0x52, 0xD2, 0x1D, 0xAA, 0x3D,
        0x42, 0xA9, 0xF6, 0x37, 0x7D, 0x77, 0x57, 0xF0, 0x1B, 0x64, 0xC2, 0x8F,
        0x45, 0xFE, 0x85, 0xDF, 0x95, 0x4A, 0x7F, 0x8C, 0x0B, 0x47, 0xD8, 0x0C,
        0x87, 0x56, 0x2B, 0x7A, 0x6D, 0x10, 0x8C, 0xAD, 0x30, 0xAD, 0x74, 0x65,
        0xCE, 0x40, 0x44, 0x2B, 0x8C, 0x88, 0xC6, 0x95, 0x4A, 0x2E, 0xA6, 0x82,
        0x8F, 0xFA, 0x34, 0xD6, 0x19, 0x13, 0x3D, 0xD9, 0xEF, 0x45, 0x70, 0xBE,
        0x00, 0x3B, 0x60, 0x8F, 0xB3, 0xAB, 0xD8, 0xE6, 0x6E, 0xE9, 0xFC, 0x95,
        0xFC, 0x15, 0xDB, 0x44, 0xF0, 0x63, 0x20, 0xC6, 0x56, 0x80, 0xFB, 0xFC,
        0x4B, 0xFE, 0x86, 0xDF, 0xD9, 0x84, 0xEE, 0x00, 0x83, 0x8D, 0xB2, 0xB7,
        0xF9, 0x0C, 0x4A, 0x26, 0x4B, 0xDA, 0x2B, 0x59, 0x45, 0xAD, 0x80, 0x1D,
        0xDE, 0xEB, 0xA6, 0x93, 0x5B, 0x8C, 0x89, 0x5F, 0xC1, 0x2A, 0xCA, 0xC0,
        0xF8, 0x01, 0x46, 0x26, 0xBF, 0xF1, 0xB5, 0x70, 0x72, 0x69, 0x6B, 0x77,
        0x65, 0x27, 0x67, 0x6A, 0x04, 0xF4, 0xC3, 0x0E, 0x5F, 0xD9, 0xE1, 0xFC,
        0x13, 0xDF, 0x4D, 0xA2, 0xCB, 0xBF, 0xF2, 0x04, 0xA7, 0x1F, 0x7D, 0xAE,
        0x64, 0xD1, 0x92, 0x68, 0x40, 0xDB, 0xC8, 0xE2, 0x6B, 0x01, 0xD9, 0xB1,
        0xC9, 0x67, 0x76, 0xC0, 0x3F, 0x55, 0x4E, 0x58, 0xE6, 0xE3, 0xBA, 0x23,
        0xBF, 0x41, 0xC9, 0x2E, 0x2E, 0xBB, 0x82, 0xE5, 0x57, 0x0A, 0x2D, 0xA3,
        0xCF, 0xFB, 0xBC, 0xB8, 0x01, 0x7E, 0x11, 0x38, 0xFB, 0x57, 0x25, 0xA8,
        0x45, 0x9F, 0xEB, 0xB3, 0x45, 0x61, 0x0A, 0x98, 0xC9, 0x93, 0xF6, 0x23,
        0xAC, 0xA2, 0x12, 0x50, 0xC3, 0x3A, 0xCB, 0xD5, 0xC3, 0xEF, 0x40, 0x4E,
        0x8D, 0xEB, 0x6C, 0x56, 0x51, 0x0D, 0x70, 0x79, 0xBF, 0x14, 0xFE, 0xAE,
        0x63, 0x02, 0x21, 0x0B, 0xAD, 0x8B, 0x66, 0x74, 0xE7, 0xB0, 0x9A, 0x52,
        0x01, 0x3D, 0xD0, 0xE7, 0xBB, 0x0E, 0xF4, 0xB9, 0x7D, 0xF9, 0xF2, 0xD5,
        0x87, 0xB0, 0x9A, 0xEA, 0xA0, 0x64, 0xFC, 0x1D, 0xBF, 0x59, 0xE2, 0x2A,
        0xE4, 0x5A, 0x58, 0xF2, 0x05, 0x52, 0x31, 0xCF, 0x69, 0xF2, 0x8E, 0x79,
        0x24, 0xFF, 0x8B, 0xD0, 0xE3, 0x33, 0x18, 0xA0, 0xB3, 0xDD, 0x7E, 0x8D,
        0xF5, 0x54, 0x0B, 0x3C, 0x16, 0x0F, 0x8B, 0x9D, 0x22, 0xC3, 0xFA, 0x23,
        0x82, 0x42, 0x7D, 0xBA, 0x4E, 0x36, 0x1B, 0x93, 0xB4, 0x59, 0x9D, 0x17,
        0x40, 0x9E, 0xD6, 0xE9, 0x66, 0x37, 0x66, 0xF8, 0x0D, 0x06, 0x88, 0x45,
        0xA0, 0x94, 0xF1, 0xD1, 0xAC, 0xAE, 0x7A, 0x50, 0x5F, 0x79, 0xB7, 0xCF,
        0xC1, 0x7D, 0x32, 0xB3, 0xD6, 0x26, 0xED, 0xD3, 0xD4, 0x9A, 0xD7, 0x05,
        0x41, 0x22, 0x59, 0x65, 0x4F, 0x40, 0x79, 0xC8, 0x81, 0x3C, 0xDF, 0x59,
        0x9D, 0x33, 0xF3, 0x83, 0x88, 0xEF, 0x64, 0x95, 0xF5, 0x80, 0xD2, 0xB3,
        0xD4, 0x73, 0x07, 0x79, 0x17, 0x46, 0x73, 0xFA, 0x5D, 0x5A, 0xD8, 0x1B,
        0x8C, 0x4C, 0x4F, 0x12, 0x62, 0xF5, 0x61, 0xAC, 0x7E, 0x5A, 0xE0, 0x38,
        0x1C, 0x8F, 0x72, 0x28, 0x0F, 0x39, 0xBE, 0xBB, 0xA8, 0xC9, 0xCC, 0xE4,
        0x4B, 0xFB, 0x5E, 0x56, 0x5F, 0x0F, 0x70, 0x63, 0x0A, 0xB5, 0xBA, 0x9D,
        0x65, 0x56, 0x14, 0xCC, 0x03, 0x93, 0x0D, 0xFA, 0x32, 0xFE, 0x17, 0x7D,
        0xB7, 0x49, 0x6B, 0x7B, 0x2D, 0xCD, 0xCA, 0xCE, 0xC7, 0x8D, 0x96, 0x70,
        0x04, 0x3E, 0xB3, 0xFF, 0xF1, 0xBD, 0x8A, 0x36, 0xE3, 0x38, 0x1C, 0x5F,
        0x76, 0x20, 0x40, 0x27, 0x3F, 0x7A, 0xB2, 0xE4, 0x55, 0xF9, 0xCC, 0xC0,
        0xF6, 0x39, 0x65, 0xC9, 0x23, 0x55, 0x6E, 0x57, 0xA3, 0xF2, 0xB9, 0xA3,
        0xF7, 0xD1, 0x4C, 0xFA, 0x9B, 0x88, 0xDF, 0xCB, 0x0E, 0xC2, 0x64, 0xA2,
        0xFE, 0xE4, 0x87, 0x2D, 0xB8, 0x77, 0x86, 0x5D, 0x53, 0x0F, 0x86, 0x87,
        0xC7, 0x0F, 0xA6, 0x71, 0x64, 0x7B, 0x95, 0x95, 0x1F, 0x44, 0x66, 0x83,
        0xB9, 0xB0, 0xDB, 0xF0, 0x64, 0x0B, 0x76, 0x4D, 0x3D, 0xA0, 0x56, 0x71,
        0x42, 0x36, 0x98, 0x15, 0x18, 0x39, 0xD7, 0x38, 0x10, 0xE7, 0x77, 0xC8,
        0x90, 0x0D, 0x4D, 0x40, 0x1C, 0x9D, 0x1F, 0xE2, 0x9F, 0xB1, 0x6B, 0xAA,
        0x07, 0x75, 0x55, 0x3D, 0xBF, 0xD3, 0xE3, 0xF9, 0x4A, 0xF8, 0x83, 0x7A,
        0x8D, 0xCF, 0xB1, 0x8B, 0xAA, 0x83, 0x96, 0xF1, 0xA5, 0x4D, 0x30, 0x8A,
        0x99, 0x2D, 0x3A, 0xC9, 0x3F, 0xEC, 0xAA, 0xF2, 0x41, 0x53, 0xCB, 0xCB,
        0xCA, 0x5A, 0xE9, 0x3E, 0x3F, 0xC8, 0x3B, 0x0D, 0xE4, 0x27, 0x76, 0x59,
        0x79, 0x70, 0x99, 0xD1, 0x04, 0x63, 0x66, 0xBA, 0xA0, 0x50, 0xF7, 0x55,
        0xDE, 0xB5, 0x67, 0x4A, 0x25, 0x27, 0xBA, 0x6E, 0xAA, 0x09, 0xC6, 0x6C,
        0x88, 0xA5, 0x00, 0xD6, 0x47, 0x38, 0xA1, 0xC7, 0x2E, 0xF4, 0x0B, 0x1A,
        0xC4, 0x6F, 0x6A, 0xC6, 0x8D, 0xEE, 0x98, 0xF9, 0xAB, 0xAC, 0x1B, 0x93,
        0xB0, 0x71, 0xD6, 0x4C, 0x71, 0xBB, 0x23, 0xFC, 0x45, 0xDD, 0x56, 0x39,
        0xA7, 0xA7, 0x55, 0x2B, 0xFE, 0x7A, 0xF3, 0x76, 0x84, 0xEE, 0xC8, 0x6F,
        0x47, 0x58, 0xC7, 0x2E, 0xF4, 0x0B, 0xAD, 0x23, 0x4D, 0xE3, 0xC8, 0x53,
        0xFD, 0x5C, 0xD9, 0xE7, 0xF6, 0xA1, 0xDC, 0x2D, 0xC1, 0x55, 0xEE, 0x7F,
        0x75, 0x43, 0xD8, 0x05, 0xFB, 0x60, 0x67, 0x3F, 0x5B, 0x42, 0x28, 0xAF,
        0xA4, 0xDD, 0x11, 0xB6, 0xD2, 0xF2, 0xAE, 0xA8, 0xC9, 0xDE, 0xB8, 0xA9,
        0xED, 0x7F, 0xBB, 0x0F, 0x4A, 0xBE, 0x8D, 0x1E, 0x3D, 0x23, 0x85, 0xFD,
        0x33, 0xA5, 0xF1, 0x6F, 0xE9, 0xF3, 0x31, 0x54, 0x1C, 0xDF, 0xD7, 0xBD,
        0x17, 0x96, 0x0D, 0xC0, 0x64, 0x07, 0xEC, 0xC1, 0x9B, 0x75, 0xD8, 0xBE,
        0xFB, 0x69, 0xE5, 0xFD, 0x8C, 0xB3, 0xBB, 0x3B, 0xFB, 0xB2, 0x46, 0x47,
        0x7E, 0x32, 0xA2, 0xBD, 0x96, 0x5D, 0x57, 0x1E, 0xF0, 0x50, 0x15, 0xD3,
        0x45, 0x50, 0xB2, 0x16, 0x87, 0x6C, 0xD0, 0xC9, 0x57, 0x94, 0x7B, 0x01,
        0x63, 0x76, 0xAD, 0x12, 0x36, 0xE2, 0xA8, 0xE2, 0xEF, 0xA0, 0xAC, 0x5B,
        0xAF, 0x64, 0x9C, 0x9D, 0x38, 0xAA, 0x3A, 0x6B, 0xA0, 0x2F, 0x9B, 0x9E,
        0xE2, 0x4D, 0x38, 0x32, 0xFE, 0x89, 0xD6, 0xE9, 0xDB, 0xC2, 0x30, 0x3C,
        0x08, 0xF6, 0x11, 0xE6, 0x4B, 0x99, 0x04, 0xF4, 0xFD, 0xD5, 0x2E, 0x5B,
        0x66, 0x67, 0x9B, 0x3B, 0x16, 0xC1, 0xA8, 0xE0, 0xE1, 0x33, 0x39, 0x38,
        0x28, 0xBB, 0x66, 0x0A, 0x0A, 0x2A, 0x91, 0x55, 0x44, 0xC7, 0xA7, 0x73,
        0xD1, 0x42, 0x84, 0xD9, 0x9B, 0x42, 0xED, 0x95, 0x14, 0x9C, 0x47, 0xF2,
        0x96, 0x5A, 0x24, 0xCF, 0x0F, 0x27, 0xB6, 0xEF, 0x8D, 0x4C, 0x1F, 0x22,
        0x9D, 0x57, 0x28, 0x35, 0x36, 0xED, 0x9B, 0x3A, 0x61, 0xFF, 0xBE, 0xBA,
        0x14, 0xCA, 0x74, 0xE4, 0x60, 0xEC, 0xAA, 0x34, 0x18, 0x39, 0xF0, 0xAC,
        0x8E, 0xE9, 0x82, 0x02, 0xE3, 0xF1, 0x1B, 0xCD, 0xC3, 0xDF, 0xC3, 0x45,
        0x66, 0x44, 0x18, 0x8E, 0x1F, 0x14, 0xA8, 0xE4, 0x0C, 0xEA, 0x42, 0x6E,
        0x77, 0xE3, 0x8D, 0xDF, 0xC0, 0x40, 0x5E, 0xD6, 0x3D, 0x6A, 0xBB, 0x81,
        0xB2, 0xE1, 0x34, 0xF7, 0xC6, 0xB8, 0xD9, 0x01, 0xF5, 0x70, 0x0E, 0x2F,
        0xAE, 0x6F, 0x1E, 0x0C, 0xF8, 0x85, 0x8B, 0x54, 0x8F, 0x89, 0xA0, 0x3C,
        0xDB, 0x71, 0xE8, 0xA2, 0xBA, 0x0D, 0x46, 0x27, 0xF0, 0xCA, 0x6D, 0x92,
        0xB5, 0xC1, 0xF5, 0xE1, 0xCF, 0xAE, 0x7C, 0x2F, 0x74, 0x19, 0x91, 0xFC,
        0x62, 0xA6, 0x77, 0x16, 0x4E, 0x87, 0x3C, 0x28, 0x9D, 0x17, 0x77, 0xB8,
        0x40, 0xD7, 0x1C, 0x8C, 0x1C, 0x34, 0xAD, 0x5B, 0x13, 0xA8, 0x74, 0x1B,
        0xA6, 0x78, 0xA8, 0x34, 0x3F, 0x37, 0x65, 0x87, 0x16, 0x6D, 0x2F, 0x6F,
        0xBC, 0x34, 0x1E, 0x16, 0xA4, 0x59, 0x79, 0x6D, 0x6F, 0x60, 0x91, 0x7D,
        0x81, 0xEA, 0x7B, 0xAA, 0x56, 0xE9, 0x53, 0x93, 0xEB, 0x4B, 0x59, 0xB7,
        0x95, 0xC6, 0xC3, 0xC1, 0x79, 0x45, 0xF8, 0x91, 0x47, 0xAE, 0x18, 0x0E,
        0x74, 0x72, 0x91, 0x31, 0xE9, 0x77, 0x69, 0xF0, 0xFE, 0xEC, 0xC8, 0x48,
        0x7F, 0x57, 0x89, 0x4C, 0x06, 0xBA, 0x31, 0x9A, 0xED, 0xF4, 0x7C, 0x57,
        0x13, 0xCA, 0xD1, 0xA4, 0xE1, 0xE1, 0x45, 0x8B, 0xDA, 0x2F, 0x61, 0x91,
        0x7D, 0x03, 0x93, 0x13, 0xAA, 0xE7, 0xA5, 0xA8, 0x2F, 0xF1, 0x42, 0x21,
        0xEC, 0x62, 0xFE, 0x69, 0x6E, 0x80, 0x5A, 0x5F, 0xCF, 0x37, 0x62, 0xA2,
        0x1C, 0x0D, 0xDC, 0x9F, 0x66, 0x51, 0x0D, 0x7C, 0x00, 0xB3, 0x96, 0x5E,
        0x07, 0x78, 0xF4, 0xF9, 0xBA, 0xD5, 0x3E, 0x8E, 0x45, 0x35, 0xF0, 0x01,
        0xF7, 0x86, 0xB8, 0x5E, 0xBB, 0xAC, 0x84, 0x32, 0x64, 0x2C, 0x66, 0x51,
        0x0D, 0x7C, 0x00, 0x2D, 0xBC, 0x9F, 0x80, 0xD4, 0xFE, 0xA2, 0x95, 0xE7,
        0x1B, 0x9A, 0x80, 0x0C, 0x18, 0x74, 0x6B, 0xE5, 0xF1, 0x4D, 0x40, 0x06,
        0x08, 0xFD, 0x66, 0x08, 0x4D, 0x4B, 0x53, 0x16, 0xD5, 0xC0, 0x07, 0x68,
        0x85, 0x3C, 0xE2, 0x1C, 0xDC, 0xDD, 0xAE, 0x2B, 0x82, 0x41, 0x9F, 0xBB,
        0xC3, 0x91, 0x1E, 0x9F, 0x9D, 0xDB, 0x60, 0x6A, 0xE0, 0x14, 0x32, 0x9E,
        0x78, 0xD0, 0xE9, 0xF4, 0xE9, 0xB8, 0x6C, 0xE9, 0x6A, 0x9C, 0x93, 0xB8,
        0x9E, 0x45, 0x34, 0xF0, 0x89, 0x30, 0x4C, 0x0F, 0xC5, 0x7D, 0xF2, 0x94,
        0x25, 0x3B, 0xC9, 0xD9, 0x7B, 0x3A, 0x9D, 0xDF, 0xC1, 0x3D, 0x5A, 0xD2,
        0x71, 0x22, 0xB9, 0x05, 0x0F, 0x48, 0x66, 0x11, 0x03, 0x8E, 0xA1, 0xA1,
        0xFF, 0x03, 0xA4, 0x6C, 0x96, 0x4C, 0x87, 0xBF, 0xFF, 0xE3, 0x00, 0x00,
        0x00, 0x00, 0x49, 0x45, 0x4E, 0x44, 0xAE, 0x42, 0x60, 0x82
};

const char Html_png2[] = { 0x89, 0x50, 0x4E, 0x47, 0x0D, 0x0A, 0x1A, 0x0A, 0x00,
        0x00, 0x00, 0x0D, 0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x64, 0x00,
        0x00, 0x00, 0x64, 0x08, 0x06, 0x00, 0x00, 0x00, 0x70, 0xE2, 0x95, 0x54,
        0x00, 0x00, 0x00, 0x01, 0x73, 0x52, 0x47, 0x42, 0x00, 0xAE, 0xCE, 0x1C,
        0xE9, 0x00, 0x00, 0x00, 0x04, 0x67, 0x41, 0x4D, 0x41, 0x00, 0x00, 0xB1,
        0x8F, 0x0B, 0xFC, 0x61, 0x05, 0x00, 0x00, 0x00, 0x09, 0x70, 0x48, 0x59,
        0x73, 0x00, 0x00, 0x0E, 0xC3, 0x00, 0x00, 0x0E, 0xC3, 0x01, 0xC7, 0x6F,
        0xA8, 0x64, 0x00, 0x00, 0x07, 0xFB, 0x49, 0x44, 0x41, 0x54, 0x78, 0x5E,
        0xED, 0x9D, 0x6D, 0x88, 0x54, 0x55, 0x18, 0xC7, 0xD7, 0xCA, 0xA2, 0xB2,
        0x88, 0x5E, 0xC9, 0x32, 0x2B, 0x2A, 0x65, 0xA9, 0x99, 0x75, 0x77, 0x67,
        0x77, 0xF0, 0x8B, 0x68, 0x99, 0x03, 0xD2, 0x47, 0x2D, 0x91, 0xD2, 0x7C,
        0x89, 0x82, 0x5E, 0x20, 0x0A, 0xB4, 0x8F, 0x89, 0x95, 0x7E, 0x30, 0x49,
        0x53, 0x88, 0xB2, 0x32, 0x2B, 0xC3, 0x0F, 0x41, 0x66, 0xA6, 0x41, 0x49,
        0xD1, 0x9B, 0x66, 0x2B, 0x65, 0x10, 0xF6, 0x82, 0xA2, 0x11, 0xE4, 0x5A,
        0xE6, 0x4B, 0x52, 0xE9, 0xD6, 0xEF, 0x99, 0x7D, 0x66, 0xB9, 0xCE, 0x9E,
        0x7B, 0xE7, 0xCE, 0xDB, 0xEE, 0xD9, 0x3B, 0xCF, 0x1F, 0xFE, 0x9C, 0xB9,
        0x77, 0xFE, 0xE7, 0x39, 0xE7, 0x79, 0xFE, 0xF7, 0x9E, 0x3B, 0x73, 0x9D,
        0xBD, 0x36, 0x19, 0x0C, 0x06, 0x83, 0xC1, 0x60, 0x30, 0x18, 0x7C, 0x46,
        0x67, 0x67, 0x67, 0xAA, 0xB5, 0xB5, 0x75, 0x5E, 0x7B, 0x7B, 0xFB, 0xB2,
        0xB6, 0xB6, 0xB6, 0xF5, 0xE3, 0xC6, 0x8D, 0xDB, 0x04, 0xB7, 0x24, 0x95,
        0xE4, 0xB8, 0x11, 0xAE, 0x83, 0x4F, 0xC1, 0x19, 0xEC, 0xBB, 0x41, 0x4B,
        0x31, 0x78, 0xC0, 0x80, 0x2B, 0x31, 0x60, 0x21, 0x6D, 0x17, 0xED, 0x7F,
        0x98, 0xD2, 0xC7, 0x8E, 0x8E, 0x8E, 0xC4, 0x33, 0x98, 0x2F, 0xA6, 0xFC,
        0x9D, 0xC9, 0x64, 0xB6, 0xC1, 0xF9, 0xBC, 0x3E, 0x4F, 0x4B, 0x34, 0x30,
        0x68, 0x6E, 0x6E, 0x3E, 0x1B, 0x03, 0x9E, 0x60, 0xE0, 0xEE, 0x6C, 0x36,
        0x9B, 0x9F, 0x9C, 0x18, 0xC2, 0x76, 0xC3, 0x52, 0xF2, 0x2F, 0x98, 0xC4,
        0xEB, 0x1F, 0xD8, 0x77, 0x8F, 0x96, 0xAB, 0xBE, 0xE0, 0xD4, 0x4C, 0x31,
        0xD8, 0x0E, 0x31, 0x82, 0xA3, 0xC1, 0x39, 0xB9, 0x46, 0xA7, 0xD4, 0x45,
        0x8D, 0x79, 0x3B, 0x95, 0x4A, 0x5D, 0xAE, 0xA5, 0xAB, 0x3D, 0x30, 0x23,
        0xC7, 0x80, 0x47, 0xF4, 0x14, 0x35, 0x96, 0xA0, 0x1C, 0xB4, 0xB4, 0x7B,
        0xE0, 0x58, 0x2D, 0x61, 0xED, 0xC0, 0x75, 0x62, 0x0A, 0xCE, 0xFF, 0x13,
        0xE7, 0xAC, 0x90, 0xD3, 0xB7, 0x11, 0xE8, 0xCA, 0xBD, 0x98, 0x7A, 0xA6,
        0xFC, 0xD2, 0xD2, 0xD2, 0x72, 0xA3, 0x96, 0xB2, 0x7A, 0x10, 0xAC, 0x99,
        0xA0, 0xC7, 0xA2, 0xCC, 0x90, 0x09, 0xCA, 0xE0, 0xB2, 0x8E, 0xCA, 0x36,
        0x67, 0xD3, 0x71, 0x78, 0x84, 0xD7, 0x47, 0x93, 0x46, 0xC9, 0x0B, 0x9E,
        0x08, 0xE6, 0x1C, 0x65, 0x90, 0x68, 0x38, 0xA0, 0xBF, 0x47, 0x77, 0xA1,
        0x96, 0xB4, 0x72, 0xC8, 0x05, 0x9C, 0xA0, 0xBB, 0xA2, 0x96, 0x29, 0x7D,
        0xEF, 0x18, 0x94, 0x8F, 0x81, 0x33, 0x30, 0x30, 0xCD, 0x04, 0x47, 0x31,
        0xE9, 0x91, 0xE9, 0x74, 0xFA, 0xAA, 0xA4, 0x51, 0xF2, 0x82, 0xA3, 0xC9,
        0x31, 0x43, 0xA1, 0xEF, 0xA3, 0x7D, 0x57, 0x0C, 0x29, 0x1C, 0x8C, 0x2E,
        0xCA, 0xF2, 0x45, 0x9F, 0xD7, 0xB5, 0xAC, 0x95, 0x83, 0x01, 0x17, 0xEA,
        0x5A, 0xD8, 0x8F, 0x85, 0x49, 0xA0, 0x59, 0xCB, 0x60, 0x83, 0xFF, 0x39,
        0x7C, 0x10, 0x41, 0x3D, 0x3A, 0xA8, 0xC7, 0x47, 0x51, 0x07, 0xAE, 0xD4,
        0x8A, 0x55, 0x26, 0xA7, 0x5D, 0xCA, 0x07, 0x47, 0xFA, 0x65, 0x04, 0x3A,
        0xEC, 0x5A, 0xAA, 0xC4, 0x0C, 0xDD, 0x7F, 0xBF, 0xCA, 0x0D, 0x80, 0xBA,
        0x2C, 0x0B, 0x33, 0x45, 0x0F, 0xDE, 0x2E, 0x64, 0x67, 0xF4, 0xAA, 0xCB,
        0x44, 0xD4, 0xD9, 0xA1, 0xC1, 0x1F, 0x50, 0xA9, 0x21, 0x00, 0x56, 0x8B,
        0x55, 0x51, 0xA6, 0x54, 0x74, 0x96, 0x4C, 0x9B, 0x36, 0xED, 0x4C, 0x0A,
        0xBE, 0xDB, 0x75, 0x76, 0xC8, 0x60, 0x35, 0x59, 0x0F, 0x13, 0x0A, 0xAD,
        0x5D, 0x97, 0x14, 0xDF, 0x55, 0x3B, 0xDE, 0x7B, 0x53, 0xA5, 0xF1, 0x41,
        0xA7, 0x5B, 0x64, 0x59, 0x2A, 0x0E, 0x28, 0xFB, 0xE0, 0x31, 0x06, 0xBB,
        0x5A, 0xA5, 0x06, 0x07, 0xA8, 0xDF, 0xED, 0x2E, 0x43, 0xE4, 0x00, 0xE7,
        0x60, 0xFE, 0x95, 0x2F, 0x8C, 0xE7, 0xAB, 0x34, 0x1E, 0x08, 0x38, 0xDF,
        0x75, 0xDA, 0xE9, 0xBE, 0x75, 0x2A, 0x33, 0x44, 0x80, 0xC2, 0x7F, 0x13,
        0x76, 0xFD, 0xA5, 0xED, 0x50, 0x59, 0x3C, 0xD0, 0x61, 0xB9, 0xCB, 0x10,
        0xBD, 0x76, 0x4C, 0x57, 0x99, 0x21, 0x02, 0x18, 0xF2, 0x74, 0xC4, 0x41,
        0x5D, 0xDE, 0xBD, 0x2E, 0x3A, 0xBC, 0x55, 0x1C, 0x4C, 0x9D, 0xED, 0xA1,
        0xBD, 0x59, 0x65, 0x86, 0x08, 0x50, 0xA7, 0xBB, 0x22, 0xAE, 0x23, 0x0B,
        0x55, 0x16, 0x0F, 0xB8, 0xBB, 0xA9, 0x38, 0x98, 0x18, 0xC2, 0xFE, 0xBF,
        0x68, 0x47, 0xA9, 0xCC, 0x10, 0x01, 0x6A, 0x36, 0x39, 0xEC, 0x43, 0x11,
        0xED, 0x62, 0x95, 0xC5, 0x03, 0x85, 0xDF, 0xEA, 0x32, 0x04, 0x67, 0xE5,
        0xB6, 0xC1, 0x48, 0x95, 0x19, 0x22, 0x40, 0xAD, 0x26, 0x46, 0x7C, 0x4A,
        0x5D, 0xAA, 0xB2, 0x78, 0xA0, 0xC3, 0x16, 0x97, 0x21, 0xB4, 0x47, 0xE5,
        0xF6, 0x81, 0xCA, 0x0C, 0x11, 0xC0, 0x90, 0x49, 0x61, 0x86, 0xF0, 0xDE,
        0x12, 0x95, 0xC5, 0x83, 0x19, 0x52, 0x3D, 0x12, 0x6D, 0x88, 0xDC, 0xB0,
        0x24, 0xB9, 0x99, 0x24, 0x32, 0x1B, 0xCE, 0x2A, 0x83, 0xB3, 0xE9, 0x37,
        0x9D, 0xCF, 0xFD, 0xD7, 0x69, 0xA8, 0x01, 0x03, 0x63, 0x27, 0xD2, 0x90,
        0x61, 0x8C, 0xBB, 0x82, 0xC4, 0x7A, 0x24, 0x91, 0x4A, 0x49, 0x7F, 0xB9,
        0x1B, 0xFD, 0x90, 0xC6, 0x1C, 0x10, 0x24, 0xD2, 0x10, 0xC6, 0x9B, 0x2B,
        0xF7, 0xD3, 0x74, 0xEC, 0x8A, 0x29, 0x85, 0x91, 0x7C, 0x28, 0x44, 0xA7,
        0x86, 0xAE, 0x3B, 0x12, 0x69, 0x08, 0x13, 0xFF, 0x40, 0x12, 0x08, 0xCE,
        0xA3, 0x52, 0xEA, 0x8D, 0xD2, 0xF2, 0x3E, 0xDD, 0x54, 0x81, 0xA4, 0x1A,
        0xF2, 0x69, 0xF1, 0x3C, 0x2A, 0xA5, 0x14, 0x82, 0x1C, 0x56, 0x6B, 0xE8,
        0xBA, 0x23, 0x91, 0x86, 0x30, 0x8F, 0x4F, 0x6A, 0x69, 0x08, 0xED, 0xF3,
        0x1A, 0xBA, 0xEE, 0x30, 0x43, 0x4A, 0xD0, 0x0C, 0xA9, 0x01, 0xCC, 0x10,
        0x85, 0x19, 0x52, 0x3D, 0x12, 0x69, 0x08, 0x13, 0xDF, 0x56, 0x63, 0x43,
        0x9E, 0xD5, 0xD0, 0x75, 0x87, 0xB7, 0x86, 0x8C, 0x1F, 0x3F, 0xFE, 0x02,
        0x26, 0x20, 0xE8, 0xA4, 0x7F, 0x47, 0x5C, 0x32, 0x9E, 0xFC, 0xCC, 0xA6,
        0xCB, 0x95, 0x54, 0x25, 0x94, 0x7C, 0x88, 0xB7, 0x81, 0x6F, 0xFD, 0x19,
        0xB6, 0x9D, 0x63, 0xBA, 0x28, 0xF3, 0xA6, 0x1E, 0xA9, 0x09, 0x13, 0x26,
        0x9C, 0xA5, 0x29, 0xC5, 0x02, 0xFD, 0xFC, 0x33, 0x84, 0x81, 0xE5, 0xD7,
        0xE0, 0xFB, 0xA5, 0x6F, 0x25, 0x0C, 0x8E, 0x5F, 0x2B, 0xBA, 0xC6, 0x89,
        0x43, 0xFA, 0xEE, 0xA6, 0x2E, 0xB7, 0x6A, 0x6A, 0x25, 0xE1, 0x9D, 0x21,
        0x0C, 0x3A, 0x45, 0x06, 0xAF, 0xD5, 0x11, 0x3E, 0xD8, 0x94, 0x5C, 0xA8,
        0xC1, 0x71, 0x78, 0xBD, 0xA6, 0x18, 0x09, 0x1F, 0x0D, 0xD9, 0x20, 0x83,
        0x07, 0x63, 0x0C, 0x75, 0xCA, 0xB7, 0x7D, 0xF2, 0x8A, 0xF5, 0xAF, 0x7D,
        0x3E, 0x1A, 0x52, 0xB3, 0x0B, 0xB2, 0x2F, 0xD4, 0x62, 0x3E, 0xA7, 0x29,
        0x46, 0xC2, 0x3B, 0x43, 0x88, 0xF1, 0x61, 0x12, 0x0D, 0xA1, 0x5D, 0xAE,
        0x29, 0x46, 0xC2, 0x0C, 0x19, 0x00, 0x9A, 0x21, 0x9E, 0xD1, 0x0C, 0xF1,
        0x8C, 0x66, 0x88, 0x67, 0x34, 0x43, 0x3C, 0xA3, 0x19, 0xE2, 0x19, 0xCD,
        0x10, 0xCF, 0x68, 0x86, 0x78, 0x46, 0x33, 0xC4, 0x33, 0x9A, 0x21, 0x9E,
        0xD1, 0x0C, 0xF1, 0x8C, 0x66, 0x88, 0x67, 0x34, 0x43, 0x3C, 0xA3, 0x19,
        0xE2, 0x19, 0xCD, 0x10, 0xCF, 0x68, 0x86, 0x78, 0x46, 0x33, 0xC4, 0x33,
        0x36, 0x8C, 0x21, 0xA2, 0x93, 0x89, 0xEA, 0x18, 0xA1, 0x94, 0x04, 0xCB,
        0xD1, 0xB9, 0x0A, 0x12, 0xA4, 0xC4, 0x89, 0xA3, 0x2B, 0x50, 0xB4, 0xB4,
        0xC9, 0x36, 0x44, 0xE2, 0xA2, 0xDD, 0xCA, 0xEB, 0xF5, 0x4C, 0xF4, 0xDF,
        0xB0, 0x62, 0x4B, 0x72, 0xE8, 0x76, 0xF2, 0xFA, 0x35, 0xDA, 0x3F, 0xA3,
        0x74, 0xB4, 0x7B, 0x89, 0x25, 0x4F, 0x29, 0xDA, 0x17, 0x56, 0x6C, 0xED,
        0x7F, 0x18, 0x4A, 0xBC, 0xAF, 0xE3, 0x98, 0x92, 0x78, 0x43, 0xE4, 0x7D,
        0x26, 0xB7, 0x41, 0xBB, 0xC8, 0x1F, 0xE8, 0x3C, 0xEA, 0xEA, 0xA3, 0x89,
        0xED, 0x92, 0xE7, 0x77, 0x89, 0x8E, 0x3E, 0x53, 0x98, 0xCF, 0xA9, 0x62,
        0x9D, 0xCC, 0x91, 0xF7, 0xBA, 0x79, 0x7D, 0x8D, 0xE8, 0x98, 0xEB, 0xB5,
        0x6C, 0x1F, 0x0A, 0x31, 0xEF, 0x24, 0xFB, 0x6F, 0x13, 0x5D, 0x2E, 0x97,
        0x3B, 0x87, 0xD7, 0xCE, 0x27, 0x2F, 0x04, 0x99, 0x78, 0x43, 0x74, 0x72,
        0x7D, 0x4F, 0x15, 0xD2, 0x87, 0x9F, 0x39, 0x75, 0xC4, 0x7B, 0x41, 0x65,
        0xF2, 0x60, 0xB5, 0x11, 0x6C, 0xF7, 0x2B, 0xB4, 0x8E, 0xF7, 0xB9, 0xCA,
        0xF2, 0x40, 0xF7, 0xA5, 0x2B, 0x17, 0xF6, 0x77, 0x07, 0x9F, 0x39, 0xC2,
        0x3C, 0x5E, 0xD4, 0x82, 0x87, 0xB2, 0x21, 0x0C, 0xA1, 0x7D, 0x50, 0xBB,
        0xC8, 0xD3, 0x0F, 0x32, 0x61, 0x86, 0x48, 0xC1, 0x54, 0xD6, 0x94, 0xCD,
        0x66, 0x2F, 0x26, 0xFE, 0xC1, 0x6A, 0x0C, 0xA1, 0xFD, 0x4D, 0xE2, 0xA8,
        0x4C, 0x0A, 0xF8, 0x92, 0x19, 0xD2, 0x9B, 0x60, 0xDF, 0x1F, 0x63, 0xF2,
        0x5A, 0x7E, 0xD3, 0xEB, 0xD4, 0x49, 0xC1, 0x54, 0xD6, 0x44, 0xA2, 0x97,
        0x10, 0xBF, 0xDB, 0x65, 0x08, 0xFB, 0xBF, 0x50, 0x59, 0x1E, 0xF4, 0xDB,
        0xEE, 0xCA, 0x05, 0xDD, 0xC1, 0xA0, 0x21, 0xEC, 0x5F, 0x63, 0x86, 0x98,
        0x21, 0xF1, 0x60, 0x86, 0xB8, 0x69, 0x86, 0x04, 0x74, 0x66, 0x88, 0x19,
        0xD2, 0x8F, 0x66, 0x48, 0x40, 0x67, 0x86, 0x54, 0x69, 0x08, 0x83, 0x96,
        0xFC, 0xF5, 0xFB, 0x50, 0x34, 0x84, 0x78, 0x43, 0xF3, 0xD7, 0xEF, 0x0C,
        0x5A, 0xF2, 0xEF, 0x43, 0xF4, 0xFD, 0x21, 0x63, 0x08, 0x7A, 0x69, 0x17,
        0x68, 0x97, 0x48, 0x78, 0x67, 0x08, 0xDA, 0xC9, 0x12, 0xA3, 0x38, 0x4E,
        0x90, 0x92, 0x20, 0x93, 0x7B, 0x58, 0xBB, 0x48, 0x12, 0x9D, 0x2E, 0x43,
        0x54, 0xB7, 0x46, 0x65, 0x79, 0x43, 0xD8, 0xFE, 0xBD, 0x58, 0xAB, 0xC9,
        0x6E, 0x57, 0x59, 0x1E, 0x6C, 0x7F, 0x55, 0x5C, 0x68, 0x35, 0xE4, 0x50,
        0x91, 0x21, 0x2F, 0x6B, 0xC1, 0xFB, 0x51, 0xF4, 0x1A, 0x43, 0x9E, 0xC8,
        0x1A, 0xEB, 0xC9, 0x42, 0x8C, 0xEB, 0x97, 0x21, 0x02, 0xF4, 0x73, 0x99,
        0xD4, 0x3E, 0xE9, 0xEB, 0xA2, 0x16, 0xFA, 0x11, 0x95, 0xE7, 0x0D, 0x91,
        0x24, 0x5C, 0x3A, 0x62, 0xBD, 0xA2, 0xB2, 0xBC, 0x21, 0x6C, 0xE7, 0x9F,
        0xBA, 0x1D, 0xD4, 0x69, 0xD1, 0x76, 0xA8, 0x2C, 0x0F, 0x72, 0xD9, 0x29,
        0xFB, 0x83, 0x3A, 0x2D, 0xD4, 0x1F, 0x41, 0x43, 0x18, 0xFB, 0x55, 0x19,
        0x27, 0xA8, 0x0B, 0xB0, 0x87, 0x3E, 0xDF, 0xA2, 0x99, 0xA8, 0xF2, 0x92,
        0x40, 0xEB, 0x9F, 0x21, 0x02, 0xB9, 0xEF, 0xC4, 0x24, 0xE4, 0xFF, 0xA8,
        0x6A, 0x83, 0xA7, 0x81, 0x09, 0xB7, 0x07, 0xFF, 0xD3, 0x13, 0xB9, 0xB7,
        0xC4, 0x6E, 0xD1, 0x9D, 0xA6, 0x15, 0x1D, 0x73, 0x1A, 0xAD, 0xB2, 0x26,
        0xF9, 0x8B, 0x58, 0xB9, 0xEF, 0xC5, 0x5B, 0xFD, 0x74, 0x60, 0x8C, 0xCA,
        0xF2, 0x60, 0xCE, 0x63, 0x65, 0xBF, 0x4A, 0x0A, 0x68, 0x23, 0x5E, 0x4A,
        0x1E, 0x7A, 0xAC, 0x32, 0xC9, 0x79, 0xB4, 0x43, 0xD7, 0xCA, 0xFE, 0x76,
        0x6A, 0xD1, 0x8C, 0xA4, 0x4F, 0x1B, 0x07, 0x74, 0xF5, 0xD3, 0x90, 0x46,
        0x85, 0x19, 0xE2, 0x19, 0x6A, 0x6D, 0x88, 0x3D, 0x95, 0xB4, 0x4A, 0x50,
        0xAB, 0xDA, 0x3D, 0x95, 0x94, 0x8E, 0x1B, 0x5D, 0x86, 0x10, 0xE8, 0x04,
        0xEC, 0x5B, 0xCB, 0x0D, 0xE1, 0xA0, 0x4E, 0xB9, 0x88, 0x33, 0x64, 0x91,
        0xCA, 0xE2, 0x81, 0x0E, 0x6F, 0x48, 0xC7, 0xE2, 0x60, 0x7A, 0x96, 0xB4,
        0xAA, 0xCC, 0x10, 0x01, 0xCA, 0x34, 0xCB, 0x55, 0x43, 0x35, 0xE4, 0x71,
        0x95, 0xC5, 0x03, 0x1D, 0x9E, 0x09, 0x0B, 0x86, 0x29, 0x73, 0x54, 0x66,
        0x88, 0x00, 0x9F, 0x02, 0x57, 0xBA, 0x6A, 0x28, 0x2B, 0x0F, 0x67, 0xCF,
        0x9D, 0x2A, 0x8B, 0x07, 0x0C, 0x99, 0x19, 0x16, 0x8C, 0xF7, 0x36, 0xAB,
        0xCC, 0x10, 0x02, 0x6A, 0x35, 0x1C, 0xEE, 0x75, 0x2D, 0x59, 0xB0, 0x07,
        0x43, 0x52, 0x2A, 0x8D, 0x07, 0xCE, 0x82, 0xEB, 0x29, 0x7C, 0xD8, 0x2F,
        0x40, 0x4E, 0x32, 0x50, 0x8B, 0x4A, 0x0D, 0x0E, 0x50, 0x3B, 0xE7, 0x72,
        0x25, 0x06, 0xF1, 0xDE, 0xCF, 0x85, 0x1F, 0x6B, 0x94, 0x05, 0x3A, 0x3A,
        0x1F, 0x40, 0xA9, 0xFB, 0x3E, 0x56, 0x99, 0xA1, 0x08, 0xF2, 0xED, 0x9F,
        0xFA, 0x1C, 0x88, 0xF8, 0x84, 0xB5, 0x4A, 0xA5, 0xE5, 0x01, 0x43, 0xE6,
        0xB9, 0x5C, 0x2E, 0x04, 0xA6, 0x8D, 0x75, 0x1B, 0xBA, 0x91, 0x20, 0x77,
        0x10, 0xA8, 0x5B, 0xE8, 0xA3, 0x6D, 0xC5, 0x24, 0x56, 0x9D, 0x8C, 0xCA,
        0xCB, 0x03, 0x4E, 0x9F, 0x8B, 0x9B, 0xA1, 0x3F, 0x34, 0xD3, 0x41, 0x57,
        0xC2, 0xE1, 0xDA, 0xA5, 0xA1, 0x41, 0x3D, 0xAE, 0xA0, 0x16, 0x9B, 0x4B,
        0x1C, 0xC4, 0xEF, 0xAB, 0xBC, 0x32, 0xE0, 0xB6, 0xF3, 0xE2, 0x5E, 0xA0,
        0xBE, 0xB7, 0x03, 0xDD, 0x54, 0xED, 0xD2, 0x70, 0x90, 0x03, 0x97, 0xA3,
        0xFE, 0x5E, 0x6A, 0xB0, 0x3F, 0xAC, 0x56, 0x72, 0x2D, 0x86, 0xA7, 0x6A,
        0x72, 0xED, 0x25, 0xE0, 0x3B, 0x72, 0x17, 0xB4, 0x78, 0x90, 0x02, 0xE5,
        0x9A, 0xA2, 0x67, 0xD1, 0x2E, 0xB8, 0x54, 0x4C, 0xA4, 0x9D, 0x4C, 0x3B,
        0x11, 0x4E, 0x4A, 0x20, 0xE5, 0x1B, 0x78, 0x8E, 0x02, 0xCF, 0xE1, 0xF5,
        0x6A, 0xDA, 0x1F, 0x03, 0x35, 0x70, 0x52, 0xEA, 0xC7, 0x6A, 0xF3, 0xA4,
        0x96, 0xB4, 0x3A, 0x10, 0xF0, 0x52, 0x06, 0xFE, 0xC9, 0x75, 0x81, 0x0F,
        0x52, 0x26, 0x24, 0x47, 0x48, 0x61, 0x72, 0x49, 0xA7, 0xE4, 0x2A, 0x94,
        0xD7, 0xAE, 0x7A, 0x14, 0xA8, 0x66, 0x6C, 0xD1, 0x72, 0xD6, 0x06, 0x1C,
        0x05, 0x63, 0x08, 0x7E, 0x20, 0xEC, 0x94, 0x34, 0xBA, 0xA9, 0x2B, 0xCB,
        0x67, 0xF2, 0x20, 0x50, 0x2D, 0x65, 0xED, 0x90, 0x4A, 0xA5, 0x6E, 0x22,
        0xF8, 0x77, 0x51, 0xCB, 0x97, 0xB1, 0x97, 0x72, 0xCD, 0x90, 0x3A, 0xB1,
        0xB2, 0xBC, 0x57, 0x17, 0x33, 0x0A, 0x48, 0xA7, 0xD3, 0x17, 0x31, 0xC8,
        0x5A, 0x59, 0x96, 0x4A, 0x2D, 0x61, 0x8D, 0x4A, 0x5D, 0x45, 0xE4, 0x97,
        0xF5, 0x72, 0x03, 0x71, 0x58, 0x6F, 0xE5, 0xEA, 0x0C, 0xD6, 0xC4, 0x3B,
        0x18, 0x30, 0xFF, 0x23, 0xE6, 0x38, 0xEB, 0x68, 0x92, 0x29, 0x67, 0x43,
        0xE1, 0x9A, 0x22, 0x2D, 0xDB, 0x1B, 0x61, 0x65, 0xDF, 0x35, 0xAA, 0x05,
        0x67, 0xCB, 0x54, 0x26, 0xB5, 0x8E, 0x36, 0xFF, 0x6C, 0x5E, 0x99, 0x54,
        0x23, 0x51, 0x0E, 0x48, 0xC9, 0x9B, 0x1A, 0xEC, 0xA1, 0x5D, 0xC1, 0x76,
        0x56, 0x4B, 0x33, 0xB8, 0xE0, 0x1B, 0xEA, 0x08, 0x4C, 0x91, 0x5F, 0x8C,
        0xDC, 0xCD, 0xE4, 0x16, 0xC0, 0xC5, 0x6C, 0x2F, 0x49, 0x30, 0x17, 0xC1,
        0xC7, 0xE0, 0x74, 0x56, 0x8B, 0x14, 0xF9, 0xDA, 0x97, 0x63, 0x83, 0xC1,
        0x60, 0x30, 0x18, 0x0C, 0x05, 0x34, 0x35, 0xFD, 0x0F, 0x62, 0x0D, 0xDC,
        0x5B, 0xB8, 0xF9, 0x1F, 0x68, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45, 0x4E,
        0x44, 0xAE, 0x42, 0x60, 0x82
};

const char Html_png3[] = { 0x89, 0x50, 0x4E, 0x47, 0x0D, 0x0A, 0x1A, 0x0A, 0x00,
        0x00, 0x00, 0x0D, 0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x64, 0x00,
        0x00, 0x00, 0x64, 0x08, 0x06, 0x00, 0x00, 0x00, 0x70, 0xE2, 0x95, 0x54,
        0x00, 0x00, 0x00, 0x01, 0x73, 0x52, 0x47, 0x42, 0x00, 0xAE, 0xCE, 0x1C,
        0xE9, 0x00, 0x00, 0x00, 0x04, 0x67, 0x41, 0x4D, 0x41, 0x00, 0x00, 0xB1,
        0x8F, 0x0B, 0xFC, 0x61, 0x05, 0x00, 0x00, 0x00, 0x09, 0x70, 0x48, 0x59,
        0x73, 0x00, 0x00, 0x0E, 0xC3, 0x00, 0x00, 0x0E, 0xC3, 0x01, 0xC7, 0x6F,
        0xA8, 0x64, 0x00, 0x00, 0x09, 0x2F, 0x49, 0x44, 0x41, 0x54, 0x78, 0x5E,
        0xED, 0x5D, 0x6B, 0x8C, 0x25, 0x45, 0x15, 0x9E, 0xC5, 0x44, 0x24, 0xA2,
        0xC4, 0xC4, 0xB8, 0x88, 0xCB, 0x8E, 0x3B, 0xB7, 0xEB, 0x54, 0x75, 0xDF,
        0x65, 0xE2, 0xCC, 0x74, 0x55, 0xF7, 0xCC, 0x02, 0xFB, 0x03, 0x13, 0xFD,
        0x61, 0xE2, 0x2F, 0x8C, 0x9A, 0x10, 0x08, 0xA2, 0xE0, 0x03, 0x42, 0xDC,
        0x3F, 0x8A, 0x8A, 0xA0, 0xF8, 0x4A, 0x8C, 0x91, 0xF0, 0xF2, 0x87, 0x51,
        0xE2, 0x5B, 0xCC, 0x06, 0xF0, 0x81, 0x20, 0x2C, 0x92, 0x2C, 0x1A, 0x1F,
        0x09, 0xC8, 0x33, 0xE0, 0x12, 0x14, 0x61, 0x17, 0x34, 0x08, 0xB8, 0x66,
        0x1F, 0x84, 0xDD, 0x1D, 0xCF, 0xA9, 0x3A, 0x17, 0x70, 0xAD, 0x71, 0x67,
        0xFA, 0x76, 0xDF, 0x5B, 0x35, 0xD4, 0x97, 0x7C, 0xC9, 0x3C, 0xEE, 0x3D,
        0x55, 0x75, 0xBE, 0x3A, 0x55, 0xA7, 0xAA, 0xBB, 0xAB, 0x27, 0x62, 0xC1,
        0xE4, 0xE4, 0xE6, 0xD7, 0x28, 0x55, 0xCF, 0x4A, 0x69, 0xCE, 0x16, 0x42,
        0x7F, 0x1D, 0xA0, 0xBA, 0x45, 0x64, 0xE6, 0x61, 0x21, 0xCA, 0x67, 0x24,
        0x98, 0x45, 0xE6, 0x41, 0xE4, 0x3F, 0x24, 0x94, 0x0F, 0x00, 0x98, 0x9F,
        0xE1, 0x67, 0xBF, 0xAC, 0x44, 0xF5, 0x5E, 0x80, 0x79, 0x85, 0x26, 0xD6,
        0x38, 0x4B, 0x09, 0x8D, 0xD0, 0x17, 0x55, 0x8E, 0x02, 0x9C, 0x89, 0x8E,
        0xBF, 0x46, 0x09, 0xF3, 0x1B, 0x74, 0xFE, 0x2E, 0x74, 0xF6, 0x7E, 0x72,
        0xBC, 0x92, 0x95, 0x25, 0x8B, 0xE0, 0xE5, 0xCB, 0x3F, 0x83, 0xE2, 0xEC,
        0x41, 0x3E, 0x26, 0x65, 0xB5, 0x4D, 0x81, 0xF9, 0x6A, 0x0E, 0xF5, 0x7B,
        0xF2, 0x7C, 0x7E, 0x92, 0x8B, 0x4A, 0x58, 0x02, 0x6B, 0x72, 0x31, 0x7F,
        0x2A, 0x39, 0x4C, 0x49, 0x7D, 0x0F, 0x3A, 0xF2, 0x60, 0x91, 0x2F, 0x2C,
        0x12, 0x73, 0x35, 0x8F, 0xCE, 0xAD, 0x8F, 0x28, 0xC2, 0x52, 0x74, 0xE2,
        0xD4, 0xD6, 0xCE, 0xC0, 0xA6, 0x04, 0xBD, 0x0F, 0xC5, 0xFE, 0x2D, 0x8A,
        0xF4, 0xE9, 0x42, 0xE8, 0xB7, 0x71, 0x1D, 0x12, 0xA6, 0xA6, 0xE6, 0xD6,
        0x4B, 0x59, 0x5F, 0x84, 0x51, 0x70, 0x6F, 0xAE, 0x6A, 0x16, 0xA0, 0x46,
        0x87, 0x35, 0x73, 0xFE, 0x72, 0x49, 0x22, 0x39, 0x81, 0x36, 0x39, 0xC1,
        0x30, 0x0A, 0x71, 0x88, 0x3B, 0x77, 0xFD, 0x49, 0x27, 0xBF, 0x81, 0xAB,
        0xF6, 0xCA, 0x42, 0x96, 0x99, 0x42, 0x41, 0xF5, 0x0D, 0x25, 0xF4, 0x6E,
        0x72, 0x0A, 0x39, 0xC7, 0xE7, 0xB8, 0xD1, 0x70, 0x20, 0xCE, 0xC2, 0x22,
        0x88, 0x6A, 0x97, 0x82, 0xFA, 0x32, 0x21, 0xEA, 0xB7, 0x70, 0x55, 0x57,
        0x37, 0xFA, 0xBD, 0xF2, 0x44, 0x1C, 0x3E, 0xAE, 0xC6, 0x86, 0x3F, 0x3F,
        0xE8, 0x9D, 0x7E, 0x27, 0x8D, 0x87, 0x34, 0xB4, 0x51, 0xBD, 0x40, 0xD4,
        0x4F, 0xE3, 0x70, 0x76, 0x09, 0x76, 0x9C, 0xD7, 0x73, 0xD5, 0x57, 0x1D,
        0xD6, 0x28, 0xD0, 0x1F, 0x07, 0x61, 0xFE, 0x19, 0xA2, 0x10, 0x87, 0x73,
        0x20, 0x8C, 0x92, 0xE6, 0x11, 0xA5, 0xCC, 0xFB, 0xB8, 0x0D, 0xAB, 0x03,
        0x59, 0x56, 0xCE, 0x60, 0x03, 0xB7, 0xBB, 0x06, 0xD2, 0xFC, 0xE0, 0x77,
        0x42, 0x88, 0x1C, 0xCC, 0x6B, 0x98, 0x3E, 0xFF, 0x44, 0xCA, 0x99, 0x13,
        0xB8, 0x49, 0xF1, 0x02, 0x33, 0x99, 0x8F, 0x60, 0x2F, 0xDB, 0xEB, 0x32,
        0x1B, 0x7F, 0xA3, 0x63, 0xA0, 0xED, 0x4C, 0xC2, 0xEC, 0xC4, 0xF4, 0xF9,
        0xDD, 0xDC, 0xB4, 0xB8, 0x40, 0x0B, 0x39, 0x14, 0xE3, 0x5A, 0xDB, 0xBB,
        0x22, 0x8B, 0x8A, 0xA5, 0x48, 0xD1, 0x42, 0x93, 0x3F, 0xB6, 0xEB, 0x33,
        0xDC, 0xCC, 0x38, 0x50, 0x4C, 0xEA, 0xE3, 0x31, 0x2A, 0xEE, 0xEC, 0x17,
        0x9B, 0xBC, 0x0D, 0x8B, 0x99, 0x34, 0xF7, 0xD9, 0x68, 0x81, 0xEA, 0xFB,
        0x45, 0x51, 0xBC, 0x9A, 0x9B, 0x1C, 0x2E, 0x7A, 0xBD, 0x99, 0x0C, 0x33,
        0xA8, 0x87, 0x47, 0x35, 0x44, 0xD9, 0x35, 0x04, 0x46, 0xE0, 0x4B, 0x1C,
        0x4D, 0xB2, 0x60, 0x3B, 0x9B, 0xAC, 0x6E, 0x0B, 0x3A, 0x0B, 0x53, 0x1B,
        0x34, 0xA0, 0x43, 0x1E, 0xEF, 0x52, 0x8C, 0xC1, 0x24, 0xEB, 0x86, 0xC2,
        0x6A, 0x51, 0x64, 0xFA, 0xDF, 0x42, 0x98, 0x27, 0x25, 0x94, 0x4F, 0x00,
        0x94, 0x4F, 0x61, 0x16, 0xB7, 0xC7, 0xF5, 0x62, 0x5E, 0xE5, 0x77, 0x38,
        0x5C, 0xF6, 0x31, 0x52, 0x68, 0xB5, 0x8F, 0x8B, 0xDB, 0xE3, 0xD8, 0x05,
        0xE1, 0x00, 0x7B, 0xCA, 0x3A, 0x5C, 0xE4, 0xFD, 0xA5, 0x0B, 0x31, 0x06,
        0x0E, 0xA6, 0x08, 0x40, 0x87, 0xDF, 0x87, 0x3D, 0xF3, 0x4A, 0x99, 0xE9,
        0xF7, 0xAB, 0x1E, 0x6D, 0x36, 0xCE, 0x9C, 0x30, 0x3D, 0x3D, 0xFD, 0xDA,
        0x75, 0xEB, 0xEA, 0x63, 0x8A, 0x62, 0xF3, 0xB1, 0xB4, 0xA0, 0x43, 0x61,
        0x34, 0x7E, 0xE6, 0x2C, 0x29, 0xCB, 0x6F, 0xE2, 0xF7, 0x1F, 0x19, 0x2C,
        0xFA, 0xBA, 0x88, 0x1E, 0x12, 0x05, 0xEB, 0xB2, 0x3D, 0xCB, 0xDE, 0x79,
        0x34, 0xBB, 0x62, 0xFC, 0x58, 0x8B, 0x0E, 0xC1, 0xCA, 0xDD, 0xD5, 0xB6,
        0x18, 0x03, 0x21, 0x50, 0x84, 0x67, 0xA4, 0x34, 0x57, 0x29, 0xB5, 0x30,
        0x8F, 0xC5, 0xAD, 0x68, 0xD7, 0x96, 0xC6, 0xF9, 0x1C, 0xF4, 0x69, 0xF8,
        0xFD, 0xEF, 0x2A, 0xA9, 0xF7, 0x75, 0x21, 0x8C, 0x8B, 0x14, 0xB3, 0x95,
        0x8B, 0x1C, 0x3F, 0xA4, 0x30, 0xD7, 0xD9, 0x9E, 0xE2, 0xA9, 0x6C, 0x53,
        0x5A, 0xC7, 0x09, 0xBD, 0x1B, 0x87, 0x84, 0x2F, 0x4A, 0xB9, 0xD0, 0x4A,
        0xFE, 0x8F, 0x11, 0x23, 0xED, 0x76, 0x8D, 0xAC, 0xEC, 0xC6, 0xA5, 0xAF,
        0xDC, 0xA6, 0xA4, 0x39, 0x05, 0x7A, 0xE5, 0xE7, 0xB9, 0xA8, 0xF1, 0x01,
        0x40, 0x7F, 0xB8, 0x4D, 0x31, 0x5E, 0x96, 0x5A, 0xFE, 0x40, 0x88, 0x72,
        0x8A, 0x8B, 0x69, 0x15, 0x52, 0xEA, 0x12, 0x45, 0xD9, 0xD6, 0x66, 0xB4,
        0x90, 0x1D, 0xAA, 0x37, 0xD6, 0xF9, 0xED, 0x5C, 0xCC, 0xE8, 0x81, 0x61,
        0xBA, 0x41, 0x81, 0xDE, 0xDB, 0xD6, 0x3A, 0xC3, 0x0D, 0x4F, 0xD5, 0x93,
        0x38, 0xBC, 0x9C, 0xCE, 0x45, 0x74, 0x0A, 0xAC, 0xFF, 0x85, 0x98, 0x9E,
        0xEF, 0x27, 0x47, 0xFA, 0xEA, 0xB3, 0x52, 0xBA, 0x8E, 0x64, 0x1E, 0xA3,
        0xB9, 0x8C, 0x8B, 0x18, 0x2D, 0xA4, 0xD0, 0x37, 0xB4, 0x15, 0xFA, 0x94,
        0xDB, 0x53, 0x1A, 0xD9, 0xEB, 0x95, 0x27, 0xB2, 0xF9, 0x91, 0x80, 0x12,
        0x00, 0x8C, 0xC6, 0xFB, 0x6D, 0xF9, 0x9E, 0x7A, 0xAD, 0x94, 0x36, 0x1D,
        0x16, 0xE5, 0x57, 0xD8, 0xFC, 0xE8, 0x80, 0xA9, 0xE6, 0x29, 0x6D, 0xF4,
        0x2C, 0x0A, 0x75, 0x3B, 0x74, 0x80, 0xB9, 0x1C, 0xCD, 0x1E, 0xE5, 0xAC,
        0x8F, 0x16, 0x94, 0xB6, 0x62, 0x67, 0xB8, 0xBE, 0x8D, 0x85, 0x2C, 0xB5,
        0x87, 0xA2, 0x0E, 0xED, 0xBD, 0x95, 0xCD, 0x8F, 0x06, 0x52, 0xCC, 0xFD,
        0x72, 0xD8, 0xE8, 0x18, 0x8C, 0xBB, 0x34, 0x74, 0xB0, 0xD9, 0xB1, 0x02,
        0x23, 0xE5, 0x0A, 0xD7, 0xA6, 0xE1, 0xE6, 0x15, 0x1B, 0x6D, 0x42, 0x5F,
        0xC5, 0x66, 0xBB, 0x47, 0xDE, 0xD3, 0x7D, 0x74, 0xE6, 0xA1, 0x61, 0x2A,
        0x3E, 0x10, 0x03, 0x2B, 0x7E, 0x16, 0x9B, 0x0D, 0x02, 0xD8, 0x39, 0x2E,
        0x1B, 0x56, 0x14, 0x6A, 0x1B, 0x2E, 0x54, 0xFF, 0x05, 0x30, 0xF7, 0x46,
        0x36, 0xDB, 0x2D, 0x30, 0xCD, 0xFD, 0xD2, 0x70, 0x63, 0x2E, 0x89, 0x81,
        0x13, 0x38, 0xE8, 0x73, 0xD8, 0x64, 0x50, 0xA0, 0x39, 0x60, 0xD8, 0x39,
        0xC5, 0x0E, 0xC3, 0xA2, 0xFA, 0x10, 0x9B, 0xEC, 0x0E, 0x9F, 0xC5, 0x71,
        0x1E, 0x27, 0xC2, 0x07, 0xDD, 0x75, 0x6F, 0x7F, 0x65, 0x8E, 0x44, 0x6A,
        0x2C, 0xF4, 0xCC, 0xF8, 0x73, 0xF6, 0xFF, 0x03, 0x5C, 0x7D, 0xFF, 0x68,
        0x18, 0x51, 0xDC, 0xFC, 0xAA, 0x6F, 0x65, 0x73, 0xDD, 0xA1, 0xC8, 0x4C,
        0x81, 0x3D, 0xBC, 0xF1, 0x70, 0x45, 0x3D, 0x07, 0x73, 0xF5, 0xDB, 0xD9,
        0x5C, 0xB0, 0xA0, 0xED, 0x18, 0x10, 0xFA, 0xCF, 0x4D, 0x13, 0x17, 0x1A,
        0xB6, 0x44, 0x56, 0xE2, 0xC2, 0xB6, 0xE3, 0x61, 0x0B, 0x32, 0xF3, 0x81,
        0xA6, 0x93, 0x39, 0x55, 0x12, 0x33, 0x90, 0x7D, 0x53, 0x53, 0x95, 0x60,
        0x73, 0x41, 0x03, 0x87, 0xD4, 0xD3, 0x86, 0xC9, 0x24, 0xED, 0x77, 0xA5,
        0x7E, 0x07, 0x9B, 0xEB, 0x06, 0x59, 0xA6, 0xAF, 0x6C, 0x2A, 0x88, 0xFD,
        0x9E, 0x30, 0x57, 0xB3, 0xA9, 0x28, 0x30, 0x4C, 0x36, 0x49, 0xDF, 0x43,
        0x51, 0x3F, 0xC1, 0xA6, 0xBA, 0x01, 0xCE, 0x1F, 0xB7, 0x34, 0x0E, 0x63,
        0xA8, 0x0E, 0xE6, 0xB9, 0xEE, 0xB3, 0xA9, 0x28, 0x40, 0x3D, 0xBC, 0x69,
        0x7B, 0x9D, 0x20, 0xE6, 0xDB, 0x6C, 0xAA, 0x0B, 0x2C, 0xAE, 0x01, 0x61,
        0xEE, 0x6F, 0x32, 0xA1, 0x53, 0xA3, 0xB0, 0x72, 0x77, 0xB1, 0xA1, 0x68,
        0x40, 0x97, 0xA2, 0x45, 0xA6, 0x77, 0x36, 0xD9, 0x1E, 0xB2, 0x42, 0x66,
        0xE5, 0x36, 0x36, 0xD5, 0x3E, 0xE8, 0x9A, 0x03, 0xE6, 0xD7, 0x8F, 0x37,
        0xA9, 0x9C, 0xED, 0x2D, 0xC2, 0x5C, 0xC3, 0xA6, 0xA2, 0x82, 0x10, 0xFA,
        0xC6, 0x26, 0xC3, 0x96, 0x8B, 0xAC, 0xF2, 0x4F, 0x68, 0xA2, 0x9B, 0x1B,
        0xBD, 0x69, 0x8B, 0x41, 0x64, 0xE6, 0xE9, 0xA6, 0x82, 0xE0, 0x22, 0x70,
        0x0B, 0x9B, 0x8A, 0x0A, 0x58, 0xEF, 0xAF, 0x35, 0x13, 0xA4, 0xC6, 0x4C,
        0xCB, 0x3C, 0x34, 0x31, 0x71, 0xFA, 0xAB, 0xD8, 0x54, 0xBB, 0xD8, 0xB8,
        0xB1, 0x5A, 0x4B, 0x2B, 0x50, 0xB7, 0x12, 0xF5, 0x57, 0x62, 0x29, 0x52,
        0x83, 0x70, 0xA1, 0xF4, 0x41, 0x36, 0x15, 0x15, 0x50, 0x90, 0x4B, 0x9B,
        0x08, 0x62, 0x3B, 0x6E, 0x56, 0x3E, 0xDA, 0xD9, 0xD5, 0xC4, 0xA2, 0xD0,
        0xC7, 0x53, 0x6E, 0xDD, 0x54, 0x10, 0xCC, 0xB0, 0xCE, 0x65, 0x53, 0x51,
        0x01, 0x57, 0xEE, 0x9F, 0x6B, 0x2A, 0x08, 0x0E, 0x77, 0x7F, 0xA5, 0x79,
        0x88, 0x4D, 0xB5, 0x8B, 0x24, 0x88, 0xBF, 0x6D, 0x4B, 0x31, 0x09, 0xD2,
        0x11, 0x92, 0x20, 0x81, 0x21, 0x09, 0x12, 0x18, 0x92, 0x20, 0x81, 0x21,
        0x09, 0x12, 0x18, 0x92, 0x20, 0x81, 0x21, 0x09, 0x12, 0x18, 0x92, 0x20,
        0x81, 0x21, 0x09, 0x12, 0x18, 0x92, 0x20, 0x81, 0x21, 0x09, 0x12, 0x18,
        0x82, 0x15, 0x84, 0x76, 0x7B, 0x87, 0x11, 0x64, 0x24, 0xB7, 0xC5, 0x74,
        0x80, 0x61, 0x76, 0x7B, 0x49, 0x90, 0x0E, 0x77, 0x7B, 0x8B, 0x63, 0x87,
        0xDB, 0x7E, 0xD7, 0x67, 0xB2, 0xA9, 0xA8, 0x80, 0x82, 0x7C, 0xAA, 0xA9,
        0x20, 0xB4, 0xFD, 0xCE, 0x66, 0x56, 0x06, 0x72, 0xB6, 0x52, 0xF5, 0x27,
        0x01, 0xEA, 0xAD, 0x74, 0xD9, 0x51, 0x66, 0xE6, 0x36, 0x74, 0xFE, 0xCF,
        0x25, 0xE8, 0x5F, 0x38, 0xE2, 0xCF, 0xF8, 0x37, 0x8C, 0x90, 0x17, 0x7C,
        0x85, 0x1F, 0x89, 0x24, 0xA2, 0x10, 0xE6, 0x3E, 0xA0, 0x63, 0x93, 0x5E,
        0xB4, 0x19, 0x3E, 0xA9, 0xBE, 0x20, 0xF4, 0x8E, 0x26, 0x9D, 0x90, 0x08,
        0x50, 0xEE, 0xC5, 0x76, 0xDF, 0x7C, 0xB8, 0x5D, 0xBA, 0x15, 0x4A, 0x88,
        0xEA, 0x76, 0xB4, 0x7B, 0x9D, 0x94, 0xFA, 0x3C, 0x96, 0xC1, 0xC1, 0xDE,
        0x6C, 0x0C, 0xFA, 0x77, 0xFD, 0xE2, 0x64, 0xDB, 0x93, 0xE9, 0xD2, 0x23,
        0xB1, 0x50, 0x0B, 0xFF, 0x45, 0x77, 0x49, 0xD2, 0x5F, 0xF0, 0x72, 0x48,
        0x3D, 0x86, 0xEC, 0x1F, 0x6E, 0x37, 0x68, 0x52, 0x64, 0x53, 0x4F, 0xF7,
        0xB4, 0x67, 0xB9, 0x5C, 0xCA, 0x97, 0xF6, 0xEF, 0x68, 0x9F, 0xFC, 0x8E,
        0xFE, 0xFF, 0x21, 0x4A, 0xE1, 0x6E, 0x36, 0xC7, 0xC9, 0xF6, 0xC7, 0xEE,
        0x8F, 0x7E, 0x83, 0x89, 0xDD, 0xD3, 0xFA, 0x5F, 0x98, 0x8B, 0xEC, 0x6D,
        0x2E, 0x4D, 0xC3, 0x31, 0xB1, 0x3D, 0xDA, 0x04, 0x20, 0xD3, 0x3B, 0x27,
        0xF0, 0x97, 0xBB, 0x93, 0x20, 0xA1, 0xB0, 0x3C, 0x30, 0x91, 0xC4, 0x08,
        0x8B, 0x14, 0x21, 0xDE, 0x7F, 0x24, 0x8E, 0x87, 0x49, 0x90, 0xC0, 0x98,
        0x04, 0x09, 0x8C, 0x49, 0x90, 0xC0, 0x98, 0x04, 0x09, 0x8C, 0x91, 0x0B,
        0xF2, 0xD2, 0x79, 0xBC, 0x8E, 0xEE, 0x88, 0xA6, 0x61, 0x1E, 0xD8, 0x1C,
        0x37, 0x23, 0x14, 0xA4, 0x5A, 0x2C, 0x78, 0xCB, 0x01, 0x7F, 0x3F, 0x44,
        0x8B, 0x29, 0x99, 0x95, 0xF7, 0xC8, 0xCC, 0xFC, 0x01, 0x7F, 0xBE, 0x17,
        0xEC, 0x51, 0x4D, 0xEE, 0xD9, 0x77, 0x12, 0xE9, 0x7F, 0xBF, 0x1F, 0x36,
        0xA3, 0x12, 0xC4, 0xED, 0x2B, 0x61, 0xEF, 0x97, 0xE6, 0x26, 0x05, 0xF5,
        0x39, 0x42, 0x54, 0x39, 0x3D, 0x0B, 0x68, 0xF7, 0x7F, 0x18, 0x52, 0x2E,
        0xBC, 0x0E, 0xA0, 0x9A, 0x56, 0xC2, 0x7C, 0x4C, 0x09, 0xFD, 0x6B, 0xBB,
        0x7F, 0x16, 0x91, 0x30, 0x51, 0x08, 0x42, 0x22, 0x58, 0x31, 0xC0, 0xFC,
        0x94, 0x0E, 0x8E, 0x61, 0xDF, 0x2F, 0x0B, 0x4A, 0x95, 0x9B, 0x01, 0xCC,
        0x1D, 0x2F, 0x8A, 0xE9, 0xB1, 0x1F, 0x12, 0x83, 0x17, 0x84, 0x7A, 0xB8,
        0x9D, 0x17, 0x44, 0x7D, 0x3E, 0xFB, 0xB8, 0x11, 0x50, 0xCC, 0x8B, 0x69,
        0x08, 0x0B, 0x5D, 0x94, 0xA0, 0x05, 0x51, 0x38, 0x17, 0xD8, 0x87, 0x5E,
        0x44, 0x3B, 0x07, 0x19, 0x4B, 0xA1, 0x2F, 0x28, 0xF2, 0xB0, 0x87, 0xAF,
        0xA0, 0x05, 0xA1, 0x61, 0x06, 0x87, 0x9B, 0x8B, 0xD9, 0x9F, 0xAD, 0x80,
        0x1E, 0xAB, 0x23, 0xBB, 0xBE, 0xF2, 0x42, 0x60, 0xB0, 0x82, 0xB8, 0x0C,
        0xA9, 0x7C, 0x00, 0x7D, 0xD8, 0xEA, 0x09, 0x41, 0x74, 0x96, 0x15, 0x8A,
        0xB2, 0xCB, 0xA5, 0xC7, 0xFE, 0xB2, 0xC7, 0xC9, 0x60, 0x05, 0xE1, 0xE8,
        0xF8, 0x28, 0xFB, 0xB1, 0x55, 0x00, 0xE8, 0x2F, 0x84, 0x1A, 0x25, 0x41,
        0x0A, 0x42, 0x13, 0x2F, 0x08, 0xFD, 0x42, 0xDE, 0xD1, 0x89, 0x0F, 0x00,
        0x73, 0x9B, 0x52, 0x84, 0xAC, 0x80, 0xE4, 0x2C, 0x10, 0xE5, 0x53, 0x74,
        0xE3, 0x05, 0xFB, 0xB0, 0x55, 0xD0, 0x51, 0xB2, 0x38, 0x1C, 0xEE, 0x0B,
        0x31, 0xE3, 0x0A, 0x58, 0x10, 0xF3, 0x37, 0x7A, 0x2E, 0x9E, 0x7D, 0xD8,
        0x2A, 0xA6, 0xA6, 0xE6, 0xDF, 0x44, 0x07, 0x30, 0x27, 0x41, 0x96, 0x49,
        0x3B, 0x64, 0x81, 0xD9, 0xA3, 0xD6, 0xCF, 0xBE, 0x99, 0x7D, 0xD8, 0x2A,
        0xD4, 0x54, 0xB9, 0x51, 0x0E, 0x71, 0xA2, 0x51, 0x97, 0x0C, 0x76, 0x52,
        0xB7, 0x8B, 0xB8, 0x4C, 0xBF, 0x8B, 0x7D, 0xD8, 0x2A, 0xE8, 0x0E, 0xCA,
        0x34, 0xA9, 0xAF, 0x90, 0xE4, 0x30, 0x21, 0xF4, 0x8D, 0xEC, 0xC3, 0x56,
        0x41, 0xF7, 0xA0, 0x85, 0xBA, 0xF1, 0x18, 0xAC, 0x20, 0x44, 0xB7, 0x4A,
        0x6F, 0xF7, 0x60, 0x62, 0x80, 0xF2, 0x0C, 0xBA, 0x51, 0xCD, 0x57, 0x5E,
        0x08, 0x0C, 0x5E, 0x10, 0x25, 0xCD, 0x13, 0x6D, 0x9D, 0xE5, 0x0B, 0x30,
        0x33, 0x8D, 0xF3, 0xD3, 0x73, 0xA1, 0xA6, 0xBC, 0xC4, 0xA0, 0x05, 0x21,
        0xD2, 0xD6, 0x39, 0x8E, 0xF9, 0x0F, 0xE1, 0xDA, 0x81, 0x5E, 0x9F, 0xDA,
        0x18, 0x42, 0x54, 0x15, 0xBD, 0x12, 0x2F, 0xF4, 0x6B, 0x24, 0xC1, 0x0B,
        0x42, 0xB4, 0xD7, 0x33, 0x64, 0xF5, 0x2C, 0x5D, 0x03, 0x61, 0xFF, 0x2E,
        0x1B, 0xF4, 0x76, 0x04, 0x29, 0xAA, 0x2D, 0x74, 0xB4, 0x60, 0xE8, 0x62,
        0x10, 0xA3, 0x10, 0x84, 0x48, 0xC3, 0x0C, 0x4D, 0xF4, 0x18, 0x2D, 0x7F,
        0x24, 0x61, 0xE8, 0xE1, 0x21, 0xF6, 0xB9, 0x17, 0x85, 0x7D, 0x83, 0x68,
        0x75, 0x81, 0x3B, 0x46, 0x3C, 0x8E, 0x6B, 0x21, 0xC4, 0x68, 0x04, 0x19,
        0x90, 0x7A, 0xF9, 0x49, 0xFD, 0x53, 0x69, 0x9D, 0x72, 0x2D, 0xFB, 0xDE,
        0x0B, 0x00, 0xFD, 0xAB, 0x8D, 0xFD, 0x53, 0xEC, 0x3C, 0xE4, 0xB3, 0x13,
        0x2A, 0xA3, 0x13, 0x84, 0xE8, 0x52, 0xE2, 0xB9, 0xEF, 0xB1, 0xEF, 0xBD,
        0xA0, 0x67, 0x2F, 0x62, 0x18, 0xA2, 0x0E, 0x67, 0xB4, 0x82, 0x48, 0xA1,
        0xBF, 0xC3, 0xBE, 0xF7, 0x02, 0x3F, 0x77, 0x6B, 0x12, 0x64, 0x44, 0x4C,
        0x82, 0x04, 0xC6, 0x24, 0x48, 0x60, 0x4C, 0x82, 0x04, 0xC6, 0x24, 0x48,
        0x60, 0x4C, 0x82, 0x04, 0x46, 0x12, 0x04, 0x84, 0xFE, 0x16, 0xFB, 0xDE,
        0x0B, 0x25, 0xCC, 0xCD, 0x49, 0x90, 0x11, 0x91, 0xEE, 0xAD, 0xC2, 0x85,
        0xDF, 0xD6, 0x3C, 0x9F, 0x9F, 0x5C, 0x8A, 0xF4, 0xF6, 0xCD, 0x24, 0xC8,
        0x48, 0x59, 0x1E, 0x90, 0xA0, 0xF7, 0xE3, 0xCF, 0x1E, 0xDA, 0xBF, 0x1F,
        0x44, 0x7A, 0xBE, 0x17, 0x36, 0x23, 0x16, 0xC4, 0x5D, 0xEA, 0x5D, 0x8A,
        0xBE, 0xCF, 0xC7, 0xC0, 0xA8, 0x05, 0x59, 0x8D, 0x4C, 0x82, 0x04, 0xC6,
        0x24, 0x48, 0x60, 0x4C, 0x07, 0x07, 0x04, 0x46, 0x8C, 0x90, 0xF2, 0xEF,
        0x31, 0x3F, 0x93, 0xB7, 0xCA, 0x78, 0x88, 0xDE, 0x1E, 0xB3, 0x25, 0x0F,
        0xF8, 0xA2, 0xFF, 0x2B, 0x87, 0x36, 0x28, 0x9E, 0xA3, 0x45, 0xED, 0x51,
        0xF4, 0xB0, 0xA4, 0xDD, 0x8E, 0xF0, 0x7E, 0x30, 0x71, 0x14, 0xA4, 0x17,
        0x23, 0x0B, 0x61, 0xDC, 0x45, 0xB7, 0x9E, 0x9A, 0x9D, 0x55, 0xCA, 0xEC,
        0x8E, 0x71, 0x65, 0xBB, 0x1A, 0x68, 0xB7, 0x82, 0x40, 0xEF, 0xD8, 0xB0,
        0xA1, 0x5A, 0x6B, 0x05, 0x21, 0x64, 0xD9, 0x6C, 0x8D, 0xFF, 0xDC, 0x41,
        0x4A, 0xC5, 0x76, 0x1D, 0x3A, 0x56, 0x52, 0x00, 0x90, 0xBF, 0x95, 0xD4,
        0xDB, 0xBD, 0xF7, 0x9E, 0xF1, 0x7B, 0xC5, 0x2F, 0xA1, 0x3B, 0x35, 0x70,
        0x18, 0xDB, 0x2D, 0x41, 0x1F, 0xF0, 0x19, 0x4A, 0x1C, 0x8E, 0x20, 0xEC,
        0xB9, 0x95, 0xCF, 0x2A, 0x69, 0x7E, 0xAF, 0xDC, 0x43, 0x49, 0xFC, 0x94,
        0xD8, 0xC4, 0xC4, 0x7F, 0x00, 0xF7, 0x80, 0x2E, 0xC9, 0x47, 0x03, 0x2C,
        0xE5, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45, 0x4E, 0x44, 0xAE, 0x42, 0x60,
        0x82
};

const char Html_png4[] = { 0x89, 0x50, 0x4E, 0x47, 0x0D, 0x0A, 0x1A, 0x0A, 0x00,
        0x00, 0x00, 0x0D, 0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x64, 0x00,
        0x00, 0x00, 0x64, 0x08, 0x06, 0x00, 0x00, 0x00, 0x70, 0xE2, 0x95, 0x54,
        0x00, 0x00, 0x00, 0x01, 0x73, 0x52, 0x47, 0x42, 0x00, 0xAE, 0xCE, 0x1C,
        0xE9, 0x00, 0x00, 0x00, 0x04, 0x67, 0x41, 0x4D, 0x41, 0x00, 0x00, 0xB1,
        0x8F, 0x0B, 0xFC, 0x61, 0x05, 0x00, 0x00, 0x00, 0x09, 0x70, 0x48, 0x59,
        0x73, 0x00, 0x00, 0x0E, 0xC3, 0x00, 0x00, 0x0E, 0xC3, 0x01, 0xC7, 0x6F,
        0xA8, 0x64, 0x00, 0x00, 0x10, 0x63, 0x49, 0x44, 0x41, 0x54, 0x78, 0x5E,
        0xED, 0x5D, 0x09, 0x90, 0x1C, 0x55, 0x19, 0xCE, 0x06, 0x15, 0x39, 0x3C,
        0x50, 0x94, 0x2B, 0x26, 0x64, 0xA7, 0x5F, 0xBF, 0x9E, 0xC9, 0x45, 0x32,
        0x7D, 0xCC, 0x26, 0x48, 0xC0, 0x42, 0xA4, 0x0A, 0x91, 0xCB, 0xA8, 0x08,
        0xC5, 0x21, 0x47, 0x51, 0x28, 0x02, 0x2A, 0x8A, 0x5A, 0x22, 0x14, 0x20,
        0x72, 0x08, 0x05, 0x72, 0x6A, 0x21, 0x06, 0x04, 0x14, 0x01, 0x11, 0x29,
        0x04, 0xCB, 0x82, 0x02, 0x44, 0x90, 0xC3, 0x70, 0x84, 0x33, 0x80, 0x84,
        0x04, 0x10, 0x08, 0x10, 0x49, 0xA8, 0xDC, 0x1B, 0xBF, 0xEF, 0x7F, 0xAF,
        0xB3, 0x47, 0x7A, 0xB3, 0x33, 0x7D, 0xCC, 0xCE, 0x64, 0xF7, 0xAF, 0xFA,
        0x6B, 0x32, 0x9B, 0x7E, 0x7F, 0xFF, 0xF7, 0xFF, 0xBF, 0xD7, 0xFD, 0xDE,
        0x8C, 0x6A, 0x77, 0xD0, 0x3A, 0xDA, 0x15, 0x78, 0xB6, 0xA7, 0xA2, 0x3B,
        0xB4, 0x13, 0x3E, 0xA4, 0x5D, 0xFF, 0x36, 0x7C, 0x3F, 0xB5, 0xAC, 0xA2,
        0xC8, 0x5E, 0x32, 0x02, 0x45, 0x83, 0xD6, 0x81, 0x0F, 0xA5, 0x5F, 0xEC,
        0xBA, 0xE1, 0x3C, 0xED, 0x06, 0xAB, 0x3D, 0x1D, 0xAD, 0x25, 0x6A, 0xD7,
        0x7C, 0x12, 0x5D, 0x15, 0xAE, 0x70, 0xDD, 0x68, 0xAE, 0xE7, 0x45, 0x67,
        0x7A, 0x5E, 0xE0, 0xDA, 0xA1, 0x23, 0x90, 0x27, 0x94, 0x3B, 0x23, 0xA5,
        0x75, 0xED, 0xF7, 0x9E, 0xAE, 0xAD, 0xAD, 0x94, 0x67, 0x40, 0xF1, 0x35,
        0x18, 0x21, 0x1C, 0x00, 0xA3, 0xB5, 0x65, 0x2F, 0xBE, 0x2E, 0x5C, 0x56,
        0xD6, 0xE1, 0x25, 0xE3, 0xC7, 0x47, 0xDB, 0x58, 0x52, 0x23, 0x90, 0x15,
        0x90, 0x92, 0x8E, 0xF6, 0x54, 0xF8, 0x5E, 0xA5, 0x3C, 0x5D, 0x94, 0x9D,
        0x6C, 0x84, 0x64, 0x64, 0xC4, 0x4C, 0xA8, 0x88, 0x61, 0x16, 0xBA, 0xA5,
        0x70, 0x1F, 0x4B, 0x72, 0x04, 0xD2, 0x82, 0x76, 0xA2, 0x8B, 0x69, 0x88,
        0x0D, 0x47, 0xC4, 0xE0, 0xC8, 0x88, 0x29, 0x7B, 0x5D, 0x6B, 0x5D, 0x37,
        0x38, 0xD9, 0x92, 0x1E, 0x81, 0x46, 0x41, 0xA9, 0xF0, 0x77, 0xF4, 0xEE,
        0x24, 0x05, 0xA7, 0x41, 0x46, 0x0B, 0xD3, 0x18, 0x8C, 0x72, 0xA6, 0xBD,
        0xC5, 0x08, 0xD4, 0x0B, 0x50, 0xDA, 0xE5, 0x79, 0x1A, 0xA3, 0x07, 0xAD,
        0x51, 0x9C, 0xF0, 0xFB, 0xF6, 0x56, 0x23, 0x30, 0x18, 0x68, 0xC7, 0x3F,
        0x9E, 0x4A, 0x4B, 0x56, 0x68, 0x76, 0x64, 0xA4, 0x30, 0x7D, 0xE1, 0x3E,
        0x7B, 0xDB, 0x5B, 0x8E, 0xC0, 0x40, 0xE0, 0x95, 0xA6, 0x4D, 0x83, 0xC2,
        0xD6, 0x50, 0x69, 0x49, 0xCA, 0xCC, 0x0B, 0x59, 0x53, 0x5C, 0x15, 0x2D,
        0xF2, 0xBC, 0x69, 0xDB, 0xD9, 0x5B, 0x8F, 0x40, 0x7F, 0x98, 0x35, 0x6A,
        0xD6, 0x26, 0x50, 0xD6, 0x9C, 0x4A, 0x19, 0xDE, 0x9B, 0xA0, 0xC4, 0xBC,
        0xD1, 0x46, 0xE1, 0xCD, 0xF6, 0xF6, 0x23, 0xD0, 0x1F, 0x94, 0x0A, 0x8E,
        0x9B, 0x50, 0x60, 0xAA, 0x4A, 0x42, 0x69, 0xA5, 0x75, 0xF0, 0x05, 0xCB,
        0xC2, 0x08, 0xC4, 0xE0, 0x38, 0xE1, 0x47, 0xA1, 0xA0, 0x37, 0xB3, 0xB6,
        0xB7, 0x8D, 0xA2, 0xD4, 0x12, 0xD7, 0x7F, 0x0C, 0x2C, 0x74, 0x18, 0x4E,
        0x86, 0x01, 0x4C, 0x9E, 0x3C, 0x79, 0x8B, 0x6A, 0xB5, 0xBA, 0xB9, 0xFD,
        0x9A, 0x08, 0x5A, 0x85, 0x27, 0x15, 0x59, 0xC8, 0x37, 0x84, 0x8C, 0x12,
        0xD7, 0x5D, 0x37, 0x69, 0x1C, 0xED, 0x79, 0xC1, 0x27, 0xB5, 0x0E, 0x77,
        0x43, 0xA7, 0x77, 0x24, 0xFE, 0x7E, 0xA2, 0xEB, 0x46, 0xC7, 0x6A, 0x5D,
        0xDB, 0x5B, 0x29, 0xBF, 0xD3, 0x5E, 0xD3, 0x5E, 0xE0, 0xBA, 0xD5, 0xAD,
        0x3D, 0xAF, 0x76, 0xA8, 0xE7, 0x46, 0xD7, 0x6A, 0x27, 0x78, 0x1C, 0x1E,
        0xB8, 0x10, 0xB8, 0x00, 0x2D, 0xE7, 0x63, 0x5A, 0x47, 0x57, 0x7B, 0x5E,
        0xD7, 0x81, 0xE3, 0xC6, 0x4D, 0xF9, 0xB8, 0xBD, 0x1C, 0xD1, 0xE1, 0x6C,
        0x8A, 0x74, 0xF5, 0x32, 0x0B, 0x6D, 0x7F, 0x65, 0x35, 0x03, 0x59, 0xB3,
        0xA0, 0xF8, 0x7B, 0xC8, 0x8B, 0xD7, 0xE9, 0x4F, 0x74, 0x55, 0xF8, 0x0E,
        0x23, 0x87, 0x86, 0x8A, 0x91, 0xDF, 0x31, 0xDB, 0x5F, 0x0E, 0xFE, 0xEF,
        0x05, 0x1E, 0x0E, 0x07, 0xFB, 0xA0, 0x30, 0xDF, 0xCA, 0x50, 0xA9, 0x54,
        0xB6, 0x04, 0xB3, 0xA7, 0x81, 0xF1, 0x37, 0xFA, 0x0A, 0x52, 0x13, 0xEC,
        0x2D, 0x24, 0x3A, 0x9C, 0xD7, 0xB4, 0x0A, 0x4E, 0xE5, 0x38, 0x78, 0xE4,
        0x17, 0x9B, 0x55, 0xC8, 0x93, 0xD1, 0x2E, 0x4A, 0xBA, 0x5D, 0x9E, 0x38,
        0x87, 0x13, 0xBE, 0x96, 0xE4, 0x1C, 0x71, 0xBB, 0x4C, 0xFE, 0x3D, 0x15,
        0x3E, 0xD1, 0xD2, 0xB5, 0x07, 0x1E, 0xBE, 0x0B, 0x0C, 0xF1, 0x8C, 0x59,
        0x37, 0x1A, 0xDC, 0xD3, 0xCD, 0xA4, 0x4F, 0x72, 0x37, 0xD3, 0xD5, 0x0D,
        0x14, 0x32, 0xE9, 0xBA, 0x66, 0xA1, 0x9D, 0xC1, 0xFF, 0x4C, 0xF8, 0x71,
        0x02, 0x59, 0xAE, 0x49, 0xBA, 0x2E, 0x46, 0x1A, 0x86, 0x18, 0x3B, 0x55,
        0x4B, 0x81, 0xEB, 0xFA, 0x07, 0x83, 0xC9, 0x55, 0xC2, 0x60, 0x02, 0xF3,
        0x49, 0x48, 0x81, 0x95, 0x8A, 0x8E, 0x9E, 0x35, 0x8B, 0xAD, 0x6E, 0xB0,
        0xB8, 0xE8, 0x79, 0xC7, 0x60, 0x48, 0xDE, 0x21, 0xC7, 0x53, 0x94, 0xC7,
        0x73, 0xC2, 0x3D, 0xEA, 0x91, 0x85, 0x3C, 0xD3, 0xB1, 0x90, 0xEE, 0x2E,
        0x13, 0x45, 0xB4, 0x02, 0xB8, 0x8E, 0x7F, 0x30, 0x99, 0x6F, 0xAC, 0x3B,
        0x12, 0xE5, 0xAF, 0x99, 0x38, 0x3E, 0xDA, 0x86, 0x91, 0xD5, 0x88, 0x21,
        0x8B, 0x43, 0x79, 0xA6, 0xD2, 0x8D, 0x94, 0xBB, 0x23, 0x9B, 0x10, 0xE5,
        0x04, 0x4B, 0xEA, 0x75, 0x92, 0x09, 0x95, 0x9D, 0xD7, 0x42, 0x0F, 0xE7,
        0x59, 0x95, 0x0C, 0x1D, 0xB8, 0x9D, 0xB5, 0x19, 0x60, 0x7A, 0x75, 0xA3,
        0xAD, 0x2A, 0xF3, 0x33, 0xF2, 0xF4, 0x73, 0xA4, 0xA1, 0x95, 0x7F, 0xF6,
        0x50, 0xA7, 0xAB, 0x18, 0xC9, 0x07, 0xBC, 0xFD, 0x08, 0x91, 0xCD, 0x0D,
        0x1E, 0xAC, 0xDF, 0x51, 0xB8, 0x3E, 0x86, 0xB1, 0x70, 0x4E, 0x8E, 0x1D,
        0x12, 0x60, 0x97, 0x04, 0x46, 0x5E, 0x49, 0xE3, 0xDD, 0xC6, 0x00, 0xFE,
        0x6C, 0xD2, 0xC1, 0xF7, 0x7B, 0x5A, 0x23, 0x42, 0x62, 0x83, 0x04, 0xBF,
        0x21, 0x5F, 0x4C, 0x43, 0x8D, 0x38, 0x0A, 0x9D, 0x12, 0xDD, 0xD9, 0x92,
        0xF2, 0x8E, 0x53, 0xC7, 0x71, 0x7C, 0xD3, 0x01, 0xA9, 0xE6, 0xCA, 0xB4,
        0xAB, 0xB1, 0x46, 0x70, 0xFF, 0x58, 0xD2, 0x81, 0x61, 0xDE, 0x68, 0x34,
        0xC2, 0x8A, 0x42, 0x3A, 0x06, 0x22, 0xF7, 0x61, 0xF2, 0x45, 0xFE, 0x1A,
        0x31, 0x08, 0x51, 0xE6, 0x51, 0x2A, 0xB8, 0x85, 0xE3, 0x9B, 0x0A, 0x7C,
        0xAE, 0x6D, 0xDA, 0xC2, 0x74, 0x85, 0x58, 0x22, 0x42, 0xFB, 0xD3, 0xF9,
        0x58, 0x15, 0xDF, 0xBB, 0xD3, 0xD2, 0xC9, 0x1B, 0x6D, 0xCD, 0x78, 0x13,
        0x22, 0x76, 0x20, 0x42, 0x3E, 0x97, 0x26, 0x72, 0xC5, 0xA8, 0x2A, 0xFC,
        0xAC, 0xD1, 0x54, 0x93, 0x00, 0x6D, 0xE1, 0xED, 0x8D, 0x7A, 0x4F, 0x8C,
        0x56, 0xE8, 0x35, 0x9C, 0x3C, 0x02, 0x67, 0xB4, 0x4A, 0xBA, 0x22, 0xC6,
        0xBC, 0x55, 0x2A, 0xC1, 0xB6, 0x95, 0x52, 0xCD, 0x31, 0x8E, 0xD2, 0x98,
        0xB3, 0xD8, 0xB4, 0xF7, 0x37, 0xAB, 0xAA, 0xE2, 0x01, 0xD6, 0x9F, 0x62,
        0x52, 0x4C, 0x63, 0x8C, 0xC6, 0x28, 0x42, 0x3B, 0xE1, 0x5B, 0xA4, 0xE5,
        0xA9, 0xEA, 0x81, 0x69, 0x0D, 0x5B, 0x14, 0x52, 0x36, 0xCF, 0x8B, 0xAA,
        0x66, 0x6D, 0x2D, 0x58, 0x6E, 0x8D, 0xD4, 0x10, 0x72, 0x4C, 0xA9, 0x14,
        0x4C, 0x10, 0x85, 0x15, 0x0D, 0xB0, 0xFE, 0x2F, 0xB3, 0x28, 0x51, 0x3A,
        0x2C, 0xE5, 0x3F, 0x4F, 0x5A, 0x48, 0x7D, 0xDF, 0x6E, 0x35, 0x83, 0x98,
        0x74, 0x2A, 0x33, 0xF0, 0x0E, 0xD4, 0x93, 0x45, 0x69, 0x0C, 0x62, 0x6A,
        0x89, 0x7F, 0x36, 0x65, 0x2C, 0x14, 0xC6, 0x8D, 0x9B, 0xF9, 0x61, 0xF4,
        0xE7, 0xAF, 0x66, 0x29, 0xC2, 0x14, 0xD8, 0x55, 0xC1, 0xA3, 0xA4, 0x87,
        0x3C, 0x7D, 0x4A, 0xAB, 0x19, 0xC4, 0xA6, 0x9C, 0xAF, 0x90, 0x3F, 0x64,
        0x81, 0x05, 0x69, 0x64, 0xED, 0x69, 0xEB, 0x67, 0x6D, 0x42, 0x3A, 0x85,
        0x81, 0xE7, 0xF8, 0x33, 0xB3, 0xE6, 0x7C, 0x19, 0xEF, 0x04, 0xF7, 0x91,
        0x1E, 0x04, 0x3F, 0xB3, 0x15, 0x0D, 0x82, 0x0E, 0xF2, 0x50, 0xE1, 0x4F,
        0x85, 0xF3, 0xD3, 0x39, 0x9F, 0x7D, 0x79, 0x4F, 0xD7, 0x26, 0x91, 0x4E,
        0x61, 0xE0, 0x96, 0xC2, 0xD3, 0xB3, 0x2A, 0xD0, 0x18, 0xD4, 0xBF, 0x57,
        0xE8, 0xB5, 0xAE, 0x41, 0x0E, 0x13, 0xFE, 0x52, 0x1B, 0x24, 0x8E, 0x34,
        0xD3, 0xDA, 0x17, 0x06, 0x28, 0xC6, 0x7F, 0xCF, 0xBA, 0x2A, 0xDB, 0xD7,
        0x20, 0xAD, 0x9A, 0xB2, 0xFC, 0xAF, 0x8A, 0xBC, 0x6E, 0xB0, 0x30, 0x9B,
        0x41, 0xC2, 0xAB, 0x48, 0xA7, 0x10, 0x60, 0xFD, 0x80, 0x22, 0x53, 0xE5,
        0xD4, 0xDE, 0x48, 0x83, 0xA0, 0xA8, 0x3F, 0x42, 0x9A, 0x5A, 0x47, 0xC7,
        0xB7, 0x9C, 0x41, 0xC0, 0x1F, 0x22, 0x77, 0x4F, 0xB0, 0x37, 0x5A, 0x39,
        0xFE, 0xDB, 0x69, 0x8A, 0x3A, 0x91, 0x72, 0x82, 0xCE, 0x83, 0x94, 0xB3,
        0x10, 0x80, 0xB5, 0xC7, 0x83, 0xC1, 0x55, 0x69, 0x19, 0x8C, 0xD1, 0x16,
        0xBC, 0x67, 0x49, 0x13, 0xDD, 0xCC, 0x41, 0xAD, 0x66, 0x10, 0x3A, 0x1C,
        0xDB, 0xDE, 0xCE, 0xCE, 0xEA, 0xC7, 0xD0, 0xC0, 0xAC, 0x48, 0x2B, 0xAF,
        0x71, 0x5C, 0x7F, 0x21, 0x1D, 0x59, 0x14, 0x98, 0x37, 0x70, 0x66, 0x9D,
        0x35, 0x3A, 0x88, 0x46, 0x40, 0xFF, 0x0D, 0x90, 0xEC, 0x28, 0xAB, 0xAE,
        0x16, 0x59, 0xE9, 0x35, 0x68, 0x95, 0xBF, 0xA6, 0x32, 0x2E, 0xD8, 0x16,
        0xF2, 0xEA, 0x2C, 0xCE, 0xC7, 0xB1, 0x30, 0xE8, 0x52, 0x4E, 0x32, 0x8D,
        0x06, 0x73, 0x06, 0x44, 0xC8, 0x3E, 0x79, 0x28, 0xCF, 0x30, 0x1A, 0xAE,
        0x74, 0x9C, 0x9D, 0x3E, 0x85, 0xC9, 0xD7, 0x18, 0xFC, 0x6D, 0x4D, 0xDA,
        0x49, 0x66, 0xDE, 0x28, 0x06, 0x30, 0x93, 0xD6, 0x0E, 0xCE, 0x45, 0xB2,
        0xC8, 0x6B, 0x8D, 0xD9, 0x5D, 0xD8, 0x76, 0x08, 0x30, 0xF8, 0xF5, 0xBC,
        0xD2, 0x0B, 0xD3, 0x96, 0xE7, 0x84, 0x35, 0x90, 0xED, 0xC0, 0xCC, 0xFF,
        0xF5, 0x3C, 0x22, 0x2F, 0x0F, 0xEC, 0x5D, 0xDF, 0x90, 0xFF, 0xBF, 0x93,
        0x4D, 0x5E, 0xB4, 0xBE, 0x40, 0xAE, 0x6C, 0x90, 0x5E, 0xEE, 0x80, 0x08,
        0x39, 0x22, 0x2F, 0x83, 0x90, 0x0E, 0x04, 0x3E, 0x92, 0x74, 0xD1, 0x62,
        0xDE, 0xDD, 0x2A, 0x69, 0xCB, 0xF0, 0x15, 0xFE, 0x96, 0x7C, 0x21, 0xAD,
        0xCE, 0xCE, 0xC7, 0x20, 0xC1, 0x4E, 0xA4, 0x97, 0x3B, 0xC0, 0xD2, 0x87,
        0xE4, 0x6B, 0x10, 0xF3, 0xD8, 0x53, 0xAB, 0xF0, 0xE7, 0x79, 0xD1, 0xCD,
        0x8A, 0xE4, 0xC3, 0x53, 0xC1, 0x51, 0x22, 0xAF, 0x13, 0x3C, 0x91, 0x43,
        0xCA, 0x2A, 0x6E, 0x4D, 0x0B, 0xB9, 0xF5, 0xCB, 0x79, 0x79, 0x32, 0xE9,
        0xC4, 0xCB, 0x27, 0x48, 0x11, 0xBB, 0xB7, 0x4A, 0x84, 0x50, 0x89, 0xEC,
        0x26, 0x2B, 0x95, 0xDA, 0x27, 0x50, 0xE7, 0x52, 0x77, 0x58, 0x44, 0x8E,
        0x65, 0x97, 0x56, 0xE9, 0xAC, 0x8E, 0x15, 0x05, 0xE6, 0x0D, 0x60, 0x34,
        0xD5, 0xF3, 0x81, 0x24, 0x64, 0x28, 0xE3, 0x73, 0x79, 0x67, 0x67, 0xD7,
        0xA7, 0xCD, 0xFA, 0x18, 0x17, 0xF1, 0x86, 0xB6, 0x8E, 0x88, 0x6C, 0x4E,
        0xF0, 0x0C, 0x65, 0xD5, 0x3A, 0x9C, 0x95, 0x35, 0x6A, 0x8D, 0x41, 0xC2,
        0x45, 0x6C, 0x9F, 0x45, 0x81, 0x79, 0x83, 0x52, 0x51, 0x19, 0x37, 0xCA,
        0xED, 0x61, 0x92, 0x49, 0x5B, 0x91, 0x3C, 0x83, 0x46, 0x3D, 0xB9, 0x6E,
        0xA8, 0xD3, 0x56, 0xEF, 0x15, 0x5A, 0x57, 0x85, 0xD7, 0x66, 0xE5, 0x87,
        0x8D, 0x8B, 0x7D, 0x8B, 0xA5, 0x98, 0x57, 0x54, 0xCD, 0x44, 0x29, 0xFD,
        0xCC, 0xB5, 0x3F, 0x1A, 0x83, 0x98, 0x37, 0xCF, 0xB3, 0xB6, 0x98, 0x79,
        0x20, 0x23, 0x14, 0x6D, 0x78, 0x05, 0xF0, 0xA1, 0x3C, 0x22, 0xD6, 0xCA,
        0x77, 0xAB, 0x28, 0xAF, 0x28, 0xE0, 0x5E, 0xF0, 0xDC, 0xD2, 0x96, 0xC9,
        0xB1, 0x4B, 0x98, 0xAF, 0x41, 0x7A, 0x34, 0x6A, 0xCA, 0xBC, 0xA1, 0x32,
        0x0A, 0xEF, 0x0B, 0x6F, 0x7E, 0x40, 0x64, 0xCC, 0x21, 0x5D, 0x11, 0x85,
        0x86, 0x0A, 0x4E, 0x23, 0xCD, 0xC2, 0x00, 0x1D, 0xD1, 0xA5, 0x79, 0x30,
        0x1B, 0xA3, 0xF5, 0xA2, 0x6F, 0x1A, 0xDA, 0xCD, 0xDF, 0x8A, 0x10, 0xA3,
        0xC8, 0xE4, 0x44, 0x07, 0x90, 0x8F, 0xBC, 0xDA, 0x70, 0xD2, 0xE0, 0x0B,
        0x77, 0xA4, 0x59, 0x18, 0x68, 0xC7, 0x3F, 0x20, 0x4F, 0x83, 0x58, 0xCF,
        0x94, 0xB7, 0x05, 0xB7, 0xDB, 0xAE, 0xBA, 0x39, 0x22, 0xE6, 0x55, 0xE6,
        0xDE, 0xA4, 0x6B, 0x8B, 0x42, 0xA3, 0x7C, 0xFF, 0x69, 0x91, 0x4F, 0xD7,
        0x26, 0xE5, 0xB5, 0x3C, 0x84, 0x88, 0x7F, 0x77, 0xCA, 0xB8, 0x9E, 0x17,
        0xCA, 0x0B, 0x01, 0xBE, 0xA6, 0x8F, 0x3A, 0xF2, 0x5E, 0x5E, 0x75, 0x84,
        0x58, 0xF1, 0x24, 0x4A, 0xF6, 0x25, 0x7D, 0x7C, 0x62, 0xF2, 0xD9, 0xDC,
        0x28, 0xB1, 0x51, 0x2A, 0x5B, 0x11, 0xA0, 0xC4, 0x1B, 0xF3, 0x70, 0x38,
        0x4B, 0xF3, 0x26, 0xD2, 0x2C, 0x1C, 0xD0, 0x11, 0xE5, 0xC2, 0x74, 0x8C,
        0xE2, 0xA1, 0x8E, 0xFF, 0xB8, 0x25, 0xCF, 0x0E, 0xE7, 0x9F, 0x79, 0xD2,
        0xDF, 0x10, 0xF2, 0x3E, 0x98, 0xF0, 0xDE, 0xC1, 0xFB, 0x3A, 0x8E, 0x3F,
        0xD5, 0x44, 0x47, 0x76, 0x67, 0x23, 0x5D, 0x4F, 0xF9, 0xFB, 0x8B, 0x40,
        0x45, 0x83, 0x5B, 0x0A, 0xF6, 0xCC, 0x7B, 0xEB, 0x80, 0xF1, 0xA8, 0x78,
        0x29, 0x25, 0x2A, 0x73, 0x1F, 0x46, 0x9E, 0x51, 0x98, 0x84, 0x54, 0xBE,
        0xBC, 0x69, 0x58, 0xEE, 0x92, 0x37, 0x0D, 0x91, 0xB6, 0xEE, 0xCD, 0xC3,
        0x11, 0xA4, 0xDD, 0x55, 0xE1, 0x2B, 0x85, 0x2D, 0xBB, 0x27, 0xC0, 0x68,
        0x14, 0xBE, 0x27, 0xF3, 0x28, 0x7C, 0x31, 0x1A, 0xE5, 0x44, 0x8B, 0x26,
        0x63, 0xA2, 0xC8, 0x1B, 0xD0, 0x38, 0xC5, 0x46, 0x89, 0x79, 0x17, 0xD7,
        0x53, 0xE1, 0x81, 0xBC, 0x1F, 0xE4, 0x39, 0x2A, 0xAF, 0xFB, 0x49, 0x63,
        0xA2, 0x82, 0xEF, 0x92, 0x6E, 0xD3, 0x20, 0xAF, 0xD6, 0xB0, 0x37, 0x92,
        0x1E, 0xF2, 0xEE, 0xBA, 0x1D, 0xB1, 0x10, 0xEA, 0x82, 0x62, 0x0E, 0x0E,
        0x80, 0xD2, 0x40, 0x57, 0x29, 0xFF, 0x2C, 0xDE, 0xA7, 0x54, 0x9A, 0xEA,
        0xF0, 0x1C, 0x95, 0x3C, 0x8A, 0xB9, 0x69, 0x48, 0xFC, 0x85, 0x93, 0xB7,
        0x99, 0xBC, 0x85, 0x08, 0xD1, 0x4C, 0xD0, 0x4E, 0xF0, 0x8F, 0x82, 0x8C,
        0x72, 0x82, 0xBD, 0x05, 0x3D, 0x37, 0xF5, 0xFB, 0xC3, 0xC9, 0x68, 0xF7,
        0x73, 0x28, 0xB3, 0xB0, 0xC9, 0x49, 0x20, 0xA2, 0xF1, 0x51, 0x36, 0x16,
        0xC9, 0xD7, 0x37, 0x86, 0xE4, 0x1F, 0x86, 0xFE, 0x9A, 0x30, 0xDF, 0x6C,
        0xD0, 0x7A, 0xDA, 0x24, 0x30, 0x91, 0xF9, 0x91, 0x6E, 0x6F, 0x24, 0x2D,
        0xA6, 0xC2, 0xDE, 0x2B, 0xA4, 0x5A, 0x45, 0x17, 0x50, 0xD0, 0xAC, 0x1E,
        0xCC, 0xF1, 0x42, 0xC7, 0x0D, 0x65, 0x1F, 0x07, 0xF7, 0x08, 0x22, 0xD2,
        0x6F, 0xC8, 0xAB, 0xAB, 0x93, 0x54, 0xE5, 0xF8, 0x7F, 0x12, 0xA6, 0x87,
        0x0A, 0x64, 0x32, 0x97, 0xA3, 0x07, 0x53, 0x28, 0x44, 0xC8, 0x5F, 0xFA,
        0xEF, 0xD8, 0xE5, 0x92, 0xB8, 0x39, 0x9E, 0x29, 0xDD, 0xBD, 0xC4, 0x10,
        0x18, 0x1F, 0x37, 0x0E, 0x04, 0x18, 0xE3, 0xA4, 0x49, 0x13, 0x77, 0x49,
        0xBC, 0xBE, 0x51, 0xB4, 0x4D, 0xCE, 0x0B, 0x63, 0xC7, 0xEE, 0xBC, 0x95,
        0x25, 0x3F, 0x74, 0x00, 0x21, 0x73, 0x39, 0x24, 0xC6, 0xCE, 0xD2, 0xFF,
        0xAD, 0xF5, 0xF4, 0x8F, 0x58, 0xD2, 0x7D, 0x80, 0x8F, 0x42, 0x3D, 0xAF,
        0x76, 0x23, 0xF3, 0x74, 0x3D, 0x11, 0x13, 0x47, 0x84, 0x59, 0xE4, 0xAB,
        0xDD, 0xC4, 0x67, 0xE4, 0x96, 0x94, 0x40, 0xA9, 0xE4, 0x7F, 0xC6, 0x53,
        0xD1, 0xC3, 0x59, 0x57, 0x07, 0x68, 0x0C, 0x74, 0x85, 0x6F, 0x2A, 0x35,
        0xB5, 0x6C, 0x49, 0x0F, 0x3D, 0x20, 0x37, 0xCF, 0x36, 0x46, 0x49, 0x97,
        0xBE, 0x38, 0x16, 0x42, 0xFD, 0x8B, 0xCB, 0xF1, 0x96, 0xE4, 0x80, 0x00,
        0xC3, 0x74, 0x79, 0x6E, 0x74, 0x19, 0xBA, 0xB2, 0xE7, 0x10, 0x4D, 0xEF,
        0x63, 0x7C, 0x77, 0x7F, 0x7A, 0xAE, 0x1B, 0xBD, 0x8F, 0x49, 0xDE, 0xF3,
        0xB8, 0xEE, 0x72, 0xBE, 0x9C, 0x61, 0x87, 0xAE, 0x07, 0x93, 0x26, 0x4D,
        0xDA, 0x0A, 0x46, 0xB9, 0xCB, 0xDC, 0xBF, 0x71, 0xDE, 0x4D, 0xC4, 0x46,
        0xF3, 0x0B, 0x7B, 0x4C, 0x9B, 0x05, 0xF8, 0xE4, 0x8F, 0xF9, 0xBF, 0x91,
        0x76, 0x98, 0xD7, 0x1A, 0x6F, 0x0F, 0xAF, 0xE1, 0x96, 0x6A, 0x4B, 0x6A,
        0x50, 0xE0, 0x1E, 0x40, 0xA4, 0xB1, 0xFD, 0x50, 0x0F, 0xAE, 0x55, 0x4E,
        0xB0, 0x6E, 0x05, 0xDA, 0x7E, 0xBE, 0xAB, 0xDD, 0xE0, 0x7A, 0xAD, 0xA3,
        0x03, 0xF8, 0x06, 0xBB, 0x1D, 0xB2, 0x21, 0xD8, 0xC4, 0xF3, 0xC2, 0xF3,
        0xCA, 0x36, 0xA2, 0xEA, 0x71, 0x2A, 0xC3, 0xB7, 0xEC, 0x36, 0xBE, 0x5D,
        0xA9, 0x29, 0x3B, 0x58, 0x3A, 0xAD, 0x07, 0x3C, 0xEE, 0x08, 0x4C, 0x3E,
        0x4D, 0x66, 0xC9, 0xB4, 0x7D, 0x10, 0xD5, 0x07, 0xA9, 0x34, 0x0A, 0x2E,
        0xC2, 0xEB, 0xDA, 0x53, 0xF0, 0xD0, 0xBA, 0xBA, 0x92, 0x72, 0x39, 0x8A,
        0x3C, 0xB7, 0x76, 0x06, 0xBC, 0xFF, 0x01, 0x18, 0x41, 0x96, 0x6F, 0x06,
        0xF2, 0xEA, 0xF8, 0xFF, 0x18, 0x41, 0xF8, 0x7C, 0x08, 0x7C, 0x9C, 0x53,
        0x1E, 0x64, 0x13, 0x0D, 0xD2, 0xDA, 0x0C, 0x38, 0xC6, 0x5F, 0x71, 0x7D,
        0x37, 0xBB, 0xAE, 0xF5, 0x69, 0x9B, 0x86, 0x43, 0xE4, 0xD2, 0xE1, 0x33,
        0xA0, 0x2D, 0x7B, 0x11, 0x5B, 0x1E, 0x4C, 0xF7, 0x52, 0x3B, 0x08, 0x1E,
        0x7A, 0x1B, 0x0F, 0x07, 0x40, 0xEA, 0x58, 0xD5, 0x23, 0x54, 0xB0, 0x1A,
        0x2D, 0xE7, 0xCB, 0xF8, 0xBF, 0xD9, 0xE5, 0x72, 0x6D, 0x77, 0x3B, 0x64,
        0x40, 0xE0, 0x82, 0x63, 0xD9, 0xAD, 0x1D, 0x41, 0x23, 0x98, 0x9A, 0x60,
        0x0D, 0x3D, 0x80, 0x21, 0xFA, 0x23, 0xAF, 0x8B, 0xBD, 0x59, 0xE6, 0x08,
        0x3A, 0x9A, 0xC3, 0xB7, 0x25, 0x7B, 0x9F, 0x22, 0xD1, 0x1F, 0x50, 0xC3,
        0x34, 0x0D, 0x08, 0x85, 0xCF, 0xEB, 0xA1, 0x25, 0x8B, 0x85, 0x6F, 0x6B,
        0xCD, 0xC8, 0xEB, 0x6A, 0xBF, 0x83, 0x6A, 0x94, 0xAA, 0xED, 0xC0, 0x59,
        0x30, 0x53, 0x87, 0x08, 0xB2, 0x2E, 0x52, 0x82, 0xD5, 0xF8, 0x7C, 0x01,
        0x51, 0xF1, 0x47, 0x28, 0xE6, 0xD4, 0xB2, 0x1B, 0xEE, 0xC3, 0x9D, 0x54,
        0x76, 0x58, 0x1F, 0xA0, 0x07, 0xA2, 0x61, 0x78, 0xDE, 0x14, 0xE6, 0x7C,
        0x56, 0x05, 0x8C, 0x71, 0xC4, 0xFB, 0x17, 0x20, 0xDD, 0x9D, 0xC0, 0x79,
        0x88, 0xBD, 0x1D, 0x78, 0xF6, 0x3B, 0x79, 0xAC, 0x2C, 0xAE, 0xBB, 0x19,
        0x38, 0xC7, 0xF0, 0xDD, 0x33, 0x16, 0x8E, 0xB4, 0x14, 0x3C, 0xCD, 0xC5,
        0xB8, 0x5B, 0xD1, 0xA1, 0x9D, 0x85, 0x34, 0xB7, 0x47, 0x33, 0x97, 0x47,
        0x1A, 0x06, 0xD7, 0xED, 0x0A, 0xCA, 0x3A, 0xBA, 0x40, 0x39, 0xE1, 0xB3,
        0xB1, 0x67, 0x9A, 0x99, 0x6B, 0x5F, 0xA5, 0xF4, 0x78, 0xAD, 0x49, 0x5B,
        0xF8, 0xBE, 0xAC, 0xF7, 0x52, 0x03, 0xBC, 0x90, 0xE7, 0xF2, 0xCA, 0xBA,
        0x52, 0xD2, 0xF8, 0x3C, 0x90, 0xD1, 0xC6, 0xEE, 0x0A, 0x9F, 0x8F, 0xC5,
        0xCF, 0x2C, 0x10, 0x19, 0xDB, 0x33, 0x12, 0xD9, 0x0A, 0xB3, 0x9E, 0x24,
        0xD5, 0x12, 0x8E, 0xEB, 0x89, 0x38, 0xD3, 0xEA, 0xD2, 0xB1, 0xF8, 0xC2,
        0x9F, 0x30, 0xDF, 0x0A, 0x00, 0x86, 0x76, 0x35, 0xB9, 0x37, 0x4E, 0x29,
        0xC9, 0xC2, 0x24, 0x21, 0xAF, 0x87, 0x01, 0xEE, 0x8B, 0x17, 0xF8, 0x90,
        0x2A, 0x4E, 0xD6, 0x6E, 0x6D, 0x25, 0x8D, 0x91, 0x74, 0x7D, 0xDE, 0x68,
        0x9C, 0x06, 0x8A, 0xD5, 0xE1, 0x2F, 0x44, 0x18, 0x00, 0xFE, 0x7D, 0x49,
        0xBD, 0x1D, 0x23, 0x65, 0x15, 0x19, 0xDC, 0xF0, 0x1D, 0xB4, 0xE4, 0xA7,
        0x30, 0xC5, 0x5A, 0x32, 0xCD, 0x07, 0xA6, 0x25, 0x18, 0xE3, 0x6A, 0xC3,
        0x54, 0x7D, 0xDD, 0x49, 0x6F, 0x94, 0x56, 0xD3, 0x0D, 0x6E, 0x24, 0x2D,
        0xA6, 0x0E, 0xA6, 0x31, 0x0A, 0xC7, 0x08, 0x4A, 0xBA, 0xBE, 0x38, 0x34,
        0xCB, 0x29, 0x8C, 0xCA, 0xF8, 0xB8, 0x3F, 0xB4, 0xCA, 0xF6, 0x30, 0x83,
        0xFA, 0x78, 0x91, 0x88, 0x13, 0x23, 0xD6, 0xE6, 0xD2, 0x41, 0x49, 0xA3,
        0xA9, 0x80, 0x5C, 0xBA, 0x2F, 0x6E, 0xFE, 0x7A, 0xDA, 0x49, 0x95, 0x78,
        0x95, 0x0A, 0xFF, 0x40, 0x5A, 0x54, 0x82, 0xA7, 0x6A, 0x8F, 0x18, 0x81,
        0x92, 0xAF, 0x6F, 0x06, 0x5A, 0x03, 0xCC, 0xE7, 0x73, 0x11, 0x23, 0x63,
        0x70, 0x8E, 0xF5, 0xFE, 0xBA, 0xD1, 0x44, 0x5C, 0x8D, 0xDD, 0x65, 0xF3,
        0xCE, 0x06, 0x46, 0x9E, 0xFD, 0x49, 0x7C, 0xE3, 0x24, 0xA6, 0x06, 0x43,
        0x0A, 0x8E, 0x82, 0x2F, 0x0F, 0x85, 0xE0, 0x4D, 0x3B, 0x22, 0x22, 0x5E,
        0x6C, 0x56, 0x8A, 0x1A, 0x0C, 0x29, 0x17, 0xBC, 0x7D, 0xB1, 0xDB, 0x59,
        0x9D, 0x21, 0xFC, 0xB9, 0xE1, 0xAF, 0x1A, 0x35, 0x0A, 0x23, 0xDC, 0x44,
        0xBF, 0x6C, 0xD6, 0x19, 0x4D, 0x3A, 0x85, 0x01, 0x22, 0xE3, 0x32, 0x53,
        0x0C, 0xD3, 0xA5, 0x15, 0xAB, 0xF8, 0x39, 0x33, 0x67, 0xCE, 0xFC, 0x80,
        0xD6, 0x53, 0xB7, 0x67, 0x0B, 0xDC, 0x2A, 0xC6, 0x88, 0x51, 0x6A, 0x8A,
        0x0A, 0x97, 0xB8, 0xAE, 0x1F, 0x18, 0x99, 0xA3, 0x3B, 0x1B, 0x35, 0x0A,
        0xD1, 0xA6, 0xC1, 0x5B, 0x28, 0xAB, 0x28, 0x2F, 0x6F, 0xD0, 0x4E, 0xF8,
        0xEB, 0x2C, 0x69, 0x85, 0x11, 0x05, 0x03, 0xBC, 0xCD, 0x8E, 0x84, 0xC5,
        0x0F, 0xC5, 0x1C, 0x13, 0xC8, 0xD6, 0x32, 0x46, 0x8C, 0x62, 0x14, 0x14,
        0x6A, 0x3E, 0x2B, 0x19, 0x33, 0xA6, 0xB6, 0x19, 0x0A, 0xFD, 0x0B, 0xF6,
        0x6F, 0x0D, 0xA1, 0xD5, 0x57, 0xFE, 0xA7, 0x9E, 0xC2, 0x5B, 0xCE, 0xCB,
        0x96, 0xE3, 0x4D, 0xAB, 0x1B, 0xB7, 0x98, 0xE8, 0xF9, 0xEF, 0x9A, 0xD0,
        0xA2, 0xC6, 0x88, 0x31, 0x5E, 0xC1, 0xA5, 0xF3, 0x20, 0x4A, 0x26, 0xE3,
        0xDF, 0xA9, 0x1E, 0x35, 0x50, 0x6F, 0xA8, 0x47, 0x57, 0x88, 0x22, 0xF3,
        0x00, 0xED, 0x04, 0xC7, 0x98, 0x90, 0x4D, 0xDF, 0xFD, 0x70, 0xBC, 0xEB,
        0x04, 0xE7, 0x92, 0x9E, 0x5B, 0x0A, 0x2F, 0xCC, 0x66, 0xDC, 0xE6, 0x21,
        0xF9, 0x8E, 0x5F, 0x82, 0x50, 0xAA, 0xFA, 0xAD, 0x34, 0xA9, 0x8B, 0x28,
        0xE3, 0x1C, 0xFF, 0x78, 0xD2, 0xC9, 0x04, 0x60, 0x22, 0xC4, 0x1C, 0x43,
        0x7E, 0x34, 0x25, 0xE9, 0x46, 0xF5, 0xA0, 0x84, 0xBA, 0x13, 0xC8, 0x5B,
        0x25, 0x88, 0x8C, 0xFD, 0x5B, 0x35, 0x4D, 0x0D, 0x84, 0xC6, 0xC3, 0xC3,
        0x9F, 0x1A, 0xFE, 0x83, 0xBB, 0xD3, 0xF0, 0x4F, 0xFD, 0xA1, 0x59, 0x58,
        0xA3, 0xB2, 0xFC, 0xF2, 0x0F, 0x57, 0x54, 0xB9, 0x84, 0x9D, 0x26, 0x77,
        0xF6, 0x20, 0x53, 0x55, 0x4D, 0x36, 0xAD, 0xF0, 0x95, 0x51, 0x14, 0xB9,
        0xC5, 0xEC, 0xD9, 0x93, 0xAF, 0x6D, 0x4D, 0xA4, 0x32, 0x25, 0xDD, 0x7A,
        0xB5, 0x69, 0x9C, 0xCD, 0xC3, 0x41, 0x97, 0xA5, 0x71, 0x50, 0xD2, 0xA0,
        0x3E, 0x07, 0x3B, 0x2E, 0x77, 0x40, 0x80, 0x57, 0x5C, 0x94, 0x35, 0xB5,
        0x48, 0xAA, 0x2A, 0xF9, 0x17, 0x92, 0x1E, 0x8C, 0xF2, 0xE7, 0x76, 0x8B,
        0x8E, 0x18, 0x4D, 0x94, 0x87, 0xB2, 0x55, 0x01, 0xF5, 0xE0, 0x07, 0x69,
        0xE7, 0x5F, 0xA2, 0x4F, 0x15, 0x9C, 0x4F, 0x3A, 0x0D, 0x01, 0x5B, 0x3E,
        0xAE, 0xE7, 0x64, 0x49, 0x55, 0x8C, 0x04, 0x2E, 0xD0, 0xC9, 0x2C, 0xDC,
        0xE1, 0x31, 0xB0, 0xED, 0x69, 0x8C, 0x18, 0xAD, 0x32, 0x7F, 0x4C, 0xFD,
        0x28, 0xC7, 0xFF, 0x4F, 0x9A, 0x79, 0x98, 0x4D, 0x5D, 0xDD, 0xCC, 0x18,
        0xA2, 0xE8, 0x7A, 0x01, 0x03, 0xEE, 0xCF, 0xAA, 0x40, 0x53, 0xC8, 0x82,
        0x63, 0x48, 0x0F, 0xD1, 0x36, 0x3F, 0xED, 0x44, 0xB2, 0x55, 0x90, 0xCA,
        0x74, 0x55, 0xB4, 0xC2, 0xEC, 0x1E, 0x4E, 0xEF, 0x60, 0x1C, 0xC7, 0x5A,
        0x24, 0x8A, 0xAE, 0x07, 0x70, 0xF1, 0x7E, 0x59, 0x8D, 0x61, 0xEB, 0xC6,
        0xCB, 0xA4, 0xA7, 0x95, 0xFF, 0xBD, 0x76, 0xE9, 0xAA, 0x06, 0x43, 0xEA,
        0x05, 0x29, 0xEB, 0x3A, 0x91, 0xCB, 0xF1, 0x1F, 0x4F, 0x5B, 0x5F, 0x2D,
        0x1D, 0x9E, 0x16, 0x31, 0x28, 0x74, 0x64, 0xB9, 0x51, 0x8C, 0xB6, 0x5D,
        0x3C, 0x84, 0xE9, 0x0A, 0xDF, 0x87, 0xFC, 0x4C, 0xDE, 0xFC, 0xD0, 0x34,
        0x29, 0x68, 0x50, 0x1C, 0x74, 0x8C, 0xBB, 0xA7, 0x75, 0x5C, 0x29, 0xF0,
        0xF5, 0x1C, 0xBB, 0x91, 0x47, 0xAE, 0x37, 0xCF, 0x12, 0xFC, 0x05, 0xA4,
        0xA7, 0x55, 0xF8, 0xA3, 0x8D, 0x25, 0x3A, 0x62, 0x34, 0xDE, 0x5D, 0x35,
        0x3B, 0xBF, 0x5C, 0xFF, 0xA9, 0xB4, 0xCE, 0x2B, 0xE3, 0x74, 0xB8, 0x1B,
        0xE9, 0x0C, 0x08, 0xCC, 0x6D, 0x59, 0x0D, 0x22, 0xB5, 0xC3, 0x3C, 0x70,
        0xEA, 0x30, 0x5B, 0xE0, 0xDA, 0xBB, 0x76, 0xAC, 0x8F, 0xE6, 0x79, 0x3D,
        0x97, 0x80, 0xF8, 0x3E, 0x40, 0x5A, 0x7D, 0x89, 0x61, 0xD5, 0x06, 0xB6,
        0xBC, 0x79, 0x9D, 0x5D, 0x13, 0xB3, 0xA6, 0x16, 0x53, 0xF8, 0xC2, 0xA5,
        0xB2, 0xFE, 0xE3, 0xF8, 0x87, 0x8B, 0x71, 0x12, 0xAE, 0x6B, 0x77, 0x14,
        0x23, 0xA8, 0xF0, 0x52, 0xEA, 0x0D, 0xDF, 0x53, 0xFD, 0xE6, 0x89, 0xD1,
        0x55, 0xB0, 0x0A, 0x0D, 0xCF, 0x78, 0x31, 0x40, 0x7F, 0x70, 0xDD, 0xE8,
        0xDC, 0xAC, 0x0A, 0x34, 0x8C, 0x06, 0x57, 0x1B, 0x7A, 0xE1, 0xDC, 0xAC,
        0xB5, 0xA8, 0x55, 0x31, 0x76, 0x3C, 0xAE, 0xE4, 0xBA, 0x25, 0x3E, 0x37,
        0x49, 0x1B, 0x25, 0x92, 0x4D, 0xA4, 0x95, 0xEE, 0x03, 0xF2, 0xA6, 0x88,
        0xE3, 0xBF, 0x94, 0xB5, 0x35, 0xA5, 0x01, 0xBC, 0x52, 0x6D, 0x1A, 0x17,
        0xE3, 0x36, 0x56, 0x63, 0xC4, 0x68, 0x9D, 0xEF, 0x30, 0x79, 0x03, 0x32,
        0x65, 0x5A, 0xB6, 0xDD, 0xE8, 0x93, 0x30, 0x41, 0xDF, 0xAD, 0xD3, 0x50,
        0xE0, 0xCE, 0x59, 0x15, 0x68, 0x8C, 0x19, 0xBC, 0x68, 0xE8, 0x05, 0x57,
        0xA4, 0xF5, 0x9A, 0x76, 0x41, 0xEA, 0x4B, 0xD9, 0x53, 0xB0, 0xF9, 0x99,
        0x56, 0x7F, 0x34, 0xE6, 0x7A, 0x6F, 0x3E, 0xF6, 0x3C, 0x43, 0x4E, 0x1E,
        0x54, 0x0F, 0x72, 0x3C, 0x0C, 0x61, 0x7F, 0x7F, 0x23, 0x7C, 0x6B, 0xE3,
        0x2B, 0xE6, 0xEB, 0x23, 0x53, 0x97, 0x9C, 0xAD, 0xA5, 0x82, 0xE3, 0xD2,
        0xA6, 0x7B, 0x1B, 0x69, 0x7D, 0xD3, 0x16, 0x8A, 0xCB, 0xA3, 0x79, 0x44,
        0x08, 0x7F, 0xA1, 0x86, 0xD1, 0xB6, 0xB1, 0x47, 0x47, 0x8C, 0xC6, 0x09,
        0xF9, 0x1B, 0x55, 0xD5, 0xAD, 0xD1, 0x7D, 0xA5, 0x3A, 0xF7, 0x8B, 0x7A,
        0x07, 0x0D, 0xF9, 0xB9, 0x25, 0x81, 0x4A, 0xA5, 0x3A, 0x16, 0x21, 0xB7,
        0x32, 0x4B, 0x87, 0x65, 0x73, 0xA1, 0xCC, 0xCC, 0x51, 0xEC, 0x1A, 0xFA,
        0x55, 0x81, 0x76, 0x46, 0x51, 0xA6, 0xB2, 0x07, 0x0E, 0xA4, 0x9C, 0x50,
        0x53, 0xEF, 0x3C, 0x40, 0x61, 0xDD, 0x0B, 0x83, 0xDC, 0x2D, 0x5A, 0xCE,
        0xB8, 0x83, 0x88, 0x06, 0x80, 0x41, 0xAE, 0x24, 0x3D, 0x58, 0xFB, 0xC5,
        0xAC, 0xCD, 0x41, 0xBB, 0x20, 0xDF, 0x5D, 0x86, 0x03, 0xAE, 0xE4, 0x8B,
        0xE2, 0x90, 0xFB, 0x8C, 0xB4, 0x8E, 0x48, 0x43, 0x7A, 0x4E, 0xF4, 0x79,
        0x31, 0x08, 0xFA, 0xE9, 0xB3, 0xB2, 0x7A, 0x34, 0xC7, 0x73, 0x96, 0x2F,
        0xAF, 0x90, 0x4A, 0xA4, 0x6D, 0x2C, 0x4B, 0x25, 0x83, 0xA3, 0x71, 0xC6,
        0x70, 0x2F, 0xAF, 0x14, 0x55, 0xD3, 0xA6, 0x7D, 0xD1, 0x9F, 0x0A, 0x7F,
        0x28, 0x06, 0xE1, 0x23, 0x4A, 0x1E, 0x8D, 0x9A, 0x74, 0x61, 0x3D, 0x68,
        0x7A, 0x72, 0x7F, 0x55, 0xA5, 0x32, 0x73, 0x4B, 0xB6, 0x81, 0x59, 0x8D,
        0xDB, 0x6E, 0x48, 0x79, 0x1D, 0x27, 0xB8, 0x98, 0xC7, 0x8A, 0x23, 0xF5,
        0x2C, 0x4D, 0x93, 0xFA, 0x45, 0x67, 0x2A, 0xBC, 0x41, 0x0C, 0x82, 0xCE,
        0x68, 0x5E, 0x96, 0x14, 0x63, 0xC6, 0xDA, 0xA3, 0x29, 0x54, 0x70, 0xCD,
        0x70, 0x33, 0x88, 0x89, 0x0A, 0xF3, 0x6B, 0x73, 0x70, 0xEE, 0xFB, 0xD3,
        0x44, 0x09, 0xC7, 0x28, 0x9E, 0xF5, 0x58, 0xE9, 0x9C, 0x31, 0x16, 0xC4,
        0xFE, 0x97, 0xA5, 0xA0, 0xD3, 0x00, 0xC8, 0x9F, 0x72, 0x82, 0x33, 0x0D,
        0x33, 0x5C, 0xEA, 0x47, 0x8C, 0x46, 0x77, 0xC1, 0x72, 0xC7, 0xD9, 0x73,
        0xD3, 0xB4, 0xE9, 0xDF, 0xEA, 0xFF, 0x15, 0xCE, 0x3F, 0xF6, 0xC6, 0x3F,
        0xD0, 0xAE, 0x25, 0x5F, 0x58, 0x0F, 0x92, 0x01, 0xA5, 0xA2, 0xA3, 0xEC,
        0xC9, 0xD7, 0xA9, 0x9E, 0x37, 0xB7, 0x3B, 0x1A, 0x0F, 0x0F, 0x76, 0xD2,
        0x3A, 0xFA, 0x52, 0xBA, 0x0C, 0x21, 0x3A, 0x5B, 0x8C, 0x74, 0xE5, 0x9F,
        0x92, 0xB5, 0x00, 0x33, 0x22, 0xB8, 0x5C, 0x42, 0x86, 0xD2, 0x16, 0xB5,
        0x76, 0x47, 0x31, 0x82, 0x0E, 0xBF, 0x31, 0x41, 0x96, 0x51, 0xD2, 0xEA,
        0xD3, 0x5F, 0x86, 0x14, 0x13, 0x5C, 0x9F, 0xC5, 0x20, 0xE6, 0xE6, 0xFE,
        0x32, 0x39, 0x37, 0x31, 0xC7, 0x53, 0x4B, 0xDB, 0x0D, 0x29, 0x37, 0xD2,
        0xF6, 0x45, 0xC8, 0xDA, 0x1D, 0x68, 0x83, 0xDF, 0x4D, 0x63, 0x14, 0x1E,
        0xE3, 0x2E, 0x6B, 0x30, 0xD9, 0x0C, 0x82, 0x7A, 0xE1, 0xF8, 0x2F, 0x49,
        0xFD, 0x68, 0xA1, 0xE3, 0x5E, 0x9B, 0x8D, 0xCC, 0x0C, 0xC8, 0x36, 0x77,
        0x52, 0x0F, 0x70, 0xCC, 0x27, 0x53, 0xD6, 0xD1, 0x6E, 0x9E, 0x4D, 0xFB,
        0x6A, 0xC2, 0x7F, 0xD4, 0x8D, 0x96, 0x11, 0xF9, 0xE9, 0x09, 0xB6, 0x6D,
        0xC3, 0xD7, 0x20, 0x34, 0x40, 0x20, 0x9D, 0xA6, 0xAB, 0x82, 0x5B, 0xD3,
        0xEA, 0x81, 0x11, 0xB2, 0x22, 0xE9, 0x3F, 0xEA, 0x45, 0x1B, 0xAA, 0x72,
        0x12, 0x34, 0x0C, 0xF3, 0xC0, 0x70, 0xAD, 0x21, 0x4C, 0x51, 0xD0, 0xE5,
        0x22, 0xEA, 0x01, 0xAD, 0xFF, 0xF9, 0xA9, 0x0D, 0x92, 0xF4, 0xC7, 0x46,
        0xD0, 0x1A, 0xE4, 0x74, 0x32, 0x02, 0x86, 0x9E, 0x1D, 0x6E, 0x2D, 0x6F,
        0x8C, 0xD6, 0x20, 0x2B, 0x6A, 0x63, 0x6A, 0x9B, 0x41, 0x1F, 0x27, 0xA6,
        0x36, 0x08, 0x07, 0x66, 0x41, 0x39, 0x2B, 0xC4, 0xBE, 0x44, 0x8C, 0x08,
        0xF9, 0xEF, 0x70, 0x58, 0x72, 0x4F, 0x46, 0xF3, 0x9C, 0x3D, 0xDE, 0x7D,
        0x4C, 0xBD, 0x24, 0xE9, 0x6B, 0x30, 0xE4, 0x42, 0xE0, 0x55, 0x59, 0xB0,
        0x5C, 0xEE, 0x9A, 0xCD, 0x1F, 0x3F, 0x91, 0xFD, 0x1E, 0x19, 0x27, 0x98,
        0xED, 0x8E, 0xCC, 0x0E, 0x65, 0x15, 0x45, 0x3C, 0x1E, 0xA4, 0x5C, 0x9E,
        0x7E, 0x30, 0x1C, 0xB4, 0x61, 0xA4, 0x63, 0xE7, 0x02, 0xDC, 0xE3, 0x8D,
        0x90, 0xCD, 0xB4, 0x84, 0xDF, 0xEE, 0xC8, 0xFA, 0x89, 0xE8, 0xD8, 0xCB,
        0xAA, 0x64, 0x68, 0xC1, 0x75, 0xAB, 0x1E, 0x98, 0xEA, 0x1E, 0xEE, 0x06,
        0xC1, 0xE4, 0x78, 0x3F, 0xAB, 0x92, 0xA1, 0x85, 0xF8, 0x5C, 0xF8, 0xE1,
        0x6C, 0x10, 0xD6, 0x00, 0xA4, 0x1D, 0xF9, 0x75, 0xB7, 0x21, 0x07, 0x1E,
        0x40, 0x6C, 0x18, 0x1B, 0x31, 0x88, 0x55, 0x49, 0x0A, 0x18, 0x35, 0xEA,
        0xFF, 0xC8, 0x94, 0x8D, 0x3E, 0x18, 0x0E, 0xE6, 0x54, 0x00, 0x00, 0x00,
        0x00, 0x49, 0x45, 0x4E, 0x44, 0xAE, 0x42, 0x60, 0x82
};

/*********************************************************************
 * @fn      ParseHttpRequest
 *
 * @brief   Analyze the request message, take out the method and assign it to request->method,
 *          and assign the URL to request->URL (with '/')
 *
 * @param   request - data buff,Used to save the content of each part of the post request
 *          buf - POST request
 *
 * @return  none
 */
void ParseHttpRequest(st_http_request *request, char *buf)
{
    char *strptr = buf;

    if (strstr(strptr, "GET") || strstr(strptr, "get")) {       /*browser 'get' request*/
        request->METHOD = METHOD_GET;
        strptr += strlen("GET") + 2;
        memset(buf, 1, strlen("GET"));                          /* clear the request method */
    }
    else if (strstr(strptr, "POST") || strstr(strptr, "post")) {  /*browser 'post' request*/
        request->METHOD = METHOD_POST;
        strptr += strlen("POST") + 2;
        memset(buf, 1, strlen("POST"));                         /* clear the request method */
    }
    else {
        request->METHOD = METHOD_ERR;
        return;
    }
    request->URL[MAX_URL_SIZE - 1] = '0';
    memcpy(request->URL, strptr, MAX_URL_SIZE - 1);
    strptr = strtok(request->URL, " ");
    strcpy((char*) request->URL, strptr);
}

/*********************************************************************
 * @fn      ParseURLType
 *
 * @brief   Parse URL type
 *
 * @param   type - type.
 *          buf - data buff
 *
 * @return  URL type
 */
void ParseURLType(char *type, char * buf)
{
    if (strstr(buf, ".html") || strstr(name, "HTTP")) /* html type */
        *type = PTYPE_HTML;
    else if (strstr(buf, ".png"))                    /* png type */
        *type = PTYPE_PNG;
    else if (strstr(buf, ".css"))                    /* css type */
        *type = PTYPE_CSS;
    else if (strstr(buf, ".gif"))                    /* gif type */
        *type = PTYPE_GIF;
    else
        *type = PTYPE_ERR;
}

/*********************************************************************
 * @fn      MakeHttpResponse
 *
 * @brief   Select the corresponding response message and assign
 *           it to buf, according to the type .
 *
 * @param   buf - data buff
 *          type - type
 *          len - data length
 *
 * @return  none
 */
void MakeHttpResponse(u8 *buf, char type, u32 len )
{
    char *head = 0;
    char string[8] = {0};

    memset(buf, 0, sizeof(buf));
    if (type == PTYPE_HTML)
        head = RES_HTMLHEAD_OK;
    else if (type == PTYPE_PNG)
        head = RES_PNGHEAD_OK;
    else if (type == PTYPE_CSS)
        head = RES_CSSHEAD_OK;
    else if (type == PTYPE_GIF)
        head = RES_GIFHEAD_OK;
    strcpy(buf, head);
    snprintf(string, sizeof(string), "%d", len);
    strcat(buf, string);
    strcat(buf, RES_END);
}

/*********************************************************************
 * @fn      DataLocate
 *
 * @brief   Locate the location of "name"
 *
 * @param   buf - data buff
 *          name - name strings
 *
 * @return  pointer to the last digit of name
 */
char * DataLocate(char *buf, char *name)
{
    char *p;
    p = strstr(buf, name);
    if (p != NULL)
        p += strlen(name);
    return p;
}

/*********************************************************************
 * @fn      atoh
 *
 * @brief   Converting character to hexadecimal number
 *
 * @param   src - character
 *
 * @return  hexadecimal number
 */
uint8_t atoh(uint8_t *src)
{
    uint8_t desc=0;

    if((*src >= '0') && (*src <= '9'))
    desc = *src - 0x30;
    else if((*src >= 'a') && (*src <= 'f'))
    desc = *src - 0x57;
    else if((*src >= 'A') && (*src <= 'F'))
    desc = *src - 0x37;

    return desc;
}
/*********************************************************************
 * @fn      Refresh_Basic
 *
 * @brief   Parse the basic interface configuration parameters from
 *          the post request and store the parsed parameters in the
 *          flash in the form of a structure
 *
 * @param   buf - data buff
 *
 * @return  none
 */
void Refresh_Basic(u8 *buf)
{
    char *p, *q;
    char temp[30];                               //Save the value of each configuration in the form of a string
    Basic_Cfg_t BasicCfg;
    u8 i;

    memset((uint8_t *)(&BasicCfg), 0, BASIC_CFG_LEN);
    BasicCfg.flag[0] = 0x57;
    BasicCfg.flag[1] = 0xAB;

    p = DataLocate(buf, "__PMAC=");
    if (p != NULL) {
        memset(temp, 0, 30);
        q = strstr(p, "&");
        if(q == NULL) return;
        memcpy(temp, p, (q - p));
        p = strtok(temp, ".");
        (strlen(p) == 1) ? (BasicCfg.mac[0] = atoh(p)) : (BasicCfg.mac[0] = atoh(p) << 4 | atoh(p + 1));
        for (i = 1; i < 6; i++) {
            p = strtok(NULL, ".");
            (strlen(p) == 1) ? (BasicCfg.mac[i] = atoh(p)) : (BasicCfg.mac[i] = atoh(p) << 4 | atoh(p + 1));
        }
    }
    else return;

    p = DataLocate(q, "__PSIP=");
    if (p != NULL) {
        memset(temp, 0, 30);
        q = strstr(p, "&");
        if(q == NULL) return;
        memcpy(temp, p, (q - p));
        p = strtok(temp, ".");
        BasicCfg.ip[0] = atoi(p);
        for (i = 1; i < 4; i++) {
            p = strtok(NULL, ".");
            BasicCfg.ip[i] = atoi(p);
        }
    }
    else return;

    p = DataLocate(q, "__PMSK=");
    if (p != NULL) {
        memset(temp, 0, 30);
        q = strstr(p, "&");
        if(q == NULL) return;
        memcpy(temp, p, (q - p));
        p = strtok(temp, ".");
        BasicCfg.mask[0] = atoi(p);
        for (i = 1; i < 4; i++) {
            p = strtok(NULL, ".");
            BasicCfg.mask[i] = atoi(p);
        }
    }
    else return;

    p = DataLocate(q, "__PGAT=");
    if (p != NULL) {
        memset(temp, 0, 30);
        q = strstr(p, "\r\n");
        if(q)
            memcpy(temp, p, (q - p));
        else
            memcpy(temp, p, strlen(p));
        p = strtok(temp, ".");
        BasicCfg.gateway[0] = atoi(p);
        for (i = 1; i < 4; i++) {
            p = strtok(NULL, ".");
            BasicCfg.gateway[i] = atoi(p);
        }
    }
    else return;

    WEB_ERASE( BASIC_CFG_ADDR, FLASH_PAGE_SIZE);
    WEB_WRITE( BASIC_CFG_ADDR, (uint8_t *)(&BasicCfg), BASIC_CFG_LEN);
    printf("flag:%x %x\r\n", BasicCfg.flag[0], BasicCfg.flag[1]);
    printf("mac:%x %x %x %x %x %x\r\n", BasicCfg.mac[0], BasicCfg.mac[1], \
                                        BasicCfg.mac[2], BasicCfg.mac[3], \
                                        BasicCfg.mac[4], BasicCfg.mac[5]);
    printf("ip:%d %d %d %d\r\n", BasicCfg.ip[0], BasicCfg.ip[1],\
                                    BasicCfg.ip[2], BasicCfg.ip[3]);
    printf("mask:%d %d %d %d\r\n", BasicCfg.mask[0], BasicCfg.mask[1],\
                                        BasicCfg.mask[2], BasicCfg.mask[3]);
    printf("gateway:%d %d %d %d\r\n", BasicCfg.gateway[0], BasicCfg.gateway[1],\
                                        BasicCfg.gateway[2], BasicCfg.gateway[3]);
}

/*********************************************************************
 * @fn      Refresh_Port
 *
 * @brief   Parse the Port parameter from the post request
 *          and store the parsed parameter in flash
 *
 * @param   buf - data buff
 *
 * @return  none
 */
void Refresh_Port(char *buf)
{
    u8 i;
    char *p, *q;
    char temp[30];
    Port_Cfg_t portCfg;

    memset((uint8_t *)(&portCfg), 0, PORT_CFG_LEN);
    portCfg.flag[0] = 0X57;
    portCfg.flag[1] = 0XAB;

    p = DataLocate(buf, "__PMOD=");
    if (p != NULL) {
        memset(temp, 0, 30);
        q = strstr(p, "&");
        if(q == NULL) return;
        memcpy(temp, p, (q - p));
        if (strcmp(temp, "0") == 0)
        {
            portCfg.mode = MODE_TCPSERVER;
        }
        if (strcmp(temp, "1") == 0) {
            portCfg.mode = MODE_TCPCLIENT;
        }
    }
    else return;

    p = DataLocate(q, "__PSPT=");
    if (p != NULL) {
        memset(temp, 0, 30);
        q = strstr(p, "&");
        if(q == NULL) return;
        memcpy(temp, p, (q - p));
        portCfg.src_port[0] = atoi(temp) / 256;
        portCfg.src_port[1] = atoi(temp) % 256;
    }
    else return;

    p = DataLocate(q, "__PDIP=");
    if (p != NULL) {
        memset(temp, 0, 30);
        q = strstr(p, "&");
        if(q == NULL) return;
        memcpy(temp, p, (q - p));
        p = strtok(temp, ".");
        portCfg.des_ip[0] = atoi(p);
        for (i = 1; i < 4; i++) {
            p = strtok(NULL, ".");
            portCfg.des_ip[i] = atoi(p);
        }
    }
    else return;

    p = DataLocate(q, "__PDPT=");
    if (p != NULL) {
        memset(temp, 0, 30);
        q = strstr(p, "\r\n");
        if(q)
            memcpy(temp, p, (q - p));
        else
            memcpy(temp, p, strlen(p));
        portCfg.des_port[0] = atoi(temp) / 256;
        portCfg.des_port[1] = atoi(temp) % 256;
    }
    else return;

    WEB_ERASE( PORT_CFG_ADDR, FLASH_PAGE_SIZE);
    WEB_WRITE( PORT_CFG_ADDR, (uint8_t *)(&portCfg), PORT_CFG_LEN);

    printf("mode:%x\r\n",portCfg.mode);
    printf("src_port:%d\r\n", portCfg.src_port[0]*256 + portCfg.src_port[1]);
    printf("des_ip:%d %d %d %d\r\n", portCfg.des_ip[0], portCfg.des_ip[1], portCfg.des_ip[2], portCfg.des_ip[3]);
    printf("des_port:%d\r\n", portCfg.des_port[0]*256 + portCfg.des_port[1]);
}

/*********************************************************************
 * @fn      ASCToDec
 *
 * @brief   Convert ASC code to Decimal number
 *
 * @param   ASCPtr - Pointer to the character to be converted
 *
 * @return  status
 */
uint8_t ASCToDec(uint8_t *ASCPtr)
{
    uint8_t i;
    for(i = 0; i < 2; i++)
    {
        if( (*ASCPtr >= '0') && (*ASCPtr <= '9'))
        {
            *ASCPtr = *ASCPtr - '0';
        }
        else if( (*ASCPtr >= 'a') && (*ASCPtr <= 'f'))
        {
            *ASCPtr = *ASCPtr - 'a' + 10;
        }
        else if( ( *ASCPtr >= 'A') && (*ASCPtr <= 'F'))
        {
            *ASCPtr = *ASCPtr - 'A' + 10;
        }
        else return NoREADY;
        ASCPtr++;
    }
    return READY;
}

/*********************************************************************
 * @fn      URLDecode
 *
 * @brief   Decoding special characters for URL transmission
 *
 * @param   srcptr - source buff
 *          desptr - destination buff
 *          bufflen - length of source buff
 *
 * @return  status or Decoded string length
 */
uint8_t URLDecode(char *srcptr, char *desptr, uint8_t bufflen)
{
    uint8_t i = 0, ret, datalen = 0;
    char tempbuf[2];
    while(i < bufflen)
    {
        if(srcptr[i] == '%')
        {
            tempbuf[0] = srcptr[++i];
            tempbuf[1] = srcptr[++i];
            ret = ASCToDec(tempbuf);
            if(ret == NoREADY) return ret;
            tempbuf[0] = tempbuf[0] * 16 + tempbuf[1];
            *desptr++ = tempbuf[0];
            datalen++;
            i++;
        }
        else {
            *desptr++ = srcptr[i++];
            datalen++;
        }
        if(datalen > sizeof(Login_CfgBuf.pass)) return NoREADY;
    }
    return datalen;
}

/*********************************************************************
 * @fn      Refresh_Login
 *
 * @brief   Parse the login parameter from the post request
 *          and store the parsed parameter in flash
 *
 * @param   buf - data buff
 *
 * @return  none
 */
void Refresh_Login(char *buf)
{
    char *p, *q = NULL;
    u8 len;
    uint8_t tempbuff[30] = {0x00};
    Login_Cfg_t LoginInf;


    memset((uint8_t *)(&LoginInf), 0, LOGIN_CFG_LEN);
    LoginInf.flag[0] = 0X57;
    LoginInf.flag[1] = 0XAB;

    p = DataLocate(buf, "__PUSE=");
    if (p != NULL) {
        q = strstr(p, "&");
        if(q == NULL) return;
        len = q - p;
        if(len > sizeof(tempbuff)) return;
        len = URLDecode(p, tempbuff, len);
        if(len == 0) return;
        memcpy(LoginInf.user, tempbuff, len);
    }
    else return;

    p = DataLocate(q, "__PPAS=");
    if (p != NULL) {
        q = strstr(p, "\r\n");
        if(q)
            len = q - p;
        else
            len = strlen(p);
        if(len > sizeof(tempbuff)) return;
        len = URLDecode(p, tempbuff, len);
        if(len == 0) return;
        memcpy(LoginInf.pass, tempbuff, len);
    }
    else return;

    WEB_ERASE( LOGIN_CFG_ADDR, FLASH_PAGE_SIZE);
    WEB_WRITE( LOGIN_CFG_ADDR, (uint8_t *)(&LoginInf), LOGIN_CFG_LEN);
    printf("user:%s\r\n",LoginInf.user);
    printf("pass:%s\r\n",LoginInf.pass);
}

/*********************************************************************
 * @fn      Refresh_Html
 *
 * @brief   Select an html file in flash, replace it with the
 *          parameter table, and save it to HtmlBuffer[].
 *
 * @param   html - HTML array constants
 *          buf - parameter structure
 *          paranum - parameters number
 *
 * @return  length of data
 */
uint16_t Refresh_Html(const char *html, Parameter *buf, u8 paranum)
{
    const char *lastptr = html;
    char *currptr;
    const char *keyword = "__A";
    uint8_t i;
    uint16_t datalen = 0, copylen = 0;

    while(1)
    {
        currptr = strstr(lastptr, keyword);
        if(currptr == NULL) break;
        copylen = currptr - lastptr;
        memcpy(&HtmlBuffer[datalen], lastptr, copylen);
        datalen += copylen;
        for(i = 0; i < paranum; i++)
        {
            if(memcmp(currptr, buf[i].para, strlen(buf[i].para)) == 0)
                break;
        }
        if(i == paranum)
            return 0 ;
        memcpy(&HtmlBuffer[datalen], buf[i].value, strlen(buf[i].value));
        datalen += strlen(buf[i].value);
        lastptr = currptr + strlen(buf[i].para);
    }
    if(strlen(lastptr) != 0)
    {
        memcpy(&HtmlBuffer[datalen], lastptr, strlen(lastptr));
        datalen += strlen(lastptr);
    }
    return datalen;
}

/*********************************************************************
 * @fn      copy_flash
 *
 * @brief   Select the html file in the flash and copy it directly
 *          to the HtmlBuffer (only for some web pages without variables)
 *
 * @param   html - HTML array constants
 *          len - data length
 *
 * @return  none
 */
void copy_flash(const char *html, u32 len)
{
    memset(HtmlBuffer, 0, HTML_LEN);
    memcpy(HtmlBuffer, html, len);
}

/*********************************************************************
 * @fn      WEB_ERASE
 *
 * @brief   erase Data-Flash block, minimal block is 256B.
 *
 * @param   Page_Address - the address of the page being erased
 *          Length - erasing length
 *
 * @return  none
 */
void WEB_ERASE(uint32_t Page_Address, u32 Length) {
    u32 NbrOfPage, EraseCounter;

    FLASH_Unlock_Fast();
    NbrOfPage = Length / FLASH_PAGE_SIZE;

    for (EraseCounter = 0; EraseCounter < NbrOfPage; EraseCounter++) {
        FLASH_ErasePage_Fast( Page_Address + (FLASH_PAGE_SIZE * EraseCounter)); //Erase 256B
    }
    FLASH_Lock_Fast();
}

/*********************************************************************
 * @fn      WEB_WRITE
 *
 * @brief   write Data-Flash data block.
 *
 * @param   StartAddr - the address of the page being written.
 *          Buffer - data buff
 *          Length - data length
 *
 * @return  FLASH_Status
 */
FLASH_Status WEB_WRITE(u32 StartAddr, u8 *Buffer, u32 Length) {
    u32 address = StartAddr;
    u32 *p_buff = (u32 *) Buffer;
    FLASH_Status FLASHStatus = FLASH_COMPLETE;

    FLASH_Unlock();
    while((address < (StartAddr + Length)) && (FLASHStatus == FLASH_COMPLETE))
    {
        FLASHStatus = FLASH_ProgramWord(address, *p_buff);
        address += 4;
        p_buff++;
    }
    FLASH_Lock();
    return FLASHStatus;
}

/*********************************************************************
 * @fn      WEB_READ
 *
 * @brief   read Data-Flash data block.
 *
 * @param   StartAddr - the address of the page being read.
 *          Buffer - data buff
 *          Length - data length
 *
 * @return  none
 */
void WEB_READ(u32 StartAddr, u8 *Buffer, u32 Length) {
    u32 address = StartAddr;
    u32 *p_buff = (u32 *) Buffer;

    while(address < (StartAddr + Length))
    {
        *p_buff = (*(u32 *)address);
        address += 4;
        p_buff++;
    }
}

/*********************************************************************
 * @fn      Init_Para_Tab
 *
 * @brief   Initialization parameter table.
 *
 * @return  none
 */
void Init_Para_Tab(void)
{
    u8 s[30];

    Para_Basic[0].para = "__AMAC";
    memset(s, 0, 30);
    snprintf(s, 30, "%x.%x.%x.%x.%x.%x", Basic_CfgBuf.mac[0], Basic_CfgBuf.mac[1],
            Basic_CfgBuf.mac[2], Basic_CfgBuf.mac[3], Basic_CfgBuf.mac[4],
            Basic_CfgBuf.mac[5]);
    strcpy(Para_Basic[0].value, s);
    printf("__ASMAC = %s\n", Para_Basic[0].value);

    Para_Basic[1].para = "__ASIP";
    memset(s, 0, 30);
    snprintf(s, 30, "%d.%d.%d.%d", Basic_CfgBuf.ip[0], Basic_CfgBuf.ip[1],
            Basic_CfgBuf.ip[2], Basic_CfgBuf.ip[3]);
    strcpy(Para_Basic[1].value, s);
    printf("__ASIP = %s\n", Para_Basic[1].value);

    Para_Basic[2].para = "__AMSK";
    memset(s, 0, 30);
    snprintf(s, 30, "%d.%d.%d.%d", Basic_CfgBuf.mask[0], Basic_CfgBuf.mask[1],
            Basic_CfgBuf.mask[2], Basic_CfgBuf.mask[3]);
    strcpy(Para_Basic[2].value, s);
    printf("__AMSK = %s\n", Para_Basic[2].value);

    Para_Basic[3].para = "__AGAT";
    memset(s, 0, 30);
    snprintf(s, 30, "%d.%d.%d.%d", Basic_CfgBuf.gateway[0],
            Basic_CfgBuf.gateway[1], Basic_CfgBuf.gateway[2],
            Basic_CfgBuf.gateway[3]);
    strcpy(Para_Basic[3].value, s);
    printf("__AGAT = %s\n", Para_Basic[3].value);

    Para_Port[0].para = "__AMOD";
    memset(s, 0, 30);
    snprintf(s, 30, "%d", Port_CfgBuf.mode);
    strcpy(Para_Port[0].value, s);
    printf("__AMOD = %s\n", Para_Port[0].value);

    Para_Port[1].para = "__ASPT";
    memset(s, 0, 30);
    snprintf(s, 30, "%d", Port_CfgBuf.src_port[0] * 256 + Port_CfgBuf.src_port[1]);
    strcpy(Para_Port[1].value, s);
    printf("__ASPT = %s\n", Para_Port[1].value);

    Para_Port[2].para = "__ADIP";
    memset(s, 0, 30);
    snprintf(s, 30, "%d.%d.%d.%d", Port_CfgBuf.des_ip[0], Port_CfgBuf.des_ip[1],
            Port_CfgBuf.des_ip[2], Port_CfgBuf.des_ip[3]);
    strcpy(Para_Port[2].value, s);
    printf("__ADIP = %s\n", Para_Port[2].value);

    Para_Port[3].para = "__ADPT";
    memset(s, 0, 30);
    snprintf(s, 30, "%d", Port_CfgBuf.des_port[0] * 256 + Port_CfgBuf.des_port[1]);
    strcpy(Para_Port[3].value, s);
    printf("__ADPT = %s\n", Para_Port[3].value);

    Para_Login[0].para = "__AUSE";
    strcpy(Para_Login[0].value, Login_CfgBuf.user);
    printf("__AUSE = %s\n", Para_Login[0].value);

    Para_Login[1].para = "__APAS";
    strcpy(Para_Login[1].value, Login_CfgBuf.pass);
    printf("__APAS = %s\n", Para_Login[1].value);
}

/*********************************************************************
 * @fn      Data_Send
 *
 * @brief   Socket sends data.
 *
 * @return  none
 */
void Data_Send(u8 id, uint8_t *dataptr, uint32_t datalen)
{
    u32 len, totallen;
    u8 *p, timeout = 50;

    p = dataptr;
    totallen = datalen;
    while(1){
        len = totallen;
        WCHNET_SocketSend(id, p, &len);                         //Send the data
        totallen -= len;                                        //Subtract the sent length from the total length
        p += len;                                               //offset buffer pointer
        if(--timeout == 0) break;
        if(totallen) continue;                                  //If the data is not sent, continue to send
        break;                                                  //After sending, exit
    }
}


/*********************************************************************
 * @fn      strFind
 *
 * @brief   query for a specific string.
 *
 * @param   str  - source string.
 *          substr - String to be queried.
 *
 * @return  The number of data segments contained in the received data
 */
int strFind( char str[], char substr[] )
{
    int i, j, check ,count = 0;
    int len = strlen( str );
    int sublen = strlen( substr );
    for( i = 0; i < len; i++ )
    {
        check = 1;
        for( j = 0; j + i < len && j < sublen; j++ )
        {
            if( str[i + j] != substr[j] )
            {
                check = 0;
                break;
            }
        }
        if( check == 1 )
        {
            count++;
            i = i + sublen;
        }
    }
    return count;
}

/*********************************************************************
 * @fn      Web_Server
 *
 * @brief   web process function.
 *
 * @return  none
 */
void Web_Server(void)
{
    char *paraptr;
    uint8_t reqnum = 0;
    u32 resplen = 0;
    u32 pagelen = 0;

    reqnum = strFind(HTTPDataBuffer,"GET") + strFind(HTTPDataBuffer,"get") + \
             strFind(HTTPDataBuffer,"POST") + strFind(HTTPDataBuffer,"post");

    while(reqnum){
        reqnum--;
        ParseHttpRequest(&http_request, HTTPDataBuffer);
        switch (http_request.METHOD)
        {
            case METHOD_ERR:
                break;

            case METHOD_POST:                                       //'post' request
                name = http_request.URL;
                ParseURLType(&http_request.TYPE, name);

                if (strstr(name, "main") != NULL) {                 //Request the "main" page
                    pagelen = strlen(Html_main);
                    copy_flash(Html_main, pagelen);
                }
                else if(strstr(name, "success") != NULL) {          //Request "success" page
                    pagelen = strlen(Html_success);
                    copy_flash(Html_success, pagelen);

                    paraptr = (char *) HTTPDataBuffer;
                    if (strstr(paraptr, "__PMAC") != NULL) {             //Configuration information with "Basic" pages
                        Refresh_Basic(paraptr);
                    }

                    if (strstr(paraptr, "__PMOD") != NULL) {             //Configuration information with "Port" page
                        Refresh_Port(paraptr);
                    }

                    if (strstr(paraptr, "__PUSE") != NULL) {             //Configuration information with "User" page
                        Refresh_Login(paraptr);
                    }
                }
                /*Analyze the requested resource type and return the response*/
                MakeHttpResponse(httpweb, http_request.TYPE, pagelen);
                resplen = strlen(httpweb);
                Data_Send(socket, httpweb, resplen);

                Data_Send(socket, HtmlBuffer, pagelen);
                /*After the request is processed, the current
                 * socket connection is closed, and a new connection
                 * will be established when the browser sends the next
                 * request.*/
                WCHNET_SocketClose(socket, TCP_CLOSE_NORMAL);
                break;

            case METHOD_GET:                                        //'get' request
                name = http_request.URL;
                ParseURLType(&http_request.TYPE, name);

                if(strstr(name, "HTTP") != NULL) {
                    pagelen = Refresh_Html(Html_login, Para_Login, 2);
                }
                else if(strstr(name, "main") != NULL) {             //Request to get the "main" web page
                    pagelen = strlen(Html_main);
                    copy_flash(Html_main, pagelen);
                }
                else if(strstr(name, "basic") != NULL) {            //Request to get the "basic" web page
                    pagelen = Refresh_Html(Html_basic, Para_Basic, 4);
                }
                else if(strstr(name, "port") != NULL) {             //Request to get the "port" page
                    pagelen = Refresh_Html(Html_port, Para_Port, 4);
                }
                else if(strstr(name, "user") != NULL) {             //Request to get the "user" web page
                    pagelen = Refresh_Html(Html_user, Para_Login, 2);
                }
                else if(strstr(name, "about") != NULL) {            //Request to get the "about" page
                    pagelen = strlen(Html_about);
                    copy_flash(Html_about, pagelen);
                }
                else if(strstr(name, "logo") != NULL) {             //Request for "logo" image
                    pagelen = sizeof(Html_logo);
                    copy_flash(Html_logo, pagelen);
                }
                else if(strstr(name, "png1") != NULL) {             //Request to get "png1" image
                    pagelen = sizeof(Html_png1);
                    copy_flash(Html_png1, pagelen);
                }
                else if(strstr(name, "png2") != NULL) {             //Request to get "png2" image
                    pagelen = sizeof(Html_png2);
                    copy_flash(Html_png2, pagelen);
                }
                else if(strstr(name, "png3") != NULL) {             //Request to get "png3" image
                    pagelen = sizeof(Html_png3);
                    copy_flash(Html_png3, pagelen);
                }
                else if(strstr(name, "png4") != NULL) {
                    pagelen = sizeof(Html_png4);
                    copy_flash(Html_png4, pagelen);
                }
                else if(strstr(name, "weixin") != NULL) {           //Request for "weixin" image
                    pagelen = sizeof(Html_weixin);
                    copy_flash(Html_weixin, pagelen);
                }
                else if(strstr(name, "style") != NULL) {            //Request to get the "style" css stylesheet file
                    pagelen = strlen(Html_style);
                    copy_flash(Html_style, pagelen);
                }
                /*Analyze the requested resource type and return the response*/
                MakeHttpResponse(httpweb, http_request.TYPE, pagelen);
                resplen = strlen(httpweb);
                Data_Send(socket, httpweb, resplen);
                Data_Send(socket, HtmlBuffer, pagelen);
                break;

            default:
                break;
        }
    }
    /*After the request is processed, the current
     * socket connection is closed, and a new connection
     * will be established when the browser sends the next
     * request.*/
    WCHNET_SocketClose(socket, TCP_CLOSE_NORMAL);
    memset(HTTPDataBuffer, 0,sizeof(HTTPDataBuffer));
}
